/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.vectordrawable.VdParser;
import com.android.ide.common.vectordrawable.VdTree;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Icon;

public class VdIcon
implements Icon,
Comparable<VdIcon> {
    private VdTree mVdTree;
    private final String mName;
    private final URL mUrl;

    public VdIcon(URL url) {
        this.setDynamicIcon(url);
        this.mUrl = url;
        String fileName = url.getFile();
        this.mName = fileName.substring(fileName.lastIndexOf("/") + 1);
    }

    public String getName() {
        return this.mName;
    }

    public URL getURL() {
        return this.mUrl;
    }

    public void setDynamicIcon(URL url) {
        VdParser p = new VdParser();
        try {
            this.mVdTree = p.parse(url.openStream(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int minSize = Math.min(c.getWidth(), c.getHeight());
        BufferedImage image = AssetUtil.newArgbBufferedImage(minSize, minSize);
        this.mVdTree.drawIntoImage(image);
        Rectangle rect = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        AssetUtil.drawCenterInside((Graphics2D)g, image, rect);
    }

    @Override
    public int getIconWidth() {
        return (int)(this.mVdTree != null ? this.mVdTree.mPortWidth : 0.0f);
    }

    @Override
    public int getIconHeight() {
        return (int)(this.mVdTree != null ? this.mVdTree.mPortHeight : 0.0f);
    }

    @Override
    public int compareTo(VdIcon other) {
        return this.mName.compareTo(other.mName);
    }
}

