/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.process;

import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public abstract class BaseProcessOutputHandler
implements ProcessOutputHandler {
    @Override
    public ProcessOutput createOutput() {
        return new BaseProcessOutput();
    }

    private static String getString(ByteArrayOutputStream stream) throws ProcessException {
        try {
            return stream.toString(Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcessException(e);
        }
    }

    public static final class BaseProcessOutput
    implements ProcessOutput {
        private final ByteArrayOutputStream mStandardOutput = new ByteArrayOutputStream();
        private final ByteArrayOutputStream mErrorOutput = new ByteArrayOutputStream();

        @Override
        public OutputStream getStandardOutput() {
            return this.mStandardOutput;
        }

        @Override
        public OutputStream getErrorOutput() {
            return this.mErrorOutput;
        }

        public String getStandardOutputAsString() throws ProcessException {
            return BaseProcessOutputHandler.getString(this.mStandardOutput);
        }

        public String getErrorOutputAsString() throws ProcessException {
            return BaseProcessOutputHandler.getString(this.mErrorOutput);
        }
    }
}

