/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.packaging;

import com.google.common.collect.ImmutableList;

public class PackagingUtils {
    public static final ImmutableList<String> NON_RESOURCES_EXTENSIONS = ImmutableList.builder().add((Object)"aidl").add((Object)"rs").add((Object)"fs").add((Object)"rsh").add((Object)"d").add((Object)"java").add((Object)"scala").add((Object)"class").add((Object)"so").add((Object)"scc").add((Object)"swp").build();
    public static final ImmutableList<String> NON_RESOURCES_FILENAMES = ImmutableList.builder().add((Object)"thumbs.db").add((Object)"picasa.ini").add((Object)"about.html").add((Object)"package.html").add((Object)"overview.html").build();

    public static boolean checkFolderForPackaging(String folderName) {
        return !folderName.equalsIgnoreCase("CVS") && !folderName.equalsIgnoreCase(".svn") && !folderName.equalsIgnoreCase("SCCS") && !folderName.startsWith("_");
    }

    public static boolean checkFileForPackaging(String fileName) {
        String[] fileSegments = fileName.split("\\.");
        String fileExt = "";
        if (fileSegments.length > 1) {
            fileExt = fileSegments[fileSegments.length - 1];
        }
        return PackagingUtils.checkFileForPackaging(fileName, fileExt);
    }

    public static boolean checkFileForPackaging(String fileName, String extension) {
        return fileName.charAt(0) != '.' && fileName.charAt(fileName.length() - 1) != '~' && !PackagingUtils.isOfNonResourcesExtensions(extension) && !PackagingUtils.isNotAResourceFile(fileName);
    }

    private static boolean isOfNonResourcesExtensions(String extension) {
        for (String ext : NON_RESOURCES_EXTENSIONS) {
            if (!ext.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotAResourceFile(String fileName) {
        for (String name : NON_RESOURCES_FILENAMES) {
            if (!name.equalsIgnoreCase(fileName)) continue;
            return true;
        }
        return false;
    }
}

