/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.google.common.collect.Iterators;
import java.io.File;
import java.util.Iterator;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.EnumConstant;
import lombok.ast.Expression;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Position;

public class JavaContext
extends Context {
    static final String SUPPRESS_COMMENT_PREFIX = "//noinspection ";
    private Node mCompilationUnit;
    private final JavaParser mParser;

    public JavaContext(LintDriver driver, Project project, Project main, File file, JavaParser parser) {
        super(driver, project, main, file);
        this.mParser = parser;
    }

    public Location getLocation(Node node) {
        return this.mParser.getLocation(this, node);
    }

    public JavaParser getParser() {
        return this.mParser;
    }

    public Node getCompilationUnit() {
        return this.mCompilationUnit;
    }

    public void setCompilationUnit(Node compilationUnit) {
        this.mCompilationUnit = compilationUnit;
    }

    @Override
    public void report(Issue issue, Location location, String message) {
        if (this.mDriver.isSuppressed(this, issue, this.mCompilationUnit)) {
            return;
        }
        super.report(issue, location, message);
    }

    public void report(Issue issue, Node scope, Location location, String message) {
        if (scope != null && this.mDriver.isSuppressed(this, issue, scope)) {
            return;
        }
        super.report(issue, location, message);
    }

    @Deprecated
    public void report(Issue issue, Node scope, Location location, String message, Object data) {
        this.report(issue, scope, location, message);
    }

    public static Node findSurroundingMethod(Node scope) {
        while (scope != null) {
            Class<?> type = scope.getClass();
            if (type == MethodDeclaration.class || type == ConstructorDeclaration.class) {
                return scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    public static ClassDeclaration findSurroundingClass(Node scope) {
        while (scope != null) {
            Class<?> type = scope.getClass();
            if (type == ClassDeclaration.class) {
                return (ClassDeclaration)scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    @Override
    protected String getSuppressCommentPrefix() {
        return SUPPRESS_COMMENT_PREFIX;
    }

    public boolean isSuppressedWithComment(Node scope, Issue issue) {
        String contents = this.getContents();
        assert (contents != null);
        Position position = scope.getPosition();
        if (position == null) {
            return false;
        }
        int start = position.getStart();
        return this.isSuppressedWithComment(start, issue);
    }

    public Location.Handle createLocationHandle(Node node) {
        return this.mParser.createLocationHandle(this, node);
    }

    public JavaParser.ResolvedNode resolve(Node node) {
        return this.mParser.resolve(this, node);
    }

    public JavaParser.ResolvedClass findClass(String fullyQualifiedName) {
        return this.mParser.findClass(this, fullyQualifiedName);
    }

    public JavaParser.TypeDescriptor getType(Node node) {
        return this.mParser.getType(this, node);
    }

    public static String getMethodName(Node call) {
        if (call instanceof MethodInvocation) {
            return ((MethodInvocation)call).astName().astValue();
        }
        if (call instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)call).astTypeReference().getTypeName();
        }
        if (call instanceof EnumConstant) {
            return ((EnumConstant)call).astName().astValue();
        }
        return null;
    }

    public static Iterator<Expression> getParameters(Node call) {
        if (call instanceof MethodInvocation) {
            return ((MethodInvocation)call).astArguments().iterator();
        }
        if (call instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)call).astArguments().iterator();
        }
        if (call instanceof EnumConstant) {
            return ((EnumConstant)call).astArguments().iterator();
        }
        return Iterators.emptyIterator();
    }

    public static Node getParameter(Node call, int parameter) {
        Iterator<Expression> iterator = JavaContext.getParameters(call);
        for (int i = 0; i < parameter - 1; ++i) {
            if (!iterator.hasNext()) {
                return null;
            }
            iterator.next();
        }
        return iterator.hasNext() ? iterator.next() : null;
    }

    public boolean isContextMethod(MethodInvocation node) {
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedClass containingClass;
        JavaParser.ResolvedNode resolved = this.resolve(node);
        return resolved instanceof JavaParser.ResolvedMethod && (containingClass = (method = (JavaParser.ResolvedMethod)resolved).getContainingClass()).isSubclassOf("android.content.Context", false);
    }

    public static <T extends Node> T getParentOfType(Node element, Class<T> clz) {
        return JavaContext.getParentOfType(element, clz, true);
    }

    public static <T extends Node> T getParentOfType(Node element, Class<T> clz, boolean strict) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getParent();
        }
        while (element != null) {
            if (clz.isInstance(element)) {
                return (T)element;
            }
            element = element.getParent();
        }
        return null;
    }

    public static <T extends Node> T getParentOfType(Node element, Class<T> clz, boolean strict, Class<? extends Node> ... terminators) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getParent();
        }
        while (element != null && !clz.isInstance(element)) {
            for (Class<? extends Node> terminator : terminators) {
                if (!terminator.isInstance(element)) continue;
                return null;
            }
            element = element.getParent();
        }
        return (T)element;
    }

    public static <T extends Node> T getNextSiblingOfType(Node sibling, Class<T> clz) {
        if (sibling == null) {
            return null;
        }
        Node parent = sibling.getParent();
        if (parent == null) {
            return null;
        }
        Iterator<Node> iterator = parent.getChildren().iterator();
        while (iterator.hasNext() && iterator.next() != sibling) {
        }
        while (iterator.hasNext()) {
            Node child = iterator.next();
            if (!clz.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public static Node getArgumentNode(MethodInvocation call, int index) {
        int i = 0;
        for (Expression parameter : call.astArguments()) {
            if (i == index) {
                return parameter;
            }
            ++i;
        }
        throw new IllegalArgumentException(Integer.toString(index));
    }
}

