/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import lombok.ast.Identifier;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;

@Beta
public abstract class JavaParser {
    public static final String TYPE_OBJECT = "java.lang.Object";
    public static final String TYPE_STRING = "java.lang.String";
    public static final String TYPE_INT = "int";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_CHAR = "char";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_NULL = "null";

    public abstract void prepareJavaParse(List<JavaContext> var1);

    public abstract Node parseJava(JavaContext var1);

    public abstract Location getLocation(JavaContext var1, Node var2);

    public abstract Location.Handle createLocationHandle(JavaContext var1, Node var2);

    public void dispose(JavaContext context, Node compilationUnit) {
    }

    public void dispose() {
    }

    public abstract ResolvedNode resolve(JavaContext var1, Node var2);

    public ResolvedClass findClass(JavaContext context, String fullyQualifiedName) {
        return null;
    }

    public abstract TypeDescriptor getType(JavaContext var1, Node var2);

    public static abstract class ResolvedVariable
    extends ResolvedNode {
        @Override
        public abstract String getName();

        public abstract boolean matches(String var1);

        public abstract TypeDescriptor getType();
    }

    public static abstract class ResolvedPackage
    extends ResolvedNode {
        @Override
        public Iterable<ResolvedAnnotation> getAnnotations() {
            return Collections.emptyList();
        }
    }

    public static abstract class ResolvedAnnotation
    extends ResolvedNode {
        @Override
        public abstract String getName();

        public abstract boolean matches(String var1);

        public abstract TypeDescriptor getType();

        public abstract ResolvedClass getClassType();

        public abstract List<Value> getValues();

        public Object getValue(String name) {
            for (Value value : this.getValues()) {
                if (!name.equals(value.name)) continue;
                return value.value;
            }
            return null;
        }

        public Object getValue() {
            return this.getValue("value");
        }

        @Override
        public Iterable<ResolvedAnnotation> getAnnotations() {
            return Collections.emptyList();
        }

        public static class Value {
            public final String name;
            public final Object value;

            public Value(String name, Object value) {
                this.name = name;
                this.value = value;
            }
        }
    }

    public static abstract class ResolvedField
    extends ResolvedNode {
        @Override
        public abstract String getName();

        public abstract boolean matches(String var1);

        public abstract TypeDescriptor getType();

        public abstract ResolvedClass getContainingClass();

        public abstract Object getValue();

        public String getContainingClassName() {
            return this.getContainingClass().getName();
        }

        @Override
        public boolean isInPackage(String pkg, boolean includeSubPackages) {
            String packageName = this.getContainingClass().getPackageName();
            if (pkg.equals(packageName)) {
                return true;
            }
            return includeSubPackages && packageName.length() > pkg.length() && packageName.charAt(pkg.length()) == '.' && packageName.startsWith(pkg);
        }
    }

    public static abstract class ResolvedMethod
    extends ResolvedNode {
        @Override
        public abstract String getName();

        public abstract boolean matches(String var1);

        public abstract ResolvedClass getContainingClass();

        public abstract int getArgumentCount();

        public abstract TypeDescriptor getArgumentType(int var1);

        public boolean argumentMatchesType(int index, String signature) {
            return this.getArgumentType(index).matchesSignature(signature);
        }

        public abstract TypeDescriptor getReturnType();

        public boolean isConstructor() {
            return this.getReturnType() == null;
        }

        public abstract Iterable<ResolvedAnnotation> getParameterAnnotations(int var1);

        public ResolvedAnnotation getParameterAnnotation(String type, int parameterIndex) {
            for (ResolvedAnnotation annotation : this.getParameterAnnotations(parameterIndex)) {
                if (!annotation.getType().matchesSignature(type)) continue;
                return annotation;
            }
            return null;
        }

        public ResolvedMethod getSuperMethod() {
            ResolvedClass cls = this.getContainingClass().getSuperClass();
            if (cls != null) {
                String methodName = this.getName();
                int argCount = this.getArgumentCount();
                for (ResolvedMethod method : cls.getMethods(methodName, true)) {
                    if (argCount != method.getArgumentCount()) continue;
                    boolean sameTypes = true;
                    for (int arg = 0; arg < argCount; ++arg) {
                        if (method.getArgumentType(arg).equals(this.getArgumentType(arg))) continue;
                        sameTypes = false;
                        break;
                    }
                    if (!sameTypes) continue;
                    return method;
                }
            }
            return null;
        }

        @Override
        public boolean isInPackage(String pkg, boolean includeSubPackages) {
            String packageName = this.getContainingClass().getPackageName();
            if (pkg.equals(packageName)) {
                return true;
            }
            return includeSubPackages && packageName.length() > pkg.length() && packageName.charAt(pkg.length()) == '.' && packageName.startsWith(pkg);
        }
    }

    public static abstract class ResolvedClass
    extends ResolvedNode {
        @Override
        public abstract String getName();

        public abstract String getSimpleName();

        public String getPackageName() {
            String name = this.getName();
            String simpleName = this.getSimpleName();
            if (name.length() > simpleName.length() + 1) {
                return name.substring(0, name.length() - simpleName.length() - 1);
            }
            return name;
        }

        public abstract boolean matches(String var1);

        public abstract ResolvedClass getSuperClass();

        public abstract ResolvedClass getContainingClass();

        public TypeDescriptor getType() {
            return new DefaultTypeDescriptor(this.getName());
        }

        public abstract boolean isSubclassOf(String var1, boolean var2);

        public abstract Iterable<ResolvedMethod> getConstructors();

        public abstract Iterable<ResolvedMethod> getMethods(boolean var1);

        public abstract Iterable<ResolvedMethod> getMethods(String var1, boolean var2);

        public abstract Iterable<ResolvedField> getFields(boolean var1);

        public abstract ResolvedField getField(String var1, boolean var2);

        public abstract ResolvedPackage getPackage();

        @Override
        public boolean isInPackage(String pkg, boolean includeSubPackages) {
            String packageName = this.getPackageName();
            if (pkg.equals(packageName)) {
                return true;
            }
            return includeSubPackages && packageName.length() > pkg.length() && packageName.charAt(pkg.length()) == '.' && packageName.startsWith(pkg);
        }
    }

    public static abstract class ResolvedNode {
        public abstract String getName();

        public abstract String getSignature();

        public abstract int getModifiers();

        public String toString() {
            return this.getSignature();
        }

        public abstract Iterable<ResolvedAnnotation> getAnnotations();

        public ResolvedAnnotation getAnnotation(String type) {
            for (ResolvedAnnotation annotation : this.getAnnotations()) {
                if (!annotation.getType().matchesSignature(type)) continue;
                return annotation;
            }
            return null;
        }

        public boolean isInPackage(String pkg, boolean includeSubPackages) {
            return this.getSignature().startsWith(pkg);
        }
    }

    public static class DefaultTypeDescriptor
    extends TypeDescriptor {
        private String mName;

        public DefaultTypeDescriptor(String name) {
            this.mName = name;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public String getSignature() {
            return this.getName();
        }

        @Override
        public boolean matchesName(String name) {
            return this.mName.equals(name);
        }

        @Override
        public boolean matchesSignature(String signature) {
            return this.matchesName(signature);
        }

        public String toString() {
            return this.getSignature();
        }

        @Override
        public ResolvedClass getTypeClass() {
            return null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultTypeDescriptor that = (DefaultTypeDescriptor)o;
            return !(this.mName == null ? that.mName != null : !this.mName.equals(that.mName));
        }

        public int hashCode() {
            return this.mName != null ? this.mName.hashCode() : 0;
        }
    }

    public static abstract class TypeDescriptor {
        public abstract String getName();

        public abstract String getSignature();

        public abstract boolean matchesName(String var1);

        public abstract boolean matchesSignature(String var1);

        public TypeReference getNode() {
            TypeReference typeReference = new TypeReference();
            StrictListAccessor<TypeReferencePart, TypeReference> parts = typeReference.astParts();
            for (String part : Splitter.on((char)'.').split((CharSequence)this.getName())) {
                Identifier identifier = Identifier.of(part);
                parts.addToEnd(new TypeReferencePart[]{new TypeReferencePart().astIdentifier(identifier)});
            }
            return typeReference;
        }

        public abstract ResolvedClass getTypeClass();

        public abstract boolean equals(Object var1);
    }
}

