/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public final class ProjectTemplateStore {
    private static final String KEY = "org.eclipse.cdt.ui.text.custom_code_templates";
    private final TemplateStore fInstanceStore = CUIPlugin.getDefault().getCodeTemplateStore();
    private final TemplateStore fProjectStore;

    public ProjectTemplateStore(IProject project) {
        if (project == null) {
            this.fProjectStore = null;
        } else {
            final ScopedPreferenceStore projectSettings = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "org.eclipse.cdt.ui");
            this.fProjectStore = new TemplateStore((IPreferenceStore)projectSettings, KEY){

                public void add(TemplatePersistenceData data) {
                    if (data.isUserAdded()) {
                        super.add(data);
                    } else {
                        this.internalAdd(data);
                    }
                }

                public void save() throws IOException {
                    StringWriter output = new StringWriter();
                    TemplateReaderWriter writer = new TemplateReaderWriter();
                    writer.save(this.getTemplateData(false), (Writer)output);
                    projectSettings.setValue(ProjectTemplateStore.KEY, output.toString());
                    projectSettings.save();
                }
            };
        }
    }

    public static boolean hasProjectSpecificTempates(IProject project) {
        String pref = new ProjectScope(project).getNode("org.eclipse.cdt.ui").get(KEY, null);
        if (pref != null && pref.trim().length() > 0) {
            StringReader input = new StringReader(pref);
            TemplateReaderWriter reader = new TemplateReaderWriter();
            try {
                TemplatePersistenceData[] datas = reader.read((Reader)input);
                return datas.length > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public TemplatePersistenceData[] getTemplateData() {
        if (this.fProjectStore != null) {
            return this.fProjectStore.getTemplateData(true);
        }
        return this.fInstanceStore.getTemplateData(true);
    }

    public Template findTemplateById(String id) {
        Template template = null;
        if (this.fProjectStore != null) {
            template = this.fProjectStore.findTemplateById(id);
        }
        if (template == null) {
            template = this.fInstanceStore.findTemplateById(id);
        }
        return template;
    }

    public void load() throws IOException {
        if (this.fProjectStore != null) {
            TemplatePersistenceData[] data;
            this.fProjectStore.load();
            HashSet<String> datas = new HashSet<String>();
            TemplatePersistenceData[] templatePersistenceDataArray = data = this.fProjectStore.getTemplateData(false);
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                TemplatePersistenceData element = templatePersistenceDataArray[n2];
                String id = element.getId();
                if (id == null) {
                    id = element.getTemplate().getName();
                }
                datas.add(id);
                ++n2;
            }
            templatePersistenceDataArray = data = this.fInstanceStore.getTemplateData(false);
            n = data.length;
            n2 = 0;
            while (n2 < n) {
                TemplatePersistenceData orig = templatePersistenceDataArray[n2];
                String origId = orig.getId();
                if (origId == null) {
                    origId = orig.getTemplate().getName();
                }
                if (!datas.contains(orig.getId())) {
                    TemplatePersistenceData copy = new TemplatePersistenceData(new Template(orig.getTemplate()), orig.isEnabled(), orig.getId());
                    this.fProjectStore.add(copy);
                    copy.setDeleted(true);
                }
                ++n2;
            }
        }
    }

    public boolean isProjectSpecific(String id) {
        if (id == null) {
            return false;
        }
        if (this.fProjectStore == null) {
            return false;
        }
        return this.fProjectStore.findTemplateById(id) != null;
    }

    public void setProjectSpecific(String id, boolean projectSpecific) {
        Assert.isNotNull((Object)this.fProjectStore);
        TemplatePersistenceData data = this.fProjectStore.getTemplateData(id);
        if (data == null) {
            return;
        }
        data.setDeleted(!projectSpecific);
    }

    public void restoreDefaults() {
        if (this.fProjectStore == null) {
            this.fInstanceStore.restoreDefaults();
        } else {
            this.fProjectStore.restoreDefaults();
        }
    }

    public void save() throws IOException {
        if (this.fProjectStore == null) {
            this.fInstanceStore.save();
        } else {
            this.fProjectStore.save();
        }
    }

    public void revertChanges() throws IOException {
        if (this.fProjectStore == null) {
            this.fInstanceStore.load();
        }
    }

    public void addTemplateData(TemplatePersistenceData data) {
        if (this.fProjectStore != null) {
            this.fProjectStore.add(data);
        } else {
            this.fInstanceStore.add(data);
        }
    }

    public void delete(TemplatePersistenceData data) {
        if (this.fProjectStore != null) {
            this.fProjectStore.delete(data);
        } else {
            this.fInstanceStore.delete(data);
        }
    }
}

