/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTNodeFactoryFactory;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNodeFactory;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodData;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.InsertLocation;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.Messages;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodDefinitionInsertLocationFinder;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodToImplementConfig;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterHandler;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterInfo;
import org.eclipse.cdt.internal.ui.refactoring.utils.Checks;
import org.eclipse.cdt.internal.ui.refactoring.utils.DefinitionFinder;
import org.eclipse.cdt.internal.ui.refactoring.utils.NameHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class ImplementMethodRefactoring
extends CRefactoring {
    private ICPPASTFunctionDeclarator createdMethodDeclarator;
    private ImplementMethodData data = new ImplementMethodData();
    private MethodDefinitionInsertLocationFinder methodDefinitionInsertLocationFinder = new MethodDefinitionInsertLocationFinder();
    private Map<IASTSimpleDeclaration, InsertLocation> insertLocations = new HashMap<IASTSimpleDeclaration, InsertLocation>();
    private static ICPPNodeFactory nodeFactory = ASTNodeFactoryFactory.getDefaultCPPNodeFactory();

    public ImplementMethodRefactoring(ICElement element, ISelection selection, ICProject project) {
        super(element, selection, project);
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
        if (!this.initStatus.hasFatalError()) {
            List<IASTSimpleDeclaration> unimplementedMethodDeclarations = this.findUnimplementedMethodDeclarations(pm);
            if (unimplementedMethodDeclarations.isEmpty()) {
                this.initStatus.addFatalError(Messages.ImplementMethodRefactoring_NoMethodToImplement);
            } else {
                IASTSimpleDeclaration methodDeclaration;
                this.data.setMethodDeclarations(unimplementedMethodDeclarations);
                if (this.selectedRegion.getLength() > 0 && NodeHelper.isMethodDeclaration(methodDeclaration = SelectionHelper.findFirstSelectedDeclaration(this.selectedRegion, this.getAST(this.tu, pm)))) {
                    for (MethodToImplementConfig config : this.data.getMethodDeclarations()) {
                        if (config.getDeclaration() != methodDeclaration) continue;
                        config.setChecked(true);
                    }
                }
            }
        }
        sm.done();
        return this.initStatus;
    }

    private List<IASTSimpleDeclaration> findUnimplementedMethodDeclarations(IProgressMonitor pm) throws OperationCanceledException, CoreException {
        final SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        IASTTranslationUnit ast = this.getAST(this.tu, (IProgressMonitor)sm.newChild(1));
        final ArrayList<IASTSimpleDeclaration> list = new ArrayList<IASTSimpleDeclaration>();
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                IASTDeclarator[] declarators;
                IBinding binding;
                IASTSimpleDeclaration simpleDeclaration;
                if (declaration instanceof IASTSimpleDeclaration && NodeHelper.isMethodDeclaration(simpleDeclaration = (IASTSimpleDeclaration)declaration) && ImplementMethodRefactoring.this.isUnimplementedMethodBinding(binding = (declarators = simpleDeclaration.getDeclarators())[0].getName().resolveBinding(), (IProgressMonitor)sm.newChild(0))) {
                    list.add(simpleDeclaration);
                    return 1;
                }
                return 3;
            }
        });
        return list;
    }

    private boolean isUnimplementedMethodBinding(IBinding binding, IProgressMonitor pm) {
        if (binding instanceof ICPPFunction) {
            ICPPMethod methodBinding;
            if (binding instanceof ICPPMethod && (methodBinding = (ICPPMethod)binding).isPureVirtual()) {
                return false;
            }
            try {
                return !DefinitionFinder.hasDefinition(binding, this.refactoringContext, pm);
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
        return false;
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        List<MethodToImplementConfig> methodsToImplement = this.data.getMethodsToImplement();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)(4 * methodsToImplement.size()));
        for (MethodToImplementConfig config : methodsToImplement) {
            this.createDefinition(collector, config, (IProgressMonitor)sm.newChild(4));
        }
    }

    protected void createDefinition(ModificationCollector collector, MethodToImplementConfig config, IProgressMonitor subMonitor) throws CoreException, OperationCanceledException {
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IASTSimpleDeclaration decl = config.getDeclaration();
        InsertLocation insertLocation = this.findInsertLocation(decl, subMonitor);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        subMonitor.worked(1);
        IASTNode parent = insertLocation.getParentOfNodeToInsertBefore();
        IASTTranslationUnit ast = parent.getTranslationUnit();
        ASTRewrite translationUnitRewrite = collector.rewriterForTranslationUnit(ast);
        subMonitor.worked(1);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IASTNode nodeToInsertBefore = insertLocation.getNodeToInsertBefore();
        IASTDeclaration createdMethodDefinition = this.createFunctionDefinition(ast, decl, insertLocation);
        subMonitor.worked(1);
        ASTRewrite methodRewrite = translationUnitRewrite.insertBefore(parent, nodeToInsertBefore, (IASTNode)createdMethodDefinition, null);
        this.createParameterModifications(methodRewrite, config.getParaHandler());
        subMonitor.done();
    }

    private void createParameterModifications(ASTRewrite methodRewrite, ParameterHandler handler) {
        for (ParameterInfo actParameterInfo : handler.getParameterInfos()) {
            ASTRewrite parameterRewrite = methodRewrite.insertBefore((IASTNode)this.createdMethodDeclarator, null, (IASTNode)actParameterInfo.getParameter(), null);
            this.createNewNameInsertModification(actParameterInfo, parameterRewrite);
            this.createRemoveDefaultValueModification(actParameterInfo, parameterRewrite);
        }
    }

    private void createRemoveDefaultValueModification(ParameterInfo parameterInfo, ASTRewrite parameterRewrite) {
        if (parameterInfo.hasDefaultValue()) {
            parameterRewrite.remove(parameterInfo.getDefaultValueNode(), null);
        }
    }

    private void createNewNameInsertModification(ParameterInfo parameterInfo, ASTRewrite parameterRewrite) {
        if (parameterInfo.hasNewName()) {
            IASTName insertNode = parameterInfo.getNewNameNode();
            IASTName replaceNode = parameterInfo.getNameNode();
            parameterRewrite.replace((IASTNode)replaceNode, (IASTNode)insertNode, null);
        }
    }

    private InsertLocation findInsertLocation(IASTSimpleDeclaration methodDeclaration, IProgressMonitor subMonitor) throws CoreException {
        if (this.insertLocations.containsKey(methodDeclaration)) {
            return this.insertLocations.get(methodDeclaration);
        }
        InsertLocation insertLocation = this.methodDefinitionInsertLocationFinder.find(this.tu, methodDeclaration.getFileLocation(), methodDeclaration.getParent(), this.refactoringContext, subMonitor);
        if (insertLocation.getTranslationUnit() == null || NodeHelper.isContainedInTemplateDeclaration((IASTNode)methodDeclaration)) {
            insertLocation.setNodeToInsertAfter(NodeHelper.findTopLevelParent((IASTNode)methodDeclaration), this.tu);
        }
        this.insertLocations.put(methodDeclaration, insertLocation);
        return insertLocation;
    }

    private IASTDeclaration createFunctionDefinition(IASTTranslationUnit unit, IASTSimpleDeclaration methodDeclaration, InsertLocation insertLocation) throws CoreException {
        String currentFileName;
        IASTDeclSpecifier declSpecifier = methodDeclaration.getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations);
        ICPPASTFunctionDeclarator functionDeclarator = (ICPPASTFunctionDeclarator)methodDeclaration.getDeclarators()[0];
        IASTNode declarationParent = methodDeclaration.getParent();
        if (declSpecifier instanceof ICPPASTDeclSpecifier) {
            ((ICPPASTDeclSpecifier)declSpecifier).setVirtual(false);
            ((ICPPASTDeclSpecifier)declSpecifier).setExplicit(false);
        }
        if (Path.fromOSString((String)(currentFileName = declarationParent.getNodeLocations()[0].asFileLocation().getFileName())).equals((Object)insertLocation.getFile().getLocation())) {
            declSpecifier.setInline(true);
        }
        if (declSpecifier.getStorageClass() == 3) {
            declSpecifier.setStorageClass(0);
        }
        ICPPASTQualifiedName qName = this.createQualifiedNameFor((IASTFunctionDeclarator)functionDeclarator, declarationParent, insertLocation);
        this.createdMethodDeclarator = nodeFactory.newFunctionDeclarator((IASTName)qName);
        this.createdMethodDeclarator.setConst(functionDeclarator.isConst());
        this.createdMethodDeclarator.setRefQualifier(functionDeclarator.getRefQualifier());
        IASTPointerOperator[] iASTPointerOperatorArray = functionDeclarator.getPointerOperators();
        int n = iASTPointerOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPointerOperator pop = iASTPointerOperatorArray[n2];
            this.createdMethodDeclarator.addPointerOperator(pop.copy(IASTNode.CopyStyle.withLocations));
            ++n2;
        }
        IASTTypeId[] exceptionSpecification = functionDeclarator.getExceptionSpecification();
        if (exceptionSpecification != ICPPASTFunctionDeclarator.NO_EXCEPTION_SPECIFICATION) {
            this.createdMethodDeclarator.setEmptyExceptionSpecification();
            IASTTypeId[] iASTTypeIdArray = exceptionSpecification;
            int n3 = exceptionSpecification.length;
            n = 0;
            while (n < n3) {
                IASTTypeId typeId = iASTTypeIdArray[n];
                this.createdMethodDeclarator.addExceptionSpecificationTypeId(typeId == null ? null : typeId.copy(IASTNode.CopyStyle.withLocations));
                ++n;
            }
        }
        ICPPASTFunctionDefinition functionDefinition = nodeFactory.newFunctionDefinition(declSpecifier, (IASTFunctionDeclarator)this.createdMethodDeclarator, (IASTStatement)nodeFactory.newCompoundStatement());
        functionDefinition.setParent((IASTNode)unit);
        ICPPASTTemplateDeclaration templateDeclaration = (ICPPASTTemplateDeclaration)ASTQueries.findAncestorWithType((IASTNode)declarationParent, ICPPASTTemplateDeclaration.class);
        if (templateDeclaration != null) {
            ICPPASTTemplateDeclaration newTemplateDeclaration = nodeFactory.newTemplateDeclaration((IASTDeclaration)functionDefinition);
            newTemplateDeclaration.setParent((IASTNode)unit);
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = templateDeclaration.getTemplateParameters();
            int n4 = iCPPASTTemplateParameterArray.length;
            int n5 = 0;
            while (n5 < n4) {
                ICPPASTTemplateParameter templateParameter = iCPPASTTemplateParameterArray[n5];
                newTemplateDeclaration.addTemplateParameter(templateParameter.copy(IASTNode.CopyStyle.withLocations));
                ++n5;
            }
            return newTemplateDeclaration;
        }
        return functionDefinition;
    }

    private ICPPASTQualifiedName createQualifiedNameFor(IASTFunctionDeclarator functionDeclarator, IASTNode declarationParent, InsertLocation insertLocation) throws CoreException {
        int insertOffset = insertLocation.getInsertPosition();
        return NameHelper.createQualifiedNameFor(functionDeclarator.getName(), this.tu, functionDeclarator.getFileLocation().getNodeOffset(), insertLocation.getTranslationUnit(), insertOffset, this.refactoringContext);
    }

    public ImplementMethodData getRefactoringData() {
        return this.data;
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        return null;
    }

    private IFile[] getAllFilesToModify() {
        ArrayList<IFile> files = new ArrayList<IFile>(2);
        IFile file = (IFile)this.tu.getResource();
        if (file != null) {
            files.add(file);
        }
        for (InsertLocation insertLocation : this.insertLocations.values()) {
            if (insertLocation == null || (file = insertLocation.getFile()) == null) continue;
            files.add(file);
        }
        return files.toArray(new IFile[files.size()]);
    }

    @Override
    protected RefactoringStatus checkFinalConditions(IProgressMonitor subProgressMonitor, CheckConditionsContext checkContext) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.isOneOrMoreImplementationInHeader(subProgressMonitor)) {
            result.addInfo(Messages.ImplementMethodRefactoring_NoImplFile);
        }
        Checks.addModifiedFilesToChecker(this.getAllFilesToModify(), checkContext);
        return result;
    }

    private boolean isOneOrMoreImplementationInHeader(IProgressMonitor subProgressMonitor) throws CoreException {
        for (MethodToImplementConfig config : this.data.getMethodsToImplement()) {
            IASTSimpleDeclaration decl = config.getDeclaration();
            this.findInsertLocation(decl, subProgressMonitor);
        }
        if (this.insertLocations.isEmpty()) {
            return true;
        }
        for (InsertLocation insertLocation : this.insertLocations.values()) {
            if (insertLocation == null || !this.tu.equals(insertLocation.getTranslationUnit())) continue;
            return true;
        }
        return false;
    }
}

