/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractlocalvariable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.dom.rewrite.DeclarationGenerator;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarationStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTEqualsInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.NodeContainer;
import org.eclipse.cdt.internal.ui.refactoring.VariableNameInformation;
import org.eclipse.cdt.internal.ui.refactoring.extractlocalvariable.ExtractLocalVariableRefactoringDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.extractlocalvariable.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.cdt.internal.ui.util.NameComposer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractLocalVariableRefactoring
extends CRefactoring {
    public static final String ID = "org.eclipse.cdt.internal.ui.refactoring.extractlocalvariable.ExtractLocalVariableRefactoring";
    private IASTExpression target;
    private final VariableNameInformation info = new VariableNameInformation();
    private NodeContainer container;

    public ExtractLocalVariableRefactoring(ICElement element, ISelection selection, ICProject project) {
        super(element, selection, project);
        this.name = Messages.ExtractLocalVariable;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        boolean oneMarked;
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        RefactoringStatus status = super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
        if (status.hasError()) {
            return status;
        }
        this.container = this.findAllExpressions(pm);
        if (this.container.isEmpty()) {
            this.initStatus.addFatalError(Messages.ExpressionMustBeSelected);
            return this.initStatus;
        }
        sm.worked(1);
        if (ExtractLocalVariableRefactoring.isProgressMonitorCanceled((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        boolean bl = oneMarked = this.selectedRegion != null && this.isOneMarked(this.container.getNodesToWrite(), this.selectedRegion);
        if (!oneMarked) {
            this.initStatus.addFatalError(this.target == null ? Messages.NoExpressionSelected : Messages.TooManyExpressionsSelected);
            return this.initStatus;
        }
        sm.worked(1);
        if (ExtractLocalVariableRefactoring.isProgressMonitorCanceled((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        this.info.addNamesToUsedNames(this.findAllDeclaredNames());
        sm.worked(1);
        NodeHelper.findMethodContext(this.container.getNodesToWrite().get(0), this.refactoringContext, (IProgressMonitor)sm);
        sm.worked(1);
        this.info.setName(this.guessTempName());
        sm.done();
        return this.initStatus;
    }

    private ArrayList<String> findAllDeclaredNames() {
        ArrayList<String> names = new ArrayList<String>();
        IASTFunctionDefinition funcDef = (IASTFunctionDefinition)ASTQueries.findAncestorWithType((IASTNode)this.target, IASTFunctionDefinition.class);
        ICPPASTCompositeTypeSpecifier comTypeSpec = this.getCompositeTypeSpecifier(funcDef);
        if (comTypeSpec != null) {
            IASTDeclaration[] iASTDeclarationArray = comTypeSpec.getMembers();
            int n = iASTDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration decl = iASTDeclarationArray[n2];
                if (decl instanceof IASTSimpleDeclaration) {
                    IASTSimpleDeclaration simpDec = (IASTSimpleDeclaration)decl;
                    IASTDeclarator[] iASTDeclaratorArray = simpDec.getDeclarators();
                    int n3 = iASTDeclaratorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IASTDeclarator decor = iASTDeclaratorArray[n4];
                        names.add(decor.getName().getRawSignature());
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return names;
    }

    private ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier(IASTFunctionDefinition funcDef) {
        IASTNode spec;
        CPPFunction function;
        IASTDeclarator[] decls;
        IBinding binding;
        if (funcDef != null && (binding = funcDef.getDeclarator().getName().resolveBinding()) instanceof CPPFunction && (decls = (function = (CPPFunction)binding).getDeclarations()) != null && decls.length > 0 && (spec = decls[0].getParent().getParent()) instanceof ICPPASTCompositeTypeSpecifier) {
            return (ICPPASTCompositeTypeSpecifier)spec;
        }
        return null;
    }

    private boolean isOneMarked(List<IASTNode> selectedNodes, Region textSelection) {
        boolean oneMarked = false;
        for (IASTNode node : selectedNodes) {
            IASTExpression expression;
            if (!(node instanceof IASTExpression) || !(expression = (IASTExpression)node).isPartOfTranslationUnitFile() || !ExtractLocalVariableRefactoring.isExpressionInSelection(expression, textSelection)) continue;
            if (this.target == null) {
                this.target = expression;
                oneMarked = true;
                continue;
            }
            if (this.isTargetChild(expression)) continue;
            oneMarked = false;
        }
        return oneMarked;
    }

    private static boolean isExpressionInSelection(IASTExpression expression, Region selection) {
        IASTFileLocation location = expression.getFileLocation();
        int expressionStart = location.getNodeOffset();
        int expressionEnd = expressionStart + location.getNodeLength();
        int selectionStart = selection.getOffset();
        int selectionEnd = selectionStart + selection.getLength();
        return expressionStart >= selectionStart && expressionEnd <= selectionEnd;
    }

    private boolean isTargetChild(IASTExpression child) {
        if (this.target == null) {
            return false;
        }
        IASTExpression node = child;
        while (node != null) {
            if (node.getParent() == this.target) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private NodeContainer findAllExpressions(IProgressMonitor pm) throws OperationCanceledException, CoreException {
        final NodeContainer container = new NodeContainer();
        IASTTranslationUnit ast = this.getAST(this.tu, pm);
        if (ast != null) {
            ast.accept(new ASTVisitor(){
                {
                    this.shouldVisitExpressions = true;
                }

                public int visit(IASTExpression expression) {
                    if (ExtractLocalVariableRefactoring.this.isNodeInsideSelection((IASTNode)expression)) {
                        container.add((IASTNode)expression);
                        return 1;
                    }
                    return super.visit(expression);
                }
            });
        }
        return container;
    }

    private boolean isNodeInsideSelection(IASTNode node) {
        return node.isPartOfTranslationUnitFile() && SelectionHelper.isNodeInsideRegion(node, this.selectedRegion);
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        String variableName = this.info.getName();
        TextEditGroup editGroup = new TextEditGroup(Messages.CreateLocalVariable);
        IASTStatement declInsertPoint = this.getParentStatement((IASTNode)this.target);
        IASTTranslationUnit ast = this.getAST(this.tu, pm);
        IASTDeclarationStatement declaration = this.getVariableNodes(ast, variableName);
        declaration.setParent(declInsertPoint.getParent());
        ASTRewrite rewriter = collector.rewriterForTranslationUnit(ast);
        rewriter.insertBefore(declInsertPoint.getParent(), (IASTNode)declInsertPoint, (IASTNode)declaration, editGroup);
        CPPASTIdExpression idExpression = new CPPASTIdExpression((IASTName)new CPPASTName(variableName.toCharArray()));
        rewriter.replace((IASTNode)this.target, (IASTNode)idExpression, editGroup);
    }

    private IASTStatement getParentStatement(IASTNode node) {
        while (node != null) {
            if (node instanceof IASTStatement && !(node.getParent() instanceof IASTForStatement)) {
                return (IASTStatement)node;
            }
            node = node.getParent();
        }
        return null;
    }

    private IASTDeclarationStatement getVariableNodes(IASTTranslationUnit ast, String newName) {
        INodeFactory factory = ast.getASTNodeFactory();
        IASTSimpleDeclaration simple = factory.newSimpleDeclaration(null);
        DeclarationGenerator generator = DeclarationGenerator.create((INodeFactory)factory);
        IASTDeclSpecifier declSpec = generator.createDeclSpecFromType(this.target.getExpressionType());
        declSpec.setStorageClass(0);
        simple.setDeclSpecifier(declSpec);
        IASTDeclarator decl = generator.createDeclaratorFromType(this.target.getExpressionType(), newName.toCharArray());
        CPPASTEqualsInitializer init = new CPPASTEqualsInitializer();
        init.setInitializerClause((IASTInitializerClause)ExtractLocalVariableRefactoring.deblock(this.target.copy(IASTNode.CopyStyle.withLocations)));
        decl.setInitializer((IASTInitializer)init);
        simple.addDeclarator(decl);
        return new CPPASTDeclarationStatement((IASTDeclaration)simple);
    }

    private static IASTExpression deblock(IASTExpression expression) {
        IASTUnaryExpression unary;
        if (expression instanceof IASTUnaryExpression && (unary = (IASTUnaryExpression)expression).getOperator() == 11) {
            return ExtractLocalVariableRefactoring.deblock(unary.getOperand());
        }
        return expression;
    }

    public String guessTempName() {
        String[] proposals = this.guessTempNames();
        if (proposals.length == 0) {
            return this.info.getName();
        }
        String name = proposals[proposals.length - 1];
        return name;
    }

    private String[] getPrefixes() {
        String[] prefixes = new String[]{"get", "is"};
        return prefixes;
    }

    public String[] guessTempNames() {
        String name;
        IScope scope;
        final ArrayList<String> guessedTempNames = new ArrayList<String>();
        final ArrayList<String> usedNames = new ArrayList<String>();
        IASTFunctionDefinition funcDef = (IASTFunctionDefinition)ASTQueries.findAncestorWithType((IASTNode)this.target, IASTFunctionDefinition.class);
        if (funcDef != null && funcDef.getBody() instanceof IASTCompoundStatement) {
            IASTCompoundStatement body = (IASTCompoundStatement)funcDef.getBody();
            scope = body.getScope();
        } else {
            scope = null;
        }
        if (this.target != null) {
            this.target.accept(new ASTVisitor(){
                {
                    this.shouldVisitNames = true;
                    this.shouldVisitExpressions = true;
                }

                public int visit(IASTName name) {
                    this.addTempName(name.getLastName().toString());
                    return super.visit(name);
                }

                public int visit(IASTExpression expression) {
                    IASTIdExpression idExpression;
                    IASTFunctionCallExpression functionCallExpression;
                    IASTExpression functionNameExpression;
                    if (expression == ExtractLocalVariableRefactoring.this.target && expression instanceof IASTFunctionCallExpression && (functionNameExpression = (functionCallExpression = (IASTFunctionCallExpression)expression).getFunctionNameExpression()) instanceof IASTIdExpression && (idExpression = (IASTIdExpression)functionNameExpression).getName() != null) {
                        this.addTempName(idExpression.getName().getLastName().toString());
                        if (guessedTempNames.size() > 0) {
                            return 2;
                        }
                    }
                    if (expression instanceof IASTLiteralExpression) {
                        IASTLiteralExpression literal = (IASTLiteralExpression)expression;
                        String name = null;
                        switch (literal.getKind()) {
                            case 2: {
                                name = "c";
                                break;
                            }
                            case 1: {
                                name = "f";
                                break;
                            }
                            case 0: {
                                name = "i";
                                break;
                            }
                            case 3: {
                                name = literal.toString();
                                break;
                            }
                            case 5: 
                            case 6: {
                                name = "b";
                            }
                        }
                        if (name != null) {
                            this.addTempName(name);
                        }
                    }
                    return super.visit(expression);
                }

                private void addTempName(String name) {
                    String suffix;
                    String prefix;
                    String wordDelimiter;
                    name = ExtractLocalVariableRefactoring.this.trimPrefixes(name);
                    IPreferencesService preferences = Platform.getPreferencesService();
                    int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.variable.capitalization", 4, null);
                    NameComposer composer = new NameComposer(capitalization, wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.variable.wordDelimiter", "", null), prefix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.variable.prefix", "", null), suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.variable.suffix", "", null));
                    name = composer.compose(name);
                    if (name.length() > 0) {
                        if (ExtractLocalVariableRefactoring.this.nameAvailable(name, guessedTempNames, scope)) {
                            guessedTempNames.add(name);
                        } else {
                            usedNames.add(name);
                        }
                    }
                }
            });
        }
        if (guessedTempNames.isEmpty() && (name = this.makeTempName(usedNames, scope)) != null) {
            guessedTempNames.add(name);
        }
        return guessedTempNames.toArray(new String[guessedTempNames.size()]);
    }

    private String trimPrefixes(String name) {
        String lower = name.toLowerCase();
        int start = 0;
        String[] stringArray = this.getPrefixes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (lower.startsWith(prefix) && name.length() > prefix.length()) {
                start = prefix.length();
            }
            if (lower.startsWith(prefix = String.valueOf(prefix) + "_") && name.length() > prefix.length()) {
                start = prefix.length();
            }
            ++n2;
        }
        if (start > 0) {
            String nameWithoutPrefix = name.substring(start);
            if (Character.isUpperCase(nameWithoutPrefix.charAt(0))) {
                nameWithoutPrefix = String.valueOf(nameWithoutPrefix.substring(0, 1).toLowerCase()) + nameWithoutPrefix.substring(1);
            }
            if (!Character.isJavaIdentifierStart(nameWithoutPrefix.charAt(0))) {
                nameWithoutPrefix = "_" + nameWithoutPrefix;
            }
            return nameWithoutPrefix;
        }
        return name;
    }

    private boolean nameAvailable(String name, List<String> guessedNames, IScope scope) {
        if (guessedNames.contains(name) || this.info.getUsedNames().contains(name)) {
            return false;
        }
        if (scope != null) {
            IBinding[] bindings = scope.find(name);
            return bindings == null || bindings.length == 0;
        }
        return true;
    }

    private String makeTempName(List<String> usedNames, IScope scope) {
        ArrayList<String> noNames = new ArrayList<String>();
        int i = 0;
        while (i < 10) {
            for (String used : usedNames) {
                String name = String.valueOf(used) + i;
                if (!this.nameAvailable(name, noNames, scope)) continue;
                return name;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        Map<String, String> arguments = this.getArgumentMap();
        ExtractLocalVariableRefactoringDescriptor desc = new ExtractLocalVariableRefactoringDescriptor(this.project.getProject().getName(), "Extract Local Variable Refactoring", "Extract " + this.target.getRawSignature(), arguments);
        return desc;
    }

    private Map<String, String> getArgumentMap() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("fileName", this.tu.getLocationURI().toString());
        arguments.put("selection", String.valueOf(this.selectedRegion.getOffset()) + "," + this.selectedRegion.getLength());
        arguments.put("name", this.info.getName());
        return arguments;
    }

    public VariableNameInformation getRefactoringInfo() {
        return this.info;
    }
}

