/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.eventbus.EventBus;
import com.gradleware.tooling.toolingclient.BuildActionRequest;
import com.gradleware.tooling.toolingclient.Consumer;
import com.gradleware.tooling.toolingclient.ModelRequest;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingclient.SingleBuildRequest;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniBuildInvocationsContainer;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniGradleBuildStructure;
import com.gradleware.tooling.toolingmodel.buildaction.BuildActionFactory;
import com.gradleware.tooling.toolingmodel.buildaction.ModelForAllProjectsBuildAction;
import com.gradleware.tooling.toolingmodel.repository.BuildEnvironmentUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.BuildInvocationsUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.EclipseGradleBuildUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.Environment;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.GradleBuildStructureUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.GradleBuildUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.SingleBuildModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.internal.BaseConverter;
import com.gradleware.tooling.toolingmodel.repository.internal.BaseModelRepository;
import com.gradleware.tooling.toolingmodel.repository.internal.Converter;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildInvocationsContainer;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniGradleBuildStructure;
import java.util.Map;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.gradle.BuildInvocations;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.util.GradleVersion;

public final class DefaultSingleBuildModelRepository
extends BaseModelRepository
implements SingleBuildModelRepository {
    private final FixedRequestAttributes fixedRequestAttributes;
    private final Environment environment;

    public DefaultSingleBuildModelRepository(FixedRequestAttributes fixedRequestAttributes, ToolingClient toolingClient, EventBus eventBus) {
        this(fixedRequestAttributes, toolingClient, eventBus, Environment.STANDALONE);
    }

    public DefaultSingleBuildModelRepository(FixedRequestAttributes fixedRequestAttributes, ToolingClient toolingClient, EventBus eventBus, Environment environment) {
        super(toolingClient, eventBus);
        this.fixedRequestAttributes = (FixedRequestAttributes)Preconditions.checkNotNull((Object)fixedRequestAttributes);
        this.environment = environment;
    }

    @Override
    public OmniBuildEnvironment fetchBuildEnvironment(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        ModelRequest<BuildEnvironment> request = this.createModelRequestForBuildModel(BuildEnvironment.class, transientRequestAttributes);
        Consumer<OmniBuildEnvironment> successHandler = new Consumer<OmniBuildEnvironment>(){

            public void accept(OmniBuildEnvironment result) {
                DefaultSingleBuildModelRepository.this.postEvent(new BuildEnvironmentUpdateEvent(result));
            }
        };
        BaseConverter<BuildEnvironment, OmniBuildEnvironment> converter = new BaseConverter<BuildEnvironment, OmniBuildEnvironment>(){

            @Override
            public OmniBuildEnvironment apply(BuildEnvironment buildEnvironment) {
                return DefaultOmniBuildEnvironment.from(buildEnvironment);
            }
        };
        return this.executeRequest(request, successHandler, fetchStrategy, OmniBuildEnvironment.class, converter);
    }

    @Override
    public OmniGradleBuildStructure fetchGradleBuildStructure(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        ModelRequest<GradleBuild> request = this.createModelRequestForBuildModel(GradleBuild.class, transientRequestAttributes);
        Consumer<OmniGradleBuildStructure> successHandler = new Consumer<OmniGradleBuildStructure>(){

            public void accept(OmniGradleBuildStructure result) {
                DefaultSingleBuildModelRepository.this.postEvent(new GradleBuildStructureUpdateEvent(result));
            }
        };
        BaseConverter<GradleBuild, OmniGradleBuildStructure> converter = new BaseConverter<GradleBuild, OmniGradleBuildStructure>(){

            @Override
            public OmniGradleBuildStructure apply(GradleBuild gradleBuild) {
                return DefaultOmniGradleBuildStructure.from(gradleBuild);
            }
        };
        return this.executeRequest(request, successHandler, fetchStrategy, OmniGradleBuildStructure.class, converter);
    }

    @Override
    public OmniGradleBuild fetchGradleBuild(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        final boolean requiresIsPublicFix = this.targetGradleVersionIsBetween("2.1", "2.2.1", transientRequestAttributes);
        ModelRequest<GradleProject> request = this.createModelRequestForBuildModel(GradleProject.class, transientRequestAttributes);
        Consumer<OmniGradleBuild> successHandler = new Consumer<OmniGradleBuild>(){

            public void accept(OmniGradleBuild result) {
                DefaultSingleBuildModelRepository.this.postEvent(new GradleBuildUpdateEvent(result));
            }
        };
        BaseConverter<GradleProject, OmniGradleBuild> converter = new BaseConverter<GradleProject, OmniGradleBuild>(){

            @Override
            public OmniGradleBuild apply(GradleProject gradleProject) {
                return DefaultOmniGradleBuild.from(gradleProject, requiresIsPublicFix);
            }
        };
        return this.executeRequest(request, successHandler, fetchStrategy, OmniGradleBuild.class, converter);
    }

    @Override
    public OmniEclipseGradleBuild fetchEclipseGradleBuild(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        final boolean requiresIsPublicFix = this.targetGradleVersionIsBetween("2.1", "2.2.1", transientRequestAttributes);
        ModelRequest<EclipseProject> request = this.createModelRequestForBuildModel(EclipseProject.class, transientRequestAttributes);
        Consumer<OmniEclipseGradleBuild> successHandler = new Consumer<OmniEclipseGradleBuild>(){

            public void accept(OmniEclipseGradleBuild result) {
                DefaultSingleBuildModelRepository.this.postEvent(new EclipseGradleBuildUpdateEvent(result));
            }
        };
        BaseConverter<EclipseProject, OmniEclipseGradleBuild> converter = new BaseConverter<EclipseProject, OmniEclipseGradleBuild>(){

            @Override
            public OmniEclipseGradleBuild apply(EclipseProject eclipseProject) {
                return DefaultOmniEclipseGradleBuild.from(eclipseProject, requiresIsPublicFix);
            }
        };
        return this.executeRequest(request, successHandler, fetchStrategy, OmniEclipseGradleBuild.class, converter);
    }

    @Override
    public OmniBuildInvocationsContainer fetchBuildInvocations(final TransientRequestAttributes transientRequestAttributes, final FetchStrategy fetchStrategy) {
        Preconditions.checkNotNull((Object)transientRequestAttributes);
        Preconditions.checkNotNull((Object)((Object)fetchStrategy));
        if (!this.supportsBuildInvocations(transientRequestAttributes) || !this.supportsBuildActions(transientRequestAttributes)) {
            Supplier<OmniBuildInvocationsContainer> operation = new Supplier<OmniBuildInvocationsContainer>(){

                public OmniBuildInvocationsContainer get() {
                    return DefaultSingleBuildModelRepository.this.deriveBuildInvocationsFromOtherModel(transientRequestAttributes, fetchStrategy);
                }
            };
            Consumer<OmniBuildInvocationsContainer> successHandler = new Consumer<OmniBuildInvocationsContainer>(){

                public void accept(OmniBuildInvocationsContainer result) {
                    DefaultSingleBuildModelRepository.this.postEvent(new BuildInvocationsUpdateEvent(result));
                }
            };
            Converter converter = Converter.identity();
            return this.executeRequest(operation, successHandler, fetchStrategy, OmniBuildInvocationsContainer.class, converter);
        }
        BuildActionRequest<Map<String, BuildInvocations>> request = this.createBuildActionRequestForProjectModel(BuildInvocations.class, transientRequestAttributes);
        Consumer<OmniBuildInvocationsContainer> successHandler = new Consumer<OmniBuildInvocationsContainer>(){

            public void accept(OmniBuildInvocationsContainer result) {
                DefaultSingleBuildModelRepository.this.postEvent(new BuildInvocationsUpdateEvent(result));
            }
        };
        BaseConverter<Map<String, BuildInvocations>, OmniBuildInvocationsContainer> converter = new BaseConverter<Map<String, BuildInvocations>, OmniBuildInvocationsContainer>(){

            @Override
            public OmniBuildInvocationsContainer apply(Map<String, BuildInvocations> buildInvocations) {
                return DefaultOmniBuildInvocationsContainer.from(buildInvocations);
            }
        };
        return this.executeRequest(request, successHandler, fetchStrategy, OmniBuildInvocationsContainer.class, converter);
    }

    private OmniBuildInvocationsContainer deriveBuildInvocationsFromOtherModel(TransientRequestAttributes transientRequestAttributes, FetchStrategy fetchStrategy) {
        if (fetchStrategy == FetchStrategy.FORCE_RELOAD) {
            OmniGradleBuild gradleBuild = this.fetchGradleBuild(transientRequestAttributes, FetchStrategy.FORCE_RELOAD);
            return DefaultOmniBuildInvocationsContainer.from(gradleBuild.getRootProject());
        }
        OmniGradleBuild gradleBuild = this.fetchGradleBuild(transientRequestAttributes, FetchStrategy.FROM_CACHE_ONLY);
        if (gradleBuild != null) {
            return DefaultOmniBuildInvocationsContainer.from(gradleBuild.getRootProject());
        }
        OmniEclipseGradleBuild eclipseGradleBuild = this.fetchEclipseGradleBuild(transientRequestAttributes, FetchStrategy.FROM_CACHE_ONLY);
        if (eclipseGradleBuild != null) {
            return DefaultOmniBuildInvocationsContainer.from(eclipseGradleBuild.getRootEclipseProject().getGradleProject());
        }
        gradleBuild = this.fetchGradleBuild(transientRequestAttributes, fetchStrategy);
        return DefaultOmniBuildInvocationsContainer.from(gradleBuild.getRootProject());
    }

    private boolean supportsBuildInvocations(TransientRequestAttributes transientRequestAttributes) {
        return this.targetGradleVersionIsEqualOrHigherThan("1.12", transientRequestAttributes);
    }

    private boolean supportsBuildActions(TransientRequestAttributes transientRequestAttributes) {
        if (this.environment == Environment.ECLIPSE) {
            return this.targetGradleVersionIsEqualOrHigherThan("2.3", transientRequestAttributes);
        }
        return this.targetGradleVersionIsEqualOrHigherThan("1.8", transientRequestAttributes);
    }

    private boolean targetGradleVersionIsBetween(String minVersion, String maxVersion, TransientRequestAttributes transientRequestAttributes) {
        OmniBuildEnvironment buildEnvironment = this.fetchBuildEnvironment(transientRequestAttributes, FetchStrategy.LOAD_IF_NOT_CACHED);
        GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)minVersion)) >= 0 && gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)maxVersion)) <= 0;
    }

    private boolean targetGradleVersionIsEqualOrHigherThan(String refVersion, TransientRequestAttributes transientRequestAttributes) {
        OmniBuildEnvironment buildEnvironment = this.fetchBuildEnvironment(transientRequestAttributes, FetchStrategy.LOAD_IF_NOT_CACHED);
        GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)refVersion)) >= 0;
    }

    private <T> ModelRequest<T> createModelRequestForBuildModel(Class<T> model, TransientRequestAttributes transientRequestAttributes) {
        ModelRequest request = this.getToolingClient().newModelRequest(model);
        this.fixedRequestAttributes.apply((SingleBuildRequest<?>)request);
        transientRequestAttributes.apply((Request<?>)request);
        return request;
    }

    private <T> BuildActionRequest<Map<String, T>> createBuildActionRequestForProjectModel(Class<T> model, TransientRequestAttributes transientRequestAttributes) {
        ModelForAllProjectsBuildAction<T> buildAction = BuildActionFactory.getModelForAllProjects(model);
        BuildActionRequest request = this.getToolingClient().newBuildActionRequest(buildAction);
        this.fixedRequestAttributes.apply((SingleBuildRequest<?>)request);
        transientRequestAttributes.apply((Request<?>)request);
        return request;
    }

    private <T> BuildActionRequest<T> createBuildActionRequestForBuildAction(BuildAction<T> buildAction, TransientRequestAttributes transientRequestAttributes) {
        BuildActionRequest request = this.getToolingClient().newBuildActionRequest(buildAction);
        this.fixedRequestAttributes.apply((SingleBuildRequest<?>)request);
        transientRequestAttributes.apply((Request<?>)request);
        return request;
    }
}

