/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.internal.ui.pinclone.PinCloneUtils;
import org.eclipse.cdt.debug.ui.IPinProvider;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractThreadVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbPinProvider;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.GdbExecutionContextLabelText;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.MessagesForGdbLaunchVM;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.VMDelegatingPropertiesUpdate;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;

public class ThreadVMNode
extends AbstractThreadVMNode
implements IElementLabelProvider,
IElementMementoProvider {
    private boolean fHideRunningThreadsProperty = false;
    private IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.cdt.dsf.gdb.hideRunningThreads")) {
                ThreadVMNode.this.fHideRunningThreadsProperty = (Boolean)event.getNewValue();
                ThreadVMNode.this.getDMVMProvider().refresh();
            }
        }
    };
    private static final String MEMENTO_NAME = "THREAD_MEMENTO_NAME";

    public ThreadVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
        IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fHideRunningThreadsProperty = store.getBoolean("org.eclipse.cdt.dsf.gdb.hideRunningThreads");
    }

    public void dispose() {
        GdbUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        super.dispose();
    }

    public String toString() {
        return "ThreadVMNode(" + this.getSession().getId() + ")";
    }

    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new GdbExecutionContextLabelText(MessagesForGdbLaunchVM.ThreadVMNode_No_columns__text_format, new String[]{"name_known", "name", "id_known", "id", "os_id_known", "os_id", "cores_id_known", "cores_id", "is_suspended", "state_change_reason_known", "state_change_reason", "state_change_details_known", "state_change_details"}), new LabelText(MessagesForGdbLaunchVM.ThreadVMNode_No_columns__Error__label, new String[0]), new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/thread_obj_r.gif")){
            {
                this.setPropertyNames(new String[]{"is_suspended", "pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return prop != null && pin_prop != null && pin_color_prop != null ? !prop.booleanValue() && pin_prop.booleanValue() && pin_color_prop.equals(1) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/thread_obj_g.gif")){
            {
                this.setPropertyNames(new String[]{"is_suspended", "pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return prop != null && pin_prop != null && pin_color_prop != null ? !prop.booleanValue() && pin_prop.booleanValue() && pin_color_prop.equals(0) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/thread_obj_b.gif")){
            {
                this.setPropertyNames(new String[]{"is_suspended", "pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return prop != null && pin_prop != null && pin_color_prop != null ? !prop.booleanValue() && pin_prop.booleanValue() && pin_color_prop.equals(2) : false;
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_RUNNING")){
            {
                this.setPropertyNames(new String[]{"is_suspended"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                return prop != null ? !prop.booleanValue() : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/threads_obj_r.gif")){
            {
                this.setPropertyNames(new String[]{"pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return pin_prop != null && pin_color_prop != null ? pin_prop.booleanValue() && pin_color_prop.equals(1) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/threads_obj_g.gif")){
            {
                this.setPropertyNames(new String[]{"pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return pin_prop != null && pin_color_prop != null ? pin_prop.booleanValue() && pin_color_prop.equals(0) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/threads_obj_b.gif")){
            {
                this.setPropertyNames(new String[]{"pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return pin_prop != null && pin_color_prop != null ? pin_prop.booleanValue() && pin_color_prop.equals(2) : false;
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_SUSPENDED"))}));
        return provider;
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IProcesses procService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
        IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IContainerDMContext.class);
        if (procService == null || contDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        procService.getProcessesBeingDebugged((IDMContext)contDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess() || !(this.getData() instanceof IRunControl.IExecutionDMContext[])) {
                    ThreadVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                IRunControl.IExecutionDMContext[] execDmcs = (IRunControl.IExecutionDMContext[])this.getData();
                if (ThreadVMNode.this.fHideRunningThreadsProperty) {
                    IRunControl runControl = (IRunControl)ThreadVMNode.this.getServicesTracker().getService(IRunControl.class);
                    if (runControl == null) {
                        ThreadVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    ArrayList<IRunControl.IExecutionDMContext> execDmcsNotRunning = new ArrayList<IRunControl.IExecutionDMContext>();
                    IRunControl.IExecutionDMContext[] iExecutionDMContextArray = execDmcs;
                    int n = execDmcs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRunControl.IExecutionDMContext execDmc = iExecutionDMContextArray[n2];
                        if (runControl.isSuspended(execDmc) || runControl.isStepping(execDmc)) {
                            execDmcsNotRunning.add(execDmc);
                        }
                        ++n2;
                    }
                    execDmcs = execDmcsNotRunning.toArray(new IRunControl.IExecutionDMContext[execDmcsNotRunning.size()]);
                }
                ThreadVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])execDmcs);
                update.done();
            }
        });
    }

    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        IPropertiesUpdate[] parentUpdates = new IPropertiesUpdate[updates.length];
        int i = 0;
        while (i < updates.length) {
            final IPropertiesUpdate update = updates[i];
            final ViewerCountingRequestMonitor countringRm = new ViewerCountingRequestMonitor(ImmediateExecutor.getInstance(), (IViewerUpdate)updates[i]);
            int count = 0;
            parentUpdates[i] = new VMDelegatingPropertiesUpdate(updates[i], (RequestMonitor)countringRm);
            ++count;
            IMIExecutionDMContext execDmc = (IMIExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IMIExecutionDMContext.class);
            if (execDmc != null) {
                update.setProperty("id", (Object)execDmc.getThreadId());
                IPinProvider.IPinElementColorDescriptor colorDesc = PinCloneUtils.getPinElementColorDescriptor(GdbPinProvider.getPinnedHandles(), (Object)execDmc);
                updates[i].setProperty("pin_color", colorDesc != null ? Integer.valueOf(colorDesc.getOverlayColor()) : null);
                updates[i].setProperty("pinned_context", (Object)PinCloneUtils.isPinnedTo(GdbPinProvider.getPinnedHandles(), (Object)execDmc));
            }
            if (update.getProperties().contains("name") || update.getProperties().contains("os_id") || update.getProperties().contains("cores_id")) {
                IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
                IProcesses.IThreadDMContext threadDmc = (IProcesses.IThreadDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IProcesses.IThreadDMContext.class);
                if (processService == null || threadDmc == null) {
                    update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", "Service or handle invalid", null));
                } else {
                    processService.getExecutionData(threadDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>(this.getExecutor(), (IViewerUpdate)update){

                        public void handleCompleted() {
                            if (this.isSuccess()) {
                                ThreadVMNode.this.fillThreadDataProperties(update, (IProcesses.IThreadDMData)this.getData());
                            }
                            update.setStatus(this.getStatus());
                            countringRm.done();
                        }
                    });
                    ++count;
                }
            }
            countringRm.setDoneCount(count);
            ++i;
        }
        super.updatePropertiesInSessionThread(parentUpdates);
    }

    protected void fillThreadDataProperties(IPropertiesUpdate update, IProcesses.IThreadDMData data) {
        String[] cores;
        if (data.getName() != null && data.getName().length() > 0) {
            update.setProperty("name", (Object)data.getName());
        }
        update.setProperty("os_id", (Object)data.getId());
        if (data instanceof IGDBProcesses.IGdbThreadDMData && (cores = ((IGDBProcesses.IGdbThreadDMData)data).getCores()) != null) {
            StringBuilder str = new StringBuilder();
            String[] stringArray = cores;
            int n = cores.length;
            int n2 = 0;
            while (n2 < n) {
                String core = stringArray[n2];
                str.append(core).append(',');
                ++n2;
            }
            if (str.length() > 0) {
                String coresStr = str.substring(0, str.length() - 1);
                update.setProperty("cores_id", (Object)coresStr);
            }
        }
    }

    private String produceThreadElementName(String viewName, IMIExecutionDMContext execCtx) {
        return "Thread." + execCtx.getThreadId();
    }

    public int getDeltaFlags(Object e) {
        if (this.fHideRunningThreadsProperty && e instanceof IRunControl.IResumedDMEvent) {
            return 1024;
        }
        return super.getDeltaFlags(e);
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        if (this.fHideRunningThreadsProperty && e instanceof IRunControl.IResumedDMEvent) {
            if (((IRunControl.IResumedDMEvent)e).getReason() != IRunControl.StateChangeReason.STEP) {
                VMDelta ancestorDelta = parentDelta.getParentDelta();
                ancestorDelta.setFlags(ancestorDelta.getFlags() | 0x400);
            }
            rm.done();
        } else {
            super.buildDelta(e, parentDelta, nodeOffset, rm);
        }
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementCompareRequest request = iElementCompareRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            String mementoName = memento.getString(MEMENTO_NAME);
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IMIExecutionDMContext) {
                String elementName = this.produceThreadElementName(request.getPresentationContext().getId(), (IMIExecutionDMContext)dmc);
                request.setEqual(elementName.equals(mementoName));
            }
            request.done();
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementMementoRequest request = iElementMementoRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IMIExecutionDMContext) {
                String elementName = this.produceThreadElementName(request.getPresentationContext().getId(), (IMIExecutionDMContext)dmc);
                memento.putString(MEMENTO_NAME, elementName);
            }
            request.done();
            ++n2;
        }
    }
}

