/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.exception.ExceptionHandler;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.DeviceUtils;
import org.eclipse.sequoyah.device.framework.manager.InstanceManager;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstanceBuilder;
import org.eclipse.sequoyah.device.framework.ui.DeviceUIPlugin;
import org.eclipse.sequoyah.device.framework.ui.wizard.DefaultInstanceBuilder;
import org.eclipse.sequoyah.device.framework.ui.wizard.DeviceWizardBean;
import org.eclipse.sequoyah.device.framework.ui.wizard.DeviceWizardExtensionManager;
import org.eclipse.sequoyah.device.framework.ui.wizard.IWizardProjectPage;
import org.eclipse.sequoyah.device.framework.ui.wizard.IWizardPropertyPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class AbstractNewEmulatorInstanceWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private DeviceWizardBean bean;
    private IDeviceType device;
    private String wizardId;
    private String pluginId;

    public AbstractNewEmulatorInstanceWizard(String string, String string2, String string3) {
        this.wizardId = string3;
        this.pluginId = string;
        this.device = DeviceUtils.getDeviceTypeById((String)string2);
        BasePlugin.logInfo((String)("Device for Wizard:" + this.device.getBundleName()));
        this.initializeBean();
        this.initializeWizardSettings();
        this.initializeDialogSettings();
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        BasePlugin.logInfo((String)"New Device Instance Wizard started");
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
    }

    private void initializeWizardSettings() {
        BasePlugin.logInfo((String)this.getExtensionId());
        if (this.bean != null) {
            this.setNeedsProgressMonitor(this.bean.needsProgressMonitor());
            this.setForcePreviousAndNextButtons(this.bean.forcePreviousAndNextButtons());
            this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)this.pluginId, (String)this.bean.getImage()));
            this.setWindowTitle(this.bean.getTitle());
        }
    }

    private void initializeBean() {
        this.bean = DeviceWizardExtensionManager.getInstance().getDeviceWizardBean(this.getExtensionId());
    }

    private void initializeDialogSettings() {
        String string;
        IDialogSettings iDialogSettings = DeviceUIPlugin.getDefault().getDialogSettings();
        if (iDialogSettings.getSection(string = ((Object)((Object)this)).getClass().getName()) == null) {
            iDialogSettings.addNewSection(string);
        }
        this.setDialogSettings(iDialogSettings.getSection(string));
    }

    public void dispose() {
        this.workbench = null;
        this.selection = null;
        this.bean = null;
    }

    public void addPages() {
        this.addProjectPage();
        this.addPropertiesPage();
        this.addOtherPage();
    }

    private void addPage(WizardPage wizardPage, String string, String string2) {
        wizardPage.setTitle(string);
        wizardPage.setDescription(string2);
        this.addPage((IWizardPage)wizardPage);
    }

    public void addProjectPage() {
        this.addPage(this.bean.getProjectPage(), this.bean.getProjectTitle(), this.bean.getProjectDescription());
    }

    public void addPropertiesPage() {
        this.addPage(this.bean.getPropertyPage(), this.bean.getPropertyTitle(), this.bean.getPropertyDescription());
    }

    public void addOtherPage() {
        if (this.bean.hasOtherPage()) {
            this.addPage(this.bean.getOtherPage(), this.bean.getOtherTitle(), this.bean.getOtherDescription());
        }
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        IWizardPage iWizardPage2 = null;
        if (iWizardPage2 == null && iWizardPage != null) {
            iWizardPage2 = super.getNextPage(iWizardPage);
        }
        if (iWizardPage2 != null) {
            iWizardPage2.setPreviousPage(iWizardPage);
        }
        if (iWizardPage.getName().equals("projectPage")) {
            iWizardPage2 = this.getPage("propertyPage");
        }
        return iWizardPage2;
    }

    public boolean performFinish() {
        boolean bl = false;
        try {
            final IInstanceBuilder iInstanceBuilder = this.getProjectBuilder();
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor iProgressMonitor) {
                    BasePlugin.logInfo((String)("Instance creation for Wizard:" + AbstractNewEmulatorInstanceWizard.this.getExtensionId()));
                    try {
                        InstanceManager.createProject((IDeviceType)AbstractNewEmulatorInstanceWizard.this.getDevice(), (IInstanceBuilder)iInstanceBuilder, (IProgressMonitor)iProgressMonitor);
                    }
                    catch (SequoyahException sequoyahException) {
                        ExceptionHandler.showException((SequoyahException)sequoyahException);
                    }
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
            bl = true;
        }
        catch (InvocationTargetException invocationTargetException) {
            BasePlugin.logError((String)invocationTargetException.getMessage(), (Throwable)invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            BasePlugin.logError((String)interruptedException.getMessage(), (Throwable)interruptedException);
        }
        return bl;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWizardProjectPage getDefaultProjectPage() {
        return (IWizardProjectPage)this.getPage("projectPage");
    }

    public IInstanceBuilder getProjectBuilder() {
        return new DefaultInstanceBuilder(this.getDefaultProjectPage(), this.getProperties());
    }

    public IDeviceType getDevice() {
        return this.device;
    }

    public String getExtensionId() {
        return this.wizardId;
    }

    public Properties getProperties() {
        return ((IWizardPropertyPage)this.getPage("propertyPage")).getProperties();
    }
}

