/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.view;

import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IDeviceTypeDropSupport;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.ui.view.model.ViewerInstanceNode;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.TreeItem;

public class InstanceStatusCompositeDropAdapter
implements DropTargetListener {
    private int eventDetails = 0;
    private IInstance currentInstance = null;
    private IDeviceTypeDropSupport currentDropSupport = null;

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.eventDetails = dropTargetEvent.detail;
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        IInstance iInstance;
        dropTargetEvent.detail = 0;
        this.currentInstance = iInstance = this.getInstance(dropTargetEvent);
        if (iInstance != null) {
            IDeviceTypeDropSupport iDeviceTypeDropSupport;
            this.currentDropSupport = iDeviceTypeDropSupport = this.getDropSupport(iInstance);
            if (iDeviceTypeDropSupport != null && iDeviceTypeDropSupport.canDrop(iInstance, dropTargetEvent.currentDataType, dropTargetEvent)) {
                dropTargetEvent.detail = 2;
            }
        }
    }

    public void drop(DropTargetEvent dropTargetEvent) {
        if (this.currentDropSupport != null && this.currentInstance != null) {
            this.currentDropSupport.drop(this.currentInstance, dropTargetEvent.currentDataType, dropTargetEvent);
        }
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
    }

    private IInstance getInstance(DropTargetEvent dropTargetEvent) {
        IInstance iInstance = null;
        if (dropTargetEvent.item != null && dropTargetEvent.item instanceof TreeItem) {
            Object object = ((TreeItem)dropTargetEvent.item).getData();
            ViewerInstanceNode viewerInstanceNode = null;
            if (object instanceof ViewerInstanceNode) {
                viewerInstanceNode = (ViewerInstanceNode)object;
                iInstance = viewerInstanceNode.getInstance();
            }
        }
        return iInstance;
    }

    private IDeviceTypeDropSupport getDropSupport(IInstance iInstance) {
        IDeviceTypeDropSupport iDeviceTypeDropSupport = null;
        String string = iInstance.getDeviceTypeId();
        IDeviceType iDeviceType = DeviceTypeRegistry.getInstance().getDeviceTypeById(string);
        iDeviceTypeDropSupport = iDeviceType.getDropSupport();
        return iDeviceTypeDropSupport;
    }
}

