/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.device;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.HandleViewDebug;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.hierarchyviewerlib.device.AbstractHvDevice;
import com.android.hierarchyviewerlib.device.DeviceBridge;
import com.android.hierarchyviewerlib.device.IHvDevice;
import com.android.hierarchyviewerlib.device.WindowUpdater;
import com.android.hierarchyviewerlib.models.ThemeModel;
import com.android.hierarchyviewerlib.models.ViewNode;
import com.android.hierarchyviewerlib.models.Window;
import com.android.hierarchyviewerlib.ui.util.PsdFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DdmViewDebugDevice
extends AbstractHvDevice
implements AndroidDebugBridge.IDeviceChangeListener {
    private static final String TAG = "DdmViewDebugDevice";
    private final IDevice mDevice;
    private Map<Client, List<String>> mViewRootsPerClient = new HashMap<Client, List<String>>(40);

    public DdmViewDebugDevice(IDevice device) {
        this.mDevice = device;
    }

    @Override
    public boolean initializeViewDebug() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        return this.reloadWindows();
    }

    @Override
    public boolean reloadWindows() {
        this.mViewRootsPerClient = new HashMap<Client, List<String>>(40);
        for (Client c : this.mDevice.getClients()) {
            ClientData cd = c.getClientData();
            if (cd == null || !cd.hasFeature("view-hierarchy")) continue;
            ListViewRootsHandler handler = new ListViewRootsHandler();
            try {
                HandleViewDebug.listViewRoots((Client)c, (HandleViewDebug.ViewDumpHandler)handler);
            }
            catch (IOException e) {
                Log.i((String)TAG, (String)("No connection to client: " + cd.getClientDescription()));
                continue;
            }
            ArrayList<String> viewRoots = new ArrayList<String>(handler.getViewRoots(200L, TimeUnit.MILLISECONDS));
            this.mViewRootsPerClient.put(c, viewRoots);
        }
        return true;
    }

    @Override
    public void terminateViewDebug() {
    }

    @Override
    public boolean isViewDebugEnabled() {
        return true;
    }

    @Override
    public boolean supportsDisplayListDump() {
        return true;
    }

    @Override
    public Window[] getWindows() {
        ArrayList<Window> windows = new ArrayList<Window>(10);
        for (Client c : this.mViewRootsPerClient.keySet()) {
            for (String viewRoot : this.mViewRootsPerClient.get(c)) {
                windows.add(new Window((IHvDevice)this, viewRoot, c));
            }
        }
        return windows.toArray(new Window[windows.size()]);
    }

    @Override
    public int getFocusedWindow() {
        return -1;
    }

    @Override
    public IDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public ViewNode loadWindowData(Window window) {
        Client c = window.getClient();
        if (c == null) {
            return null;
        }
        String viewRoot = window.getTitle();
        CaptureByteArrayHandler handler = new CaptureByteArrayHandler(HandleViewDebug.CHUNK_VURT);
        try {
            HandleViewDebug.dumpViewHierarchy((Client)c, (String)viewRoot, (boolean)false, (boolean)true, (HandleViewDebug.ViewDumpHandler)handler);
        }
        catch (IOException e) {
            Log.e((String)TAG, (Throwable)e);
            return null;
        }
        byte[] data = handler.getData(20L, TimeUnit.SECONDS);
        if (data == null) {
            return null;
        }
        String viewHierarchy = new String(data, Charset.forName("UTF-8"));
        return DeviceBridge.parseViewHierarchy(new BufferedReader(new StringReader(viewHierarchy)), window);
    }

    @Override
    public void loadProfileData(Window window, ViewNode viewNode) {
        Client c = window.getClient();
        if (c == null) {
            return;
        }
        String viewRoot = window.getTitle();
        CaptureByteArrayHandler handler = new CaptureByteArrayHandler(HandleViewDebug.CHUNK_VUOP);
        try {
            HandleViewDebug.profileView((Client)c, (String)viewRoot, (String)viewNode.toString(), (HandleViewDebug.ViewDumpHandler)handler);
        }
        catch (IOException e) {
            Log.e((String)TAG, (Throwable)e);
            return;
        }
        byte[] data = handler.getData(30L, TimeUnit.SECONDS);
        if (data == null) {
            Log.e((String)TAG, (String)"Timed out waiting for profile data");
            return;
        }
        try {
            boolean success = DeviceBridge.loadProfileDataRecursive(viewNode, new BufferedReader(new StringReader(new String(data))));
            if (success) {
                viewNode.setProfileRatings();
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (Throwable)e);
            return;
        }
    }

    @Override
    public Image loadCapture(Window window, ViewNode viewNode) {
        Client c = window.getClient();
        if (c == null) {
            return null;
        }
        String viewRoot = window.getTitle();
        CaptureByteArrayHandler handler = new CaptureByteArrayHandler(HandleViewDebug.CHUNK_VUOP);
        try {
            HandleViewDebug.captureView((Client)c, (String)viewRoot, (String)viewNode.toString(), (HandleViewDebug.ViewDumpHandler)handler);
        }
        catch (IOException e) {
            Log.e((String)TAG, (Throwable)e);
            return null;
        }
        byte[] data = handler.getData(10L, TimeUnit.SECONDS);
        return data == null ? null : new Image((Device)Display.getDefault(), (InputStream)new ByteArrayInputStream(data));
    }

    @Override
    public PsdFile captureLayers(Window window) {
        Client c = window.getClient();
        if (c == null) {
            return null;
        }
        String viewRoot = window.getTitle();
        CaptureLayersHandler handler = new CaptureLayersHandler();
        try {
            HandleViewDebug.captureLayers((Client)c, (String)viewRoot, (HandleViewDebug.ViewDumpHandler)handler);
        }
        catch (IOException e) {
            Log.e((String)TAG, (Throwable)e);
            return null;
        }
        return handler.getPsdFile(20L, TimeUnit.SECONDS);
    }

    @Override
    public void invalidateView(ViewNode viewNode) {
        Window window = viewNode.window;
        Client c = window.getClient();
        if (c == null) {
            return;
        }
        String viewRoot = window.getTitle();
        try {
            HandleViewDebug.invalidateView((Client)c, (String)viewRoot, (String)viewNode.toString());
        }
        catch (IOException e) {
            Log.e((String)TAG, (Throwable)e);
        }
    }

    @Override
    public void requestLayout(ViewNode viewNode) {
        Window window = viewNode.window;
        Client c = window.getClient();
        if (c == null) {
            return;
        }
        String viewRoot = window.getTitle();
        try {
            HandleViewDebug.requestLayout((Client)c, (String)viewRoot, (String)viewNode.toString());
        }
        catch (IOException e) {
            Log.e((String)TAG, (Throwable)e);
        }
    }

    @Override
    public void outputDisplayList(ViewNode viewNode) {
        Window window = viewNode.window;
        Client c = window.getClient();
        if (c == null) {
            return;
        }
        String viewRoot = window.getTitle();
        try {
            HandleViewDebug.dumpDisplayList((Client)c, (String)viewRoot, (String)viewNode.toString());
        }
        catch (IOException e) {
            Log.e((String)TAG, (Throwable)e);
        }
    }

    @Override
    public ThemeModel dumpTheme(ViewNode viewNode) {
        Window window = viewNode.window;
        Client c = window.getClient();
        if (c == null) {
            return null;
        }
        String viewRoot = window.getTitle();
        CaptureByteArrayHandler handler = new CaptureByteArrayHandler(HandleViewDebug.CHUNK_VURT);
        try {
            HandleViewDebug.dumpTheme((Client)c, (String)viewRoot, (HandleViewDebug.ViewDumpHandler)handler);
        }
        catch (IOException e) {
            Log.e((String)TAG, (Throwable)e);
            return null;
        }
        byte[] data = handler.getData(20L, TimeUnit.SECONDS);
        if (data == null) {
            return null;
        }
        String themeDump = new String(data, Charset.forName("UTF-8"));
        return DeviceBridge.parseThemeDump(new BufferedReader(new StringReader(themeDump)));
    }

    @Override
    public void addWindowChangeListener(WindowUpdater.IWindowChangeListener l) {
    }

    @Override
    public void removeWindowChangeListener(WindowUpdater.IWindowChangeListener l) {
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
    }

    public void deviceChanged(IDevice device, int changeMask) {
        if ((changeMask & 2) != 0) {
            this.reloadWindows();
        }
    }

    @Override
    public boolean isViewUpdateEnabled() {
        return true;
    }

    @Override
    public void invokeViewMethod(Window window, ViewNode viewNode, String method, List<?> args) {
        Client c = window.getClient();
        if (c == null) {
            return;
        }
        String viewRoot = window.getTitle();
        try {
            HandleViewDebug.invokeMethod((Client)c, (String)viewRoot, (String)viewNode.toString(), (String)method, (Object[])args.toArray());
        }
        catch (IOException e) {
            Log.e((String)TAG, (Throwable)e);
        }
    }

    @Override
    public boolean setLayoutParameter(Window window, ViewNode viewNode, String property, int value) {
        Client c = window.getClient();
        if (c == null) {
            return false;
        }
        String viewRoot = window.getTitle();
        try {
            HandleViewDebug.setLayoutParameter((Client)c, (String)viewRoot, (String)viewNode.toString(), (String)property, (int)value);
        }
        catch (IOException e) {
            Log.e((String)TAG, (Throwable)e);
            return false;
        }
        return true;
    }

    private static class CaptureLayersHandler
    extends HandleViewDebug.ViewDumpHandler {
        private AtomicReference<PsdFile> mPsd = new AtomicReference();

        public CaptureLayersHandler() {
            super(HandleViewDebug.CHUNK_VURT);
        }

        protected void handleViewDebugResult(ByteBuffer data) {
            byte[] b = new byte[data.remaining()];
            data.get(b);
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
            try {
                this.mPsd.set(DeviceBridge.parsePsd(dis));
            }
            catch (IOException e) {
                Log.e((String)DdmViewDebugDevice.TAG, (Throwable)e);
            }
        }

        public PsdFile getPsdFile(long timeout, TimeUnit unit) {
            this.waitForResult(timeout, unit);
            return this.mPsd.get();
        }
    }

    private static class CaptureByteArrayHandler
    extends HandleViewDebug.ViewDumpHandler {
        private AtomicReference<byte[]> mData = new AtomicReference();

        public CaptureByteArrayHandler(int type) {
            super(type);
        }

        protected void handleViewDebugResult(ByteBuffer data) {
            byte[] b = new byte[data.remaining()];
            data.get(b);
            this.mData.set(b);
        }

        public byte[] getData(long timeout, TimeUnit unit) {
            this.waitForResult(timeout, unit);
            return this.mData.get();
        }
    }

    private static class ListViewRootsHandler
    extends HandleViewDebug.ViewDumpHandler {
        private List<String> mViewRoots = Collections.synchronizedList(new ArrayList(10));

        public ListViewRootsHandler() {
            super(HandleViewDebug.CHUNK_VULW);
        }

        protected void handleViewDebugResult(ByteBuffer data) {
            int nWindows = data.getInt();
            for (int i = 0; i < nWindows; ++i) {
                int len = data.getInt();
                this.mViewRoots.add(ListViewRootsHandler.getString((ByteBuffer)data, (int)len));
            }
        }

        public List<String> getViewRoots(long timeout, TimeUnit unit) {
            this.waitForResult(timeout, unit);
            return this.mViewRoots;
        }
    }
}

