/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.actions;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.actions.ImageAction;
import com.android.hierarchyviewerlib.actions.SelectedNodeEnabledAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DisplayViewAction
extends SelectedNodeEnabledAction
implements ImageAction {
    private static DisplayViewAction sAction;
    private Image mImage;
    private Shell mShell;

    private DisplayViewAction(Shell shell) {
        super("&Display View");
        this.mShell = shell;
        this.setAccelerator(SWT.MOD1 + 68);
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        this.mImage = imageLoader.loadImage("display.png", Display.getDefault());
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.mImage));
        this.setToolTipText("Display the selected view image in a separate window");
    }

    public static DisplayViewAction getAction(Shell shell) {
        if (sAction == null) {
            sAction = new DisplayViewAction(shell);
        }
        return sAction;
    }

    public void run() {
        HierarchyViewerDirector.getDirector().showCapture(this.mShell);
    }

    @Override
    public Image getImage() {
        return this.mImage;
    }
}

