/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.project;

import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.model.AndroidProject;
import org.eclipse.andmore.android.wizards.elements.ApplicationGroup;
import org.eclipse.andmore.android.wizards.elements.LocationGroup;
import org.eclipse.andmore.android.wizards.elements.ProjectNameGroup;
import org.eclipse.andmore.android.wizards.elements.SdkTargetSelector;
import org.eclipse.andmore.android.wizards.project.NewAndroidProjectWizard;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class NewAndroidProjectMainPage
extends WizardPage {
    private static final String PAGE_NAME = "Main Page";
    private final AndroidProject project;
    private final String NEW_PROJECT_HELP = "org.eclipse.andmore.android.newproj";
    private boolean hasNativePage = false;
    private Button nativeCkb;
    private Button obfuscateCkbox;
    private final Listener modelListener = new Listener(){

        public void handleEvent(Event arg0) {
            int msgType;
            IStatus status = NewAndroidProjectMainPage.this.project.getStatus();
            int severity = status.getSeverity();
            NewAndroidProjectMainPage.this.setPageComplete(severity != 4);
            switch (severity) {
                case 0: {
                    msgType = 0;
                    break;
                }
                case 4: {
                    msgType = 3;
                    break;
                }
                case 2: {
                    msgType = 2;
                    break;
                }
                default: {
                    msgType = 0;
                }
            }
            String defaultMessage = AndroidNLS.UI_NewAndroidProjectMainPage_SubtitleCreateProject;
            NewAndroidProjectMainPage.this.setMessage(status.isOK() ? defaultMessage : status.getMessage(), msgType);
        }
    };

    public NewAndroidProjectMainPage(AndroidProject project, boolean hasNativePage) {
        super(PAGE_NAME);
        this.project = project;
        this.hasNativePage = hasNativePage;
        this.setTitle(AndroidNLS.UI_NewAndroidProjectMainPage_TitleCreateProject);
        this.setDescription(AndroidNLS.UI_NewAndroidProjectMainPage_WizardProjectDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setFont(parent.getFont());
        mainComposite.setLayout((Layout)new FillLayout(512));
        this.initializeDialogUnits((Control)mainComposite);
        ScrolledComposite scroll = new ScrolledComposite(mainComposite, 768);
        Composite innerScrollComposite = new Composite((Composite)scroll, 0);
        innerScrollComposite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        innerScrollComposite.setLayoutData((Object)data);
        data = new GridData(4, 0, true, false);
        ProjectNameGroup projectNameGroup = new ProjectNameGroup(innerScrollComposite, this.project);
        projectNameGroup.setLayoutData(data);
        data = new GridData(4, 0, true, false);
        Group groupForLocation = new Group(innerScrollComposite, 16);
        groupForLocation.setLayout((Layout)new GridLayout());
        groupForLocation.setLayoutData((Object)data);
        groupForLocation.setFont(innerScrollComposite.getFont());
        groupForLocation.setText(AndroidNLS.UI_NewAndroidProjectMainPage_LabelContents);
        LocationGroup locationGroup = new LocationGroup((Composite)groupForLocation, this.project, this);
        data = new GridData(4, 4, true, true);
        data.heightHint = 150;
        Group groupForTarget = new Group(innerScrollComposite, 16);
        groupForTarget.setLayout((Layout)new GridLayout());
        groupForTarget.setLayoutData((Object)data);
        groupForTarget.setFont(innerScrollComposite.getFont());
        groupForTarget.setText(AndroidNLS.UI_NewAndroidProjectMainPage_LabelTarget);
        SdkTargetSelector mSdkTargetSelector = new SdkTargetSelector((Composite)groupForTarget, this.project);
        Group group = new Group(innerScrollComposite, 16);
        data = new GridData(4, 0, true, false);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)data);
        group.setFont(innerScrollComposite.getFont());
        group.setText(AndroidNLS.UI_NewAndroidProjectMainPage_LabelApplication);
        final ApplicationGroup applicationGroup = new ApplicationGroup((Composite)group, this.project);
        Listener listener = new Listener(){

            public void handleEvent(Event arg0) {
                applicationGroup.updateDefaultName();
                applicationGroup.updateMinSdkVersion();
                NewAndroidProjectMainPage.this.getContainer().updateButtons();
                if (NewAndroidProjectMainPage.this.hasNativePage) {
                    if (NewAndroidProjectMainPage.this.project.getSourceType() == AndroidProject.SourceTypes.SAMPLE) {
                        NewAndroidProjectMainPage.this.nativeCkb.setEnabled(false);
                        NewAndroidProjectMainPage.this.nativeCkb.setSelection(false);
                        NewAndroidProjectMainPage.this.project.setAddNativeSupport(false);
                    } else {
                        NewAndroidProjectMainPage.this.nativeCkb.setEnabled(true);
                        NewAndroidProjectMainPage.this.project.setAddNativeSupport(NewAndroidProjectMainPage.this.nativeCkb.getSelection());
                    }
                }
                NewAndroidProjectMainPage.this.project.setNeedToObfuscate(NewAndroidProjectMainPage.this.obfuscateCkbox.getSelection());
            }
        };
        this.nativeCkb = new Button(innerScrollComposite, 32);
        this.nativeCkb.setText(AndroidNLS.UI_ProjectCreation_NativeSupport);
        if (!this.hasNativePage) {
            this.nativeCkb.setEnabled(false);
        }
        this.obfuscateCkbox = new Button(innerScrollComposite, 32);
        this.obfuscateCkbox.setText(AndroidNLS.UI_ProjectCreation_Obfuscate);
        this.obfuscateCkbox.setEnabled(true);
        projectNameGroup.addListener(1546, this.modelListener);
        projectNameGroup.addListener(1546, listener);
        locationGroup.addListener(1546, listener);
        locationGroup.addListener(1546, this.modelListener);
        applicationGroup.addListener(1546, this.modelListener);
        mSdkTargetSelector.addListener(1546, this.modelListener);
        mSdkTargetSelector.addListener(1546, listener);
        this.nativeCkb.addListener(13, listener);
        this.nativeCkb.addListener(13, this.modelListener);
        this.obfuscateCkbox.addListener(13, listener);
        this.obfuscateCkbox.addListener(13, this.modelListener);
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.setMessage(null);
        projectNameGroup.forceFocus();
        this.setControl((Control)innerScrollComposite);
        innerScrollComposite.layout(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.newproj");
        scroll.setContent((Control)innerScrollComposite);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        scroll.setMinSize(innerScrollComposite.computeSize(-1, -1));
        this.setControl((Control)mainComposite);
    }

    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    public IWizardPage getNextPage() {
        IWizardPage page = null;
        if (this.project.isAddingNativeSupport()) {
            page = this.getWizard().getPage("native_page");
        } else if (this.project.getSourceType() == AndroidProject.SourceTypes.SAMPLE) {
            page = this.getWizard().getPage(NewAndroidProjectWizard.SAMPLE_PAGE_NAME);
        }
        return page;
    }

    public boolean isPageComplete() {
        boolean canFinish = true;
        if (this.project.isAddingNativeSupport() || this.project.getSourceType() == AndroidProject.SourceTypes.SAMPLE || !super.isPageComplete()) {
            canFinish = false;
        }
        return canFinish;
    }

    public boolean canFlipToNextPage() {
        boolean canFlip = false;
        if ((this.project.isAddingNativeSupport() || this.project.getSourceType() == AndroidProject.SourceTypes.SAMPLE) && super.isPageComplete()) {
            canFlip = true;
        }
        return canFlip;
    }
}

