/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.monkey;

import java.util.List;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.monkey.options.IMonkeyOptionsConstants;
import org.eclipse.andmore.android.monkey.options.MonkeyOption;
import org.eclipse.andmore.android.monkey.options.MonkeyOptionsGroup;
import org.eclipse.andmore.android.monkey.options.MonkeyOptionsMgt;
import org.eclipse.andmore.android.wizards.monkey.AbstractPropertiesComposite;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MonkeyOptionsComposite
extends AbstractPropertiesComposite
implements IMonkeyOptionsConstants {
    private Text commandLine;
    private final int TABFOLDER_HEIGHT_HINT = 290;

    public MonkeyOptionsComposite(Composite parent, String monkeyOptions) {
        super(parent);
        MonkeyOptionsMgt.loadFromCommandLine(monkeyOptions);
        this.createUI();
    }

    private void createUI() {
        MonkeyOptionsComposite mainComposite = this;
        GridLayout mainLayout = new GridLayout();
        mainComposite.setLayout((Layout)mainLayout);
        List<MonkeyOptionsGroup> monkeyOptionsGroupsList = MonkeyOptionsMgt.getMonkeyOptionsGroupsList();
        List<MonkeyOption> monkeyOptions = null;
        TabFolder tabFolder = new TabFolder((Composite)mainComposite, 0);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 290;
        tabFolder.setLayoutData((Object)data);
        for (MonkeyOptionsGroup monkeyOptionGroup : monkeyOptionsGroupsList) {
            TabItem tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(monkeyOptionGroup.getTitle());
            Composite group = new Composite((Composite)tabFolder, 0);
            group.setLayout((Layout)new GridLayout(3, false));
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            tabItem.setControl((Control)group);
            monkeyOptions = monkeyOptionGroup.getMonkeyOptions();
            for (final MonkeyOption monkeyOption : monkeyOptions) {
                Button checkbox = new Button(group, 32);
                checkbox.setSelection(monkeyOption.isChecked());
                checkbox.setText(monkeyOption.getUserFriendlyName());
                checkbox.setToolTipText(String.valueOf(monkeyOption.getName()) + ": " + monkeyOption.getDescription());
                monkeyOption.setCheckedWidget((Widget)checkbox);
                checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean checkedStatus = ((Button)e.widget).getSelection();
                        monkeyOption.setChecked(checkedStatus);
                        MonkeyOptionsComposite.this.notifyCompositeChangeListeners();
                    }
                });
                GridData checkboxData = new GridData(0, 4, false, false);
                checkbox.setLayoutData((Object)checkboxData);
                switch (monkeyOption.getType()) {
                    case 0: {
                        checkboxData.widthHint = -1;
                        checkboxData.horizontalSpan = 3;
                        checkbox.setLayoutData((Object)checkboxData);
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.createWidgetsForTextOrNumberType(group, monkeyOption);
                        break;
                    }
                    case 2: {
                        this.createWidgetsForPathType(group, monkeyOption);
                    }
                }
            }
        }
        Composite commandLineArea = new Composite((Composite)mainComposite, 0);
        commandLineArea.setLayout((Layout)new GridLayout(2, false));
        data = new GridData(4, 4, true, true);
        commandLineArea.setLayoutData((Object)data);
        Label commandLineLabel = new Label(commandLineArea, 0);
        commandLineLabel.setText(AndroidNLS.UI_MonkeyOptions_CommandLine);
        data = new GridData(4, 4, false, true);
        commandLineLabel.setLayoutData((Object)data);
        this.commandLine = new Text(commandLineArea, 2626);
        data = new GridData(4, 4, true, true);
        commandLineArea.pack();
        data.widthHint = commandLineArea.getBounds().width - commandLineLabel.getBounds().width;
        data.heightHint = commandLineArea.getBounds().height;
        this.commandLine.setLayoutData((Object)data);
        this.commandLine.setText(MonkeyOptionsMgt.getParamList());
        this.commandLine.setEditable(false);
    }

    private void createWidgetsForTextOrNumberType(Composite parent, final MonkeyOption monkeyOption) {
        if (monkeyOption.getPreDefinedValues() == null || monkeyOption.getPreDefinedValues().size() == 0) {
            final Text inputText = new Text(parent, 2052);
            inputText.setText(monkeyOption.getValue());
            monkeyOption.setValueWidget((Widget)inputText);
            inputText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            inputText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    monkeyOption.setValue(inputText.getText());
                    MonkeyOptionsComposite.this.notifyCompositeChangeListeners();
                }
            });
        } else {
            final Combo combo = new Combo(parent, 8);
            monkeyOption.setValueWidget((Widget)combo);
            int selectedIndex = 0;
            for (String preDefinedValue : monkeyOption.getPreDefinedValues()) {
                combo.add(preDefinedValue);
                if (monkeyOption.getValue().equals(preDefinedValue)) {
                    combo.select(selectedIndex);
                    continue;
                }
                ++selectedIndex;
            }
            combo.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    monkeyOption.setValue(combo.getText());
                    MonkeyOptionsComposite.this.notifyCompositeChangeListeners();
                }
            });
        }
    }

    private void createWidgetsForPathType(Composite parent, final MonkeyOption monkeyOption) {
        final Text pathText = new Text(parent, 2052);
        pathText.setText(monkeyOption.getValue());
        monkeyOption.setValueWidget((Widget)pathText);
        pathText.setLayoutData((Object)new GridData(4, 0, true, false));
        pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                monkeyOption.setValue(pathText.getText());
                MonkeyOptionsComposite.this.notifyCompositeChangeListeners();
            }
        });
        Button pathBrowseButton = new Button(parent, 8);
        pathBrowseButton.setText(AndroidNLS.UI_General_BrowseButtonLabel);
        GridData data = new GridData(0, 0, false, false);
        pathBrowseButton.setLayoutData((Object)data);
        pathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedPath = null;
                if (monkeyOption.getTypeDetails().equals("dir")) {
                    DirectoryDialog directoryDialog = new DirectoryDialog(MonkeyOptionsComposite.this.getShell(), 4096);
                    selectedPath = directoryDialog.open();
                } else {
                    FileDialog fileDialog = new FileDialog(MonkeyOptionsComposite.this.getShell(), 4096);
                    String[] filterExtensions = new String[]{"*" + monkeyOption.getTypeDetails()};
                    fileDialog.setFilterExtensions(filterExtensions);
                    selectedPath = fileDialog.open();
                }
                if (selectedPath != null) {
                    pathText.setText(selectedPath);
                }
            }
        });
    }

    @Override
    protected void notifyCompositeChangeListeners() {
        this.commandLine.setText(MonkeyOptionsMgt.getParamList());
        super.notifyCompositeChangeListeners();
    }

    @Override
    public String getErrorMessage() {
        String errMsg = null;
        Status status = MonkeyOptionsMgt.validate();
        if (status.getSeverity() == 4) {
            errMsg = status.getMessage();
        }
        return errMsg;
    }

    public void reloadValues(String commandLine) {
        MonkeyOptionsMgt.loadFromCommandLine(commandLine);
    }
}

