/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.monkey;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.DDMSUtils;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.wizards.elements.TableWithLoadingInfo;
import org.eclipse.andmore.android.wizards.monkey.MonkeyConfigurationTab;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class MonkeyConfigurationTabTable
extends TableWithLoadingInfo<MonkeyConfigurationTab, Map<String, String>, String> {
    public MonkeyConfigurationTabTable(Composite parent, int style, String animatedTextLabel, MonkeyConfigurationTab callingPage) {
        super(parent, style, animatedTextLabel, callingPage);
    }

    @Override
    protected void addTableData(Map<String, String> elementList) {
        Map<String, String> availablePackages = elementList;
        MonkeyConfigurationTab monkeyWizardPage = (MonkeyConfigurationTab)((Object)this.getCallingPage());
        List<?> selectedPackagesPreference = monkeyWizardPage.getSelectedPackagesPreference();
        Table table = this.getTable();
        String packageName = null;
        String packagePath = null;
        for (Map.Entry<String, String> entry : availablePackages.entrySet()) {
            packageName = entry.getKey();
            packagePath = entry.getValue();
            if (monkeyWizardPage.isFilterSystem() && packagePath.toLowerCase().contains("system")) continue;
            TableItem item = new TableItem(table, 0);
            item.setText(0, packageName);
            item.setText(1, packagePath.contains("system") ? AndroidNLS.UninstallAppWizardPage_SystemLabel : AndroidNLS.UninstallAppWizardPage_UserLabel);
            if (selectedPackagesPreference == null || !selectedPackagesPreference.contains(packageName)) continue;
            item.setChecked(true);
            this.getTable().select(table.getItemCount() - 1);
        }
    }

    @Override
    protected Map<String, String> callServiceForRetrievingDataToPopulateTable(String serialNumber) {
        Map<String, String> installedPackages = null;
        if (serialNumber != null) {
            try {
                installedPackages = DDMSUtils.listInstalledPackages(serialNumber);
            }
            catch (IOException iOException) {
                installedPackages = new HashMap<String, String>(0);
            }
        }
        return installedPackages;
    }

    @Override
    protected void executeOperationsAfterTableIsPopulated() {
        MonkeyConfigurationTab monkeyWizardPage = (MonkeyConfigurationTab)((Object)this.getCallingPage());
        monkeyWizardPage.callUpdateLaunchConfigurationDialog();
    }
}

