/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.monkey;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.devices.DevicesManager;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DeviceSelectionDialog
extends ElementListSelectionDialog {
    private static final String DEV_SELECTION_CONTEXT_HELP_ID = "org.eclipse.andmore.android.deviceSelectionDialog";

    public DeviceSelectionDialog(Shell parent, String description) {
        super(parent, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String result = "";
                if (element instanceof ISerialNumbered) {
                    ISerialNumbered serialNumbered = (ISerialNumbered)element;
                    result = serialNumbered.getFullName();
                }
                return result;
            }
        });
        this.setTitle(AndroidNLS.UI_MonkeyComposite_SelectDeviceScreenTitle);
        this.setMessage(description);
        Collection<ISerialNumbered> instances = DevicesManager.getInstance().getAllDevices();
        if (instances != null && instances.size() > 0) {
            LinkedList<ISerialNumbered> filteredInstances = new LinkedList<ISerialNumbered>();
            for (ISerialNumbered instance : instances) {
                if (!DDMSFacade.isDeviceOnline(instance.getSerialNumber())) continue;
                filteredInstances.add(instance);
            }
            Object[] filteredInstancesArray = filteredInstances.toArray();
            this.setElements(filteredInstancesArray);
        }
        this.setHelpAvailable(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, DEV_SELECTION_CONTEXT_HELP_ID);
    }
}

