/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.monkey;

import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.LinkedHashSet;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractPropertiesComposite
extends Composite {
    private static final int DEFAULT_MARGIN_SIZE = 20;
    private static final Collection<PropertyCompositeChangeListener> listeners = new LinkedHashSet<PropertyCompositeChangeListener>();

    public AbstractPropertiesComposite(Composite parent) {
        super(parent, 0);
    }

    public static void addCompositeChangeListener(PropertyCompositeChangeListener listener) {
        listeners.add(listener);
    }

    public static void removeCompositeChangeListener(PropertyCompositeChangeListener listener) {
        listeners.remove(listener);
    }

    protected void notifyCompositeChangeListeners() {
        PropertyCompositeChangeEvent event = new PropertyCompositeChangeEvent(this);
        for (PropertyCompositeChangeListener listener : listeners) {
            listener.compositeChanged(event);
        }
    }

    protected void updateWidgetEnableStatus(boolean enabled, Collection<Control> controlsToUpdate) {
        for (Control control : controlsToUpdate) {
            if (control.isDisposed()) continue;
            control.setEnabled(enabled);
        }
    }

    protected final void setMainLayout(int numColumns) {
        GridLayout mainLayout = new GridLayout(numColumns, false);
        mainLayout.marginWidth = 20;
        mainLayout.marginHeight = 20;
        this.setLayout((Layout)mainLayout);
    }

    public abstract String getErrorMessage();

    public class PropertyCompositeChangeEvent
    extends EventObject {
        PropertyCompositeChangeEvent(AbstractPropertiesComposite composite) {
            super((Object)composite);
        }
    }

    public static interface PropertyCompositeChangeListener
    extends EventListener {
        public void compositeChanged(PropertyCompositeChangeEvent var1);
    }
}

