/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.installapp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class UninstallAppWizardPage
extends WizardPage {
    private Table packageTable;
    private Map<String, String> availablePackages;
    private static final String contextId = "org.eclipse.andmore.android.uninstall_app";
    private boolean filterSystem;
    private Thread animatedText = null;

    public UninstallAppWizardPage(Map<String, String> applicationList, boolean filterSystem) {
        super("uninstall app page");
        this.filterSystem = filterSystem;
        this.availablePackages = applicationList;
        this.setTitle(AndroidNLS.UninstallAppWizardPage_PageTitle);
        this.setDescription(AndroidNLS.UninstallAppWizardPage_PageDescription);
    }

    public UninstallAppWizardPage(Map<String, String> applicationList) {
        this(applicationList, true);
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 4);
        mainComposite.setLayout((Layout)new GridLayout());
        this.packageTable = new Table(mainComposite, 67586);
        this.packageTable.setHeaderVisible(true);
        GridData layoutData = new GridData(4, 4, true, true);
        this.packageTable.setLayoutData((Object)layoutData);
        TableColumn packageNameColumn = new TableColumn(this.packageTable, 0x1000000);
        TableColumn isSystemColumn = new TableColumn(this.packageTable, 0x1000000);
        packageNameColumn.setText(AndroidNLS.UninstallAppWizardPage_ColumnPackageName);
        isSystemColumn.setText(AndroidNLS.UninstallAppWizardPage_ColumnPackageKiind);
        packageNameColumn.setWidth(200);
        isSystemColumn.setWidth(100);
        packageNameColumn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UninstallAppWizardPage.this.sortItems(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        isSystemColumn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UninstallAppWizardPage.this.sortItems(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.populate();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainComposite, contextId);
        this.setControl((Control)mainComposite);
    }

    private void populate() {
        if (this.availablePackages != null) {
            for (String packageName : this.availablePackages.keySet()) {
                String packagePath = this.availablePackages.get(packageName);
                if (this.filterSystem && packagePath.toLowerCase().contains("system")) continue;
                TableItem item = new TableItem(this.packageTable, 0);
                item.setText(0, packageName);
                item.setText(1, packagePath.contains("system") ? AndroidNLS.UninstallAppWizardPage_SystemLabel : AndroidNLS.UninstallAppWizardPage_UserLabel);
            }
            this.packageTable.setLinesVisible(false);
            this.packageTable.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    UninstallAppWizardPage.this.validatePage();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else {
            final TableItem item = new TableItem(this.packageTable, 0);
            this.animatedText = new Thread("TextAnimator"){

                @Override
                public void run() {
                    int i = 0;
                    while (!this.isInterrupted()) {
                        String text = AndroidNLS.UninstallAppWizardPage_Loading_Applications;
                        int j = 0;
                        while (j < i % 4) {
                            text = String.valueOf(text) + ".";
                            ++j;
                        }
                        final String finalText = text;
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!item.isDisposed()) {
                                    item.setText(0, finalText);
                                }
                            }
                        });
                        ++i;
                        try {
                            4.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                }
            };
            this.animatedText.start();
        }
        this.packageTable.layout(true);
        this.validatePage();
    }

    private void validatePage() {
        this.setPageComplete(this.availablePackages != null ? this.packageTable.getSelection().length > 0 : false);
    }

    public List<String> getPackageList() {
        ArrayList<String> selectedPackages = new ArrayList<String>();
        TableItem[] tableItemArray = this.packageTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            selectedPackages.add(item.getText(0));
            ++n2;
        }
        return selectedPackages;
    }

    private void sortItems(int column) {
    }

    public void setAvailablePackages(Map<String, String> applicationList) {
        this.availablePackages = applicationList;
        if (this.animatedText != null) {
            this.animatedText.interrupt();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                UninstallAppWizardPage.this.packageTable.removeAll();
                UninstallAppWizardPage.this.populate();
            }
        });
    }
}

