/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.net.telnet.TelnetClient;

public class TelnetFrameworkAndroid {
    private TelnetClient telnetClient;
    private long timeout = 5000L;

    public synchronized void connect(String telnetHost, int telnetPort) throws IOException {
        if (this.telnetClient == null || this.telnetClient != null && !this.telnetClient.isConnected()) {
            this.telnetClient = new TelnetClient(telnetHost);
            this.telnetClient.connect(telnetHost, telnetPort);
        }
    }

    public synchronized void disconnect() throws IOException {
        if (this.telnetClient != null && this.telnetClient.isConnected()) {
            this.telnetClient.disconnect();
        }
    }

    public synchronized String write(String telnetInputText, String[] waitFor) throws IOException {
        PrintWriter commandWriter = null;
        try {
            commandWriter = new PrintWriter(this.telnetClient.getOutputStream());
            commandWriter.println(telnetInputText);
            commandWriter.flush();
            if (waitFor != null) {
                String string = this.waitFor(waitFor);
                return string;
            }
        }
        finally {
            if (commandWriter != null) {
                commandWriter.close();
            }
        }
        return null;
    }

    public boolean isConnected() {
        boolean connected = false;
        if (this.telnetClient != null) {
            connected = this.telnetClient.isConnected();
        }
        return connected;
    }

    public String waitFor(String[] waitForArray) throws IOException {
        InputStreamReader responseReader = null;
        StringBuffer answerFromRemoteHost = new StringBuffer();
        try {
            responseReader = new InputStreamReader(this.telnetClient.getInputStream());
            boolean found = false;
            do {
                char readChar = '\u0000';
                long currentTime = System.currentTimeMillis();
                long timeoutTime = currentTime + this.timeout;
                while (readChar == '\u0000') {
                    if (responseReader == null) {
                        throw new IOException("Telnet host is unavailable; stopped waiting for answer.");
                    }
                    if (responseReader.ready()) {
                        readChar = (char)responseReader.read();
                    } else {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    currentTime = System.currentTimeMillis();
                    if (responseReader.ready() || currentTime <= timeoutTime) continue;
                    throw new IOException("A timeout has occured when trying to read the telnet stream");
                }
                answerFromRemoteHost.append(readChar);
                String[] stringArray = waitForArray;
                int n = waitForArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String aWaitFor = stringArray[n2];
                    found = answerFromRemoteHost.toString().contains(aWaitFor);
                    ++n2;
                }
            } while (!found);
        }
        finally {
            if (responseReader != null) {
                responseReader.close();
            }
        }
        return answerFromRemoteHost.toString();
    }

    public InputStream getInputStream() {
        InputStream s = null;
        if (this.telnetClient != null) {
            s = this.telnetClient.getInputStream();
        }
        return s;
    }

    public OutputStream getOutputStream() {
        OutputStream s = null;
        if (this.telnetClient != null) {
            s = this.telnetClient.getOutputStream();
        }
        return s;
    }
}

