/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.propertypage;

import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.multidex.MultiDexManager;
import org.eclipse.andmore.android.obfuscate.ObfuscatorManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class AndmorePropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private final String PROPERTY_PAGE_HELP = "org.eclipse.andmore.android.obuscation_property";
    private Button obfuscateCkbox;
    private Button multiDexCkbox;
    private IProject project = null;

    private void addObfuscateSection(Composite parent) {
        Composite group = this.createDefaultComposite(parent, AndroidNLS.UI_ProjectPropertyPage_ObfuscateGroup);
        Composite composite = new Composite(group, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.obfuscateCkbox = new Button(composite, 32);
        this.setDefaultObfuscate();
        Label obfuscateLabel = new Label(composite, 0);
        obfuscateLabel.setText(AndroidNLS.UI_ProjectPropertyPage_Obfuscate);
        this.obfuscateCkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                boolean showWarningMessage = false;
                if (AndmorePropertyPage.this.obfuscateCkbox.getSelection() && AndmorePropertyPage.this.project != null && AndmorePropertyPage.this.project.getLocation().toOSString().contains(" ")) {
                    showWarningMessage = true;
                }
                if (showWarningMessage) {
                    AndmorePropertyPage.this.setMessage(AndroidNLS.WRN_Obfuscation_ProjectLocationContainWhitespaces, 2);
                } else {
                    AndmorePropertyPage.this.setMessage("Eclipse Andmore");
                }
            }
        });
    }

    private void addMultiDexSection(Composite parent) {
        Composite group = this.createDefaultComposite(parent, AndroidNLS.UI_ProjectPropertyPage_MultiDexGroup);
        Composite composite = new Composite(group, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.multiDexCkbox = new Button(composite, 32);
        this.setDefaultMultiDex();
        Label obfuscateLabel = new Label(composite, 0);
        obfuscateLabel.setText(AndroidNLS.UI_ProjectPropertyPage_MultiDex);
        this.multiDexCkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                boolean showWarningMessage = false;
                if (AndmorePropertyPage.this.multiDexCkbox.getSelection() && AndmorePropertyPage.this.project != null && AndmorePropertyPage.this.project.getLocation().toOSString().contains(" ")) {
                    showWarningMessage = true;
                }
                if (showWarningMessage) {
                    AndmorePropertyPage.this.setMessage(AndroidNLS.WRN_Obfuscation_ProjectLocationContainWhitespaces, 2);
                } else {
                    AndmorePropertyPage.this.setMessage("Eclipse Andmore");
                }
            }
        });
    }

    private void setDefaultObfuscate() {
        this.project = null;
        if (this.getElement() instanceof IResource) {
            IResource resource = (IResource)this.getElement();
            if (resource != null) {
                this.project = resource.getProject();
            }
        } else if (this.getElement() instanceof JavaProject) {
            JavaProject javaProject = (JavaProject)this.getElement();
            this.project = javaProject.getProject();
        }
        if (this.project != null) {
            this.obfuscateCkbox.setSelection(ObfuscatorManager.isProguardSet(this.project));
        } else {
            this.obfuscateCkbox.setSelection(false);
        }
    }

    private void setDefaultMultiDex() {
        this.project = null;
        if (this.getElement() instanceof IResource) {
            IResource resource = (IResource)this.getElement();
            if (resource != null) {
                this.project = resource.getProject();
            }
        } else if (this.getElement() instanceof JavaProject) {
            JavaProject javaProject = (JavaProject)this.getElement();
            this.project = javaProject.getProject();
        }
        if (this.project != null) {
            this.multiDexCkbox.setSelection(MultiDexManager.isMultiDexEnabled(this.project));
        } else {
            this.multiDexCkbox.setSelection(false);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addObfuscateSection(composite);
        this.addMultiDexSection(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.andmore.android.obuscation_property");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.obuscation_property");
        return composite;
    }

    private Composite createDefaultComposite(Composite parent, String groupText) {
        GridData data = new GridData(4, 0, true, false);
        Group groupForComposite = new Group(parent, 16);
        groupForComposite.setLayout((Layout)new GridLayout());
        groupForComposite.setLayoutData((Object)data);
        groupForComposite.setFont(parent.getFont());
        groupForComposite.setText(groupText);
        return groupForComposite;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setDefaultObfuscate();
        this.setDefaultMultiDex();
    }

    public boolean performOk() {
        IProject project = null;
        if (this.getElement() instanceof IResource) {
            IResource resource = (IResource)this.getElement();
            if (resource != null) {
                project = resource.getProject();
            }
        } else if (this.getElement() instanceof JavaProject) {
            JavaProject javaProject = (JavaProject)this.getElement();
            project = javaProject.getProject();
        }
        if (project != null) {
            IStatus status = null;
            try {
                Boolean needToObfuscate = this.obfuscateCkbox.getSelection();
                status = needToObfuscate != false ? ObfuscatorManager.obfuscate(project, null) : ObfuscatorManager.unobfuscate(project);
                Boolean enableMultiDex = this.multiDexCkbox.getSelection();
                status = enableMultiDex != false ? MultiDexManager.enableMultiDex(project, null) : MultiDexManager.disableMultiDex(project);
                project.refreshLocal(2, null);
            }
            catch (Exception e) {
                EclipseUtils.showErrorDialog((String)AndroidNLS.AndmorePropertyPage_ChangeProguardSettingsProblem, (String)status.getMessage(), status);
                AndmoreLogger.error(AndmorePropertyPage.class, (String)e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

