/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.monkey.options;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.monkey.options.IMonkeyOptionsConstants;
import org.eclipse.andmore.android.monkey.options.MonkeyOption;
import org.eclipse.andmore.android.monkey.options.MonkeyOptionsGroup;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MonkeyOptionsMgt
implements IMonkeyOptionsConstants {
    private static List<MonkeyOptionsGroup> monkeyOptionsGroupsList = null;
    private static Map<String, MonkeyOption> monkeyOptionsMap = new HashMap<String, MonkeyOption>();

    static {
        MonkeyOptionsMgt.load();
    }

    public static List<MonkeyOptionsGroup> getMonkeyOptionsGroupsList() {
        return monkeyOptionsGroupsList;
    }

    public static void load() {
        try {
            monkeyOptionsGroupsList = new ArrayList<MonkeyOptionsGroup>();
            InputStream xmlStream = AndroidPlugin.getDefault().getBundle().getEntry("resources/monkey_options.xml").openStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(xmlStream);
            Element rootNode = document.getDocumentElement();
            NodeList monkeyOptionsGroups = rootNode.getElementsByTagName("group");
            int i = 0;
            while (i < monkeyOptionsGroups.getLength()) {
                Element group = (Element)monkeyOptionsGroups.item(i);
                String strKey = group.getAttributeNode("id").getNodeValue();
                strKey = Platform.getResourceString((Bundle)AndroidPlugin.getDefault().getBundle(), (String)strKey.trim());
                MonkeyOptionsGroup monkeyOptionsGroup = new MonkeyOptionsGroup(strKey);
                monkeyOptionsGroup.setTitle(monkeyOptionsGroup.getId());
                NodeList monkeyOptions = group.getElementsByTagName("monkeyOption");
                monkeyOptionsGroup.setMonkeyOptions(new ArrayList<MonkeyOption>());
                int j = 0;
                while (j < monkeyOptions.getLength()) {
                    Element option = (Element)monkeyOptions.item(j);
                    MonkeyOption monkeyOption = new MonkeyOption(option.getAttributeNode("name").getNodeValue(), MonkeyOptionsMgt.getMonkeyOptionType(option.getAttributeNode("type").getNodeValue()));
                    strKey = option.getAttributeNode("fName").getNodeValue();
                    strKey = Platform.getResourceString((Bundle)AndroidPlugin.getDefault().getBundle(), (String)strKey.trim());
                    monkeyOption.setUserFriendlyName(strKey);
                    strKey = option.getElementsByTagName("description").item(0).getTextContent();
                    strKey = Platform.getResourceString((Bundle)AndroidPlugin.getDefault().getBundle(), (String)strKey.trim());
                    monkeyOption.setDescription(strKey);
                    if (option.getAttributeNode("typeDetails") != null) {
                        monkeyOption.setTypeDetails(option.getAttributeNode("typeDetails").getNodeValue());
                    }
                    NodeList preDefinedValuesContainer = option.getElementsByTagName("values");
                    monkeyOption.setPreDefinedValues(new ArrayList<String>());
                    if (preDefinedValuesContainer.getLength() > 0) {
                        NodeList preDefinedValues = ((Element)preDefinedValuesContainer.item(0)).getElementsByTagName("value");
                        int k = 0;
                        while (k < preDefinedValues.getLength()) {
                            Element preDefinedValue = (Element)preDefinedValues.item(k);
                            monkeyOption.getPreDefinedValues().add(preDefinedValue.getTextContent());
                            ++k;
                        }
                    }
                    monkeyOptionsGroup.getMonkeyOptions().add(monkeyOption);
                    monkeyOptionsMap.put(monkeyOption.getName(), monkeyOption);
                    ++j;
                }
                monkeyOptionsGroupsList.add(monkeyOptionsGroup);
                ++i;
            }
        }
        catch (Exception exception) {
            AndmoreLogger.error((String)"Failed to load monkey options");
        }
    }

    public static Status validate() {
        Status status = (Status)Status.OK_STATUS;
        String msg = null;
        block5: for (MonkeyOptionsGroup group : MonkeyOptionsMgt.getMonkeyOptionsGroupsList()) {
            for (MonkeyOption monkeyOption : group.getMonkeyOptions()) {
                if (!monkeyOption.isChecked() || !status.isOK()) continue;
                String name = monkeyOption.getName();
                String ufname = monkeyOption.getUserFriendlyName();
                String value = monkeyOption.getValue();
                String typeDetails = monkeyOption.getTypeDetails();
                if (!monkeyOption.getName().equals("other") && value.indexOf("\"") >= 0) {
                    msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_NoQuotes, (Object)ufname);
                } else {
                    switch (monkeyOption.getType()) {
                        case 1: {
                            msg = MonkeyOptionsMgt.validateTextField(name, ufname, value, typeDetails);
                            break;
                        }
                        case 3: {
                            msg = MonkeyOptionsMgt.validadeNumberField(name, ufname, value, typeDetails);
                            break;
                        }
                        case 2: {
                            msg = MonkeyOptionsMgt.validadePathField(name, ufname, value, typeDetails);
                        }
                    }
                }
                if (msg == null) continue;
                status = new Status(4, "org.eclipse.andmore.android", msg);
                continue block5;
            }
        }
        return status;
    }

    private static String validateTextField(String name, String ufName, String value, String typeDetails) {
        String msg = null;
        if (value == null || value.equals("")) {
            msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_TextBlank, (Object)ufName);
        }
        return msg;
    }

    private static String validadeNumberField(String name, String ufName, String value, String typeDetails) {
        String msg = null;
        if (value == null || value.equals("")) {
            msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_NumberRequired, (Object)ufName);
        } else {
            try {
                String[] valueRange;
                int intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_NumberMustBePositiveInteger, (Object)ufName);
                } else if (typeDetails != null && (intValue < Integer.parseInt((valueRange = typeDetails.split(";"))[0]) || intValue > Integer.parseInt(valueRange[1]))) {
                    msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_NumberIntRange, (Object[])new String[]{ufName, valueRange[0], valueRange[1]});
                }
            }
            catch (NumberFormatException numberFormatException) {
                msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_NumberMustBeInteger, (Object)ufName);
            }
        }
        return msg;
    }

    private static String validadePathField(String name, String ufName, String value, String typeDetails) {
        String msg = null;
        if (value == null || value.equals("")) {
            msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_PathRequired, (Object)ufName);
        } else {
            File file = new File(value);
            if (typeDetails.equals("dir")) {
                if (!file.exists()) {
                    msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_PathDirNotExist, (Object)ufName);
                } else if (file.isFile()) {
                    msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_PathMustBeDir, (Object)ufName);
                }
            } else if (!file.exists()) {
                msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_PathFileNotExist, (Object)ufName);
            } else if (file.isDirectory()) {
                msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_PathMustBeFile, (Object)ufName);
            } else if (!typeDetails.equals("." + new Path(value).getFileExtension())) {
                msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_PathIncorrectFileType, (Object[])new String[]{ufName, typeDetails});
            }
        }
        return msg;
    }

    public static String getParamList() {
        String paramList = "";
        for (MonkeyOptionsGroup group : MonkeyOptionsMgt.getMonkeyOptionsGroupsList()) {
            for (MonkeyOption monkeyOption : group.getMonkeyOptions()) {
                int monkeyOptionType = monkeyOption.getType();
                if (!monkeyOption.isChecked()) continue;
                if (monkeyOptionType == 0) {
                    paramList = String.valueOf(paramList) + (paramList.equals("") ? "" : " ") + monkeyOption.getName();
                    continue;
                }
                if (monkeyOption.getName().equals("other")) {
                    paramList = String.valueOf(paramList) + (paramList.equals("") ? "" : " ") + monkeyOption.getValue();
                    continue;
                }
                if (monkeyOption.getName().equals("-c")) {
                    String[] values = monkeyOption.getValue().split(" ");
                    int i = 0;
                    while (i < values.length) {
                        if (values[i].trim().length() > 0) {
                            paramList = String.valueOf(paramList) + (paramList.equals("") ? "" : " ") + monkeyOption.getName() + " " + values[i];
                        }
                        ++i;
                    }
                    continue;
                }
                String value = monkeyOption.getValue();
                if (value.equals("")) continue;
                if (Platform.getOS().equals("win32")) {
                    if (value.contains(" ")) {
                        value = "\"" + value + "\"";
                    }
                } else {
                    if (value.contains("\\")) {
                        value = value.replace("\\", "\\\\");
                    }
                    if (value.contains(" ")) {
                        value = value.replace(" ", "\\ ");
                    }
                }
                paramList = String.valueOf(paramList) + (paramList.equals("") ? "" : " ") + monkeyOption.getName() + (value.trim().length() > 0 ? " " + value : "");
            }
        }
        return paramList;
    }

    private static void loadValues(Properties properties) {
        for (MonkeyOptionsGroup group : MonkeyOptionsMgt.getMonkeyOptionsGroupsList()) {
            String soValue = "";
            for (MonkeyOption monkeyOption : group.getMonkeyOptions()) {
                soValue = properties.getProperty(monkeyOption.getName());
                if (soValue != null) {
                    monkeyOption.setChecked(true);
                    monkeyOption.setValue(soValue);
                } else {
                    monkeyOption.setChecked(false);
                    monkeyOption.setValue("");
                }
                monkeyOption.updateUI();
            }
        }
    }

    public static Properties parseCommandLine(String commandLine) {
        Properties properties = new Properties();
        if (!commandLine.equals("")) {
            for (MonkeyOptionsGroup group : MonkeyOptionsMgt.getMonkeyOptionsGroupsList()) {
                String soValue = "";
                int shift = 0;
                for (MonkeyOption monkeyOption : group.getMonkeyOptions()) {
                    String soName = monkeyOption.getName();
                    int soType = monkeyOption.getType();
                    if (!commandLine.startsWith(soName)) continue;
                    if (soType == 0) {
                        soValue = new Boolean(true).toString();
                        shift = soName.length() + 1;
                    } else if (monkeyOption.getName().equals("-c")) {
                        String soValueCat = "";
                        while (commandLine.startsWith("-c")) {
                            commandLine = commandLine.substring(soName.length() + 1, commandLine.length());
                            ParameterBean param = MonkeyOptionsMgt.getNextParameterValue(commandLine);
                            soValue = param.getValue();
                            shift = param.getLastPosition() + 1;
                            soValueCat = String.valueOf(soValueCat.equals("") ? soValueCat : String.valueOf(soValueCat) + " ") + soValue;
                            commandLine = shift < commandLine.length() - 1 ? commandLine.substring(shift, commandLine.length()) : "";
                        }
                        shift = 0;
                        soValue = soValueCat;
                    } else {
                        commandLine = commandLine.substring(soName.length() + 1, commandLine.length());
                        ParameterBean param = MonkeyOptionsMgt.getNextParameterValue(commandLine);
                        soValue = param.getValue();
                        shift = param.getLastPosition() + 1;
                    }
                    properties.put(monkeyOption.getName(), soValue);
                    commandLine = shift < commandLine.length() - 1 ? commandLine.substring(shift, commandLine.length()) : "";
                }
            }
            if (!commandLine.equals("")) {
                properties.put("other", commandLine);
            }
        }
        return properties;
    }

    public static void loadFromCommandLine(String commandLine) {
        MonkeyOptionsMgt.loadValues(MonkeyOptionsMgt.parseCommandLine(commandLine));
    }

    private static int getMonkeyOptionType(String type) {
        return (Integer)TYPE_MAP.get(type);
    }

    private static ParameterBean getNextParameterValue(String commandLine) {
        boolean isWin32 = Platform.getOS().equals("win32");
        boolean escaped = false;
        boolean quoted = false;
        String value = "";
        int i = 0;
        while (i < commandLine.length()) {
            char c = commandLine.charAt(i);
            if (escaped) {
                value = String.valueOf(value) + c;
                escaped = false;
            } else if (c == '\\' && !isWin32) {
                escaped = true;
            } else if (c == '\"' && isWin32) {
                if (value.length() == 0) {
                    quoted = true;
                } else {
                    if (quoted) break;
                    value = String.valueOf(value) + c;
                }
            } else {
                if (c == ' ' && !quoted) break;
                value = String.valueOf(value) + c;
            }
            ++i;
        }
        return new ParameterBean(value, quoted ? i + 1 : i);
    }

    private static class ParameterBean {
        private final String value;
        private final int lastPosition;

        public ParameterBean(String value, int lastPosition) {
            this.value = value;
            this.lastPosition = lastPosition;
        }

        public String getValue() {
            return this.value;
        }

        public int getLastPosition() {
            return this.lastPosition;
        }
    }
}

