/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model;

import com.android.sdklib.IAndroidTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.Sample;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.utilities.AndroidStatus;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.model.IWizardModel;
import org.eclipse.andmore.android.model.ProjectCreationSupport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;

public class AndroidProject
implements IWizardModel {
    private static final IWorkspace WORKSPACE = ResourcesPlugin.getWorkspace();
    private static final String SDK_VERSION = "1.5";
    private static final String BIN_FOLDER = "bin";
    private static final String CLASS_EXTENSION = ".class";
    private static final String R_DRAWABLE_CLASS = "R$drawable.class";
    private static final String SETTINGS_FOLDER = ".settings";
    private static final String SETTINGS_FILE = "org.eclipse.core.resources.prefs";
    public static final String ANDROID_NATURE = "org.eclipse.andmore.AndroidNature";
    private static final int MAX_PATH_LENGTH = 255;
    private SourceTypes sourceType = SourceTypes.NEW;
    private Sample sample = null;
    private String location = null;
    private boolean useDefaultLocation = true;
    private boolean addNativeSupport = false;
    private boolean needToObfuscate = false;
    private String minSdkVersion = null;
    private String name = "";
    private String activityName = "";
    private String packageName = "";
    private IAndroidTarget sdkTarget = null;
    private List<String> sourceFolders = null;
    private boolean usingDefaultPackage = true;
    private final String PACKAGE_ROOT = "com.";
    private Runnable listener = null;
    private String appName;

    public void finalize() throws Throwable {
        if (this.listener != null) {
            AndroidPlugin.getDefault().removeSDKLoaderListener(this.listener);
        }
        super.finalize();
    }

    public SourceTypes getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceTypes sourceType) {
        this.sourceType = sourceType;
    }

    public boolean isAddingNativeSupport() {
        return this.addNativeSupport;
    }

    public void setAddNativeSupport(boolean addNativeSupport) {
        this.addNativeSupport = addNativeSupport;
    }

    public void setNeedToObfuscate(boolean needToObfuscate) {
        this.needToObfuscate = needToObfuscate;
    }

    public boolean needToObfuscate() {
        return this.needToObfuscate;
    }

    public String getLocation() {
        return this.location;
    }

    public Sample getSample() {
        return this.sample;
    }

    public void setSample(Sample sample) {
        this.sample = sample;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean isUsingDefaultLocation() {
        return this.useDefaultLocation;
    }

    public void setUseDefaultLocation(boolean useDefaultLocation) {
        this.useDefaultLocation = useDefaultLocation;
    }

    public boolean isUsingDefaultPackage() {
        return this.usingDefaultPackage;
    }

    public void setUsingDefaultPackage(boolean usingDefaultPackage) {
        this.usingDefaultPackage = usingDefaultPackage;
    }

    public AndroidProject() {
        if (SdkUtils.getCurrentSdk() == null) {
            this.listener = new Runnable(){

                @Override
                public void run() {
                    IAndroidTarget[] targets = SdkUtils.getAllTargets();
                    if (targets != null && targets.length > 0) {
                        int maxApiVersion = -1;
                        IAndroidTarget[] iAndroidTargetArray = targets;
                        int n = targets.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IAndroidTarget aTarget = iAndroidTargetArray[n2];
                            int apiVersion = aTarget.getVersion().getApiLevel();
                            if (maxApiVersion < apiVersion) {
                                AndroidProject.this.sdkTarget = aTarget;
                                maxApiVersion = apiVersion;
                            }
                            ++n2;
                        }
                        AndroidProject.this.minSdkVersion = AndroidProject.this.sdkTarget.getVersion().getApiString();
                    }
                    AndroidPlugin.getDefault().removeSDKLoaderListener(AndroidProject.this.listener);
                    AndroidProject.this.listener = null;
                }
            };
            AndroidPlugin.getDefault().addSDKLoaderListener(this.listener);
        } else {
            IAndroidTarget[] targets = SdkUtils.getAllTargets();
            if (targets != null && targets.length > 0) {
                int maxApiVersion = -1;
                IAndroidTarget[] iAndroidTargetArray = targets;
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    IAndroidTarget aTarget = iAndroidTargetArray[n2];
                    int apiVersion = aTarget.getVersion().getApiLevel();
                    if (maxApiVersion < apiVersion) {
                        this.sdkTarget = aTarget;
                        maxApiVersion = apiVersion;
                    }
                    ++n2;
                }
                this.minSdkVersion = this.sdkTarget.getVersion().getApiString();
            }
        }
        this.sourceFolders = new ArrayList<String>(3);
        this.sourceFolders.add("src");
        this.sourceFolders.add("gen");
    }

    private String getDefaultPackageName() {
        return "com." + this.name2package(this.name);
    }

    public String getDefaultActivityName() {
        String activityName = this.name;
        activityName = activityName.replaceAll("^[0-9]+", "_");
        activityName = activityName.replaceAll("[\\.]+", "_");
        return activityName;
    }

    protected String name2package(String name) {
        String packageName = this.getDefaultActivityName().toLowerCase();
        if ((packageName = packageName.replaceAll("[^A-Za-z0-9_]+", "_")).endsWith("_") && packageName.length() > 1) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        return packageName;
    }

    public String getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public boolean isSdkPreview() {
        return this.getSdkTarget().getVersion().isPreview();
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        String packageName = this.isUsingDefaultPackage() ? this.getDefaultPackageName() : this.packageName;
        return packageName;
    }

    public IAndroidTarget getSdkTarget() {
        return this.sdkTarget;
    }

    public List<String> getSourceFolders() {
        return this.sourceFolders;
    }

    @Override
    public IStatus getStatus() {
        boolean projectLocationIsEmpty;
        IProject handle;
        String errMsg;
        String errMsg2;
        Pattern pattern;
        Object status = Status.OK_STATUS;
        if (this.name == null || this.name.length() == 0) {
            status = new AndroidStatus(4, AndroidNLS.ERR_AndroidProject_ProjectNameMustBeSpecified);
        } else {
            pattern = Pattern.compile("([A-Za-z0-9_\\.])+");
            Matcher matcher = pattern.matcher(this.name);
            if (!matcher.matches()) {
                errMsg2 = NLS.bind((String)AndroidNLS.ERR_AndroidProject_InvalidProjectName, (Object)this.name);
                status = new AndroidStatus(4, errMsg2);
            } else {
                status = WORKSPACE.getRoot().getProject(this.name).exists() ? new AndroidStatus(4, AndroidNLS.ERR_AndroidProject_DuplicatedProjectNameInWorkspace) : WORKSPACE.validateName(this.name, 4);
            }
        }
        if (status.isOK() && this.sourceType == SourceTypes.EXISTING) {
            if (this.getLocation().length() == 0) {
                status = new AndroidStatus(1, AndroidNLS.ERR_AndroidProject_EmptySourceLocation);
            } else {
                Path path = new Path(this.getLocation());
                String osPath = path.append("AndroidManifest.xml").toOSString();
                File manifest = new File(osPath);
                if (!manifest.exists() || !manifest.isFile()) {
                    errMsg = NLS.bind((String)AndroidNLS.ERR_AndroidProject_FileNotFoundError, (Object)"AndroidManifest.xml", (Object)path.lastSegment());
                    status = new AndroidStatus(4, errMsg);
                }
            }
        }
        if (status.isOK() && !this.isUsingDefaultLocation() && (status = WORKSPACE.validateProjectLocation(handle = WORKSPACE.getRoot().getProject(this.name), (IPath)new Path(this.location))).isOK() && this.isNewProject() && this.getLocation() != null && !(projectLocationIsEmpty = ProjectCreationSupport.validateNewProjectLocationIsEmpty((IPath)new Path(this.getLocation())))) {
            status = new AndroidStatus(4, AndroidNLS.UI_ProjectCreationSupport_NonEmptyFolder);
        }
        if (status.isOK() && this.isAddingNativeSupport() && Platform.getOS().equals("win32") && (this.isUsingDefaultLocation() && ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString().contains(" ") || !this.isUsingDefaultLocation() && this.location.contains(" "))) {
            status = new AndroidStatus(4, AndroidNLS.ERR_AndroidProject_LocationContainsWhitespaces);
        }
        if (status.isOK()) {
            String basePath = this.isUsingDefaultLocation() ? this.getDefaultLocation() : this.getLocation();
            String relativePackagePath = this.getPackageName().replace('.', File.separatorChar);
            String binPath = String.valueOf(basePath) + File.separatorChar + BIN_FOLDER + File.separatorChar + relativePackagePath;
            String rDrawableBinClass = String.valueOf(binPath) + File.separatorChar + R_DRAWABLE_CLASS;
            String settingsFilePath = String.valueOf(basePath) + File.separatorChar + SETTINGS_FOLDER + File.separatorChar + SETTINGS_FILE;
            String defaultClassBin = String.valueOf(binPath) + File.separator + this.getDefaultActivityName() + CLASS_EXTENSION;
            int maxFilenameLength = this.getMax(new int[]{rDrawableBinClass.length(), settingsFilePath.length(), defaultClassBin.length()});
            if (maxFilenameLength > 255) {
                status = new AndroidStatus(4, AndroidNLS.ERR_AndroidProject_ProjectNameTooLong);
            }
        }
        if (status.isOK() && this.sdkTarget == null) {
            status = new AndroidStatus(4, AndroidNLS.ERR_AndroidProject_ASdkTargetMustBeSpecified);
        }
        if (status.isOK() && (this.sourceType == SourceTypes.NEW || this.sourceType == SourceTypes.WIDGET)) {
            if (this.appName.trim().length() == 0) {
                status = new AndroidStatus(2, AndroidNLS.WARN_AndroidProject_ApplicationNameIsEmpty);
            }
            if (this.appName.contains("&")) {
                status = new AndroidStatus(4, NLS.bind((String)AndroidNLS.ERR_AndroidProject_InvalidApplicationName, (Object)this.appName));
            }
        }
        if (status.isOK() && (this.sourceType == SourceTypes.NEW || this.sourceType == SourceTypes.WIDGET) && !this.isUsingDefaultPackage()) {
            Matcher matcher;
            if (this.getPackageName().length() == 0) {
                status = new AndroidStatus(4, AndroidNLS.ERR_AndroidProject_EmptyPackageName);
            } else if (status.isOK()) {
                status = JavaConventions.validatePackageName((String)this.getPackageName(), (String)SDK_VERSION, (String)SDK_VERSION);
            }
            if (status.isOK() && this.getPackageName().indexOf(46) == -1) {
                status = new AndroidStatus(4, AndroidNLS.ERR_AndroidProject_InvalidPackageName);
            }
            if (status.isOK() && !(matcher = (pattern = Pattern.compile("[A-Za-z0-9_\\.]+")).matcher(this.getPackageName())).matches()) {
                errMsg2 = NLS.bind((String)AndroidNLS.ERR_AndroidProject_InvalidCharsInPackageName, (Object)this.getPackageName());
                status = new AndroidStatus(4, errMsg2);
            }
        }
        if (this.getSourceType() == SourceTypes.NEW || this.getSourceType() == SourceTypes.WIDGET) {
            if (this.activityName == null || this.activityName.length() == 0) {
                status = new AndroidStatus(4, AndroidNLS.ERR_AndroidProject_ActivityNameMustBeSpecified);
            } else {
                String onlyChars = "[A-Za-z_]";
                Pattern pattern2 = Pattern.compile("(" + onlyChars + ")(\\w)+");
                Matcher matcher = pattern2.matcher(this.activityName);
                if (!matcher.matches()) {
                    errMsg = NLS.bind((String)AndroidNLS.ERR_AndroidProject_InvalidActivityName, (Object)this.activityName);
                    status = new AndroidStatus(4, errMsg);
                }
            }
        }
        if (status.isOK() && (this.sourceType == SourceTypes.NEW || this.sourceType == SourceTypes.WIDGET)) {
            if (this.isSdkPreview()) {
                String sdkAPI = this.getSdkTarget().getVersion().getApiString();
                if (!sdkAPI.equals(this.getMinSdkVersion())) {
                    status = new AndroidStatus(4, NLS.bind((String)AndroidNLS.AndroidProject_MsgSDKVersionIsPreview, (Object)sdkAPI));
                }
            } else {
                int version = -1;
                try {
                    version = Integer.parseInt(this.getMinSdkVersion());
                }
                catch (NumberFormatException numberFormatException) {
                    status = new AndroidStatus(4, AndroidNLS.ERR_AndroidProject_InvalidSdkVersion);
                }
                if (status.isOK() && version < 1) {
                    status = new AndroidStatus(4, AndroidNLS.ERR_AndroidProject_InvalidSdkVersion);
                }
                if (status.isOK() && this.getSdkTarget() != null) {
                    if (this.getSdkTarget().getVersion().getApiLevel() > version) {
                        status = new AndroidStatus(2, AndroidNLS.ERR_AndroidProject_InvalidApiLevel);
                    } else if (this.getSdkTarget().getVersion().getApiLevel() < version) {
                        status = new AndroidStatus(4, AndroidNLS.EXC_AndroidProject_InvalidMinimumSdkVersion);
                    }
                }
            }
        }
        if (status.isOK() && this.sourceType == SourceTypes.SAMPLE && this.sdkTarget != null && SdkUtils.getSamples(this.sdkTarget).length == 0) {
            status = new AndroidStatus(4, AndroidNLS.EXC_AndroidProject_NoSamplesAvailable);
        }
        if (status.isOK() && this.needToObfuscate() && (this.isUsingDefaultLocation() && ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString().contains(" ") || !this.isUsingDefaultLocation() && this.location.contains(" "))) {
            status = new AndroidStatus(2, AndroidNLS.WRN_Obfuscation_ProjectLocationContainWhitespaces);
        }
        return status;
    }

    @Override
    public boolean needMoreInformation() {
        boolean needMoreInformation;
        boolean bl = needMoreInformation = this.name == null || this.name.length() == 0 || !WORKSPACE.validateName(this.name, 4).isOK();
        if (!needMoreInformation) {
            boolean projectPathInformation = this.location == null || this.location.length() == 0 || !WORKSPACE.validateProjectLocation(WORKSPACE.getRoot().getProject(this.name), (IPath)new Path(this.location)).isOK();
            boolean newProjectInformation = !this.useDefaultLocation && projectPathInformation;
            switch (this.sourceType) {
                case NEW: {
                    needMoreInformation = newProjectInformation;
                    break;
                }
                case SAMPLE: {
                    needMoreInformation = newProjectInformation || this.sample == null;
                    break;
                }
                case EXISTING: {
                    needMoreInformation = projectPathInformation;
                    break;
                }
                case WIDGET: {
                    needMoreInformation = newProjectInformation;
                }
            }
        }
        if (!(needMoreInformation || this.sourceType != SourceTypes.NEW && this.sourceType != SourceTypes.WIDGET || this.isUsingDefaultPackage())) {
            boolean bl2 = needMoreInformation = this.getPackageName().length() == 0 || !JavaConventions.validatePackageName((String)this.getPackageName(), (String)SDK_VERSION, (String)SDK_VERSION).isOK() || this.getPackageName().indexOf(46) == -1;
        }
        if (!needMoreInformation) {
            needMoreInformation = this.sdkTarget == null;
        }
        return needMoreInformation;
    }

    @Override
    public boolean save(IWizardContainer container, IProgressMonitor monitor) {
        try {
            return ProjectCreationSupport.createProject(this, container);
        }
        catch (AndroidException e) {
            Status status = new Status(4, "org.eclipse.andmore.android", e.getLocalizedMessage());
            EclipseUtils.showErrorDialog((String)AndroidNLS.GEN_Error, (String)AndroidNLS.EXC_AndroidProject_AnErrorHasOccurredWhenCreatingTheProject, (IStatus)status);
            return false;
        }
    }

    public void setMinSdkVersion(String minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public void setPackageName(String packageName) {
        if (this.isUsingDefaultPackage()) {
            throw new IllegalStateException();
        }
        this.packageName = packageName.trim();
    }

    public void setSdkTarget(IAndroidTarget sdkTarget) {
        this.sdkTarget = sdkTarget;
    }

    public void setSourceFolder(List<String> sourceFolders) {
        this.sourceFolders.clear();
        this.sourceFolders.addAll(sourceFolders);
    }

    public String getDefaultLocation() {
        return String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + File.separator + this.name;
    }

    public boolean isNewProject() {
        return this.getSourceType() != SourceTypes.EXISTING;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityName() {
        return this.activityName;
    }

    private int getMax(int[] values) {
        int max = values[0];
        int i = 1;
        while (i < values.length) {
            max = Math.max(max, values[i]);
            ++i;
        }
        return max;
    }

    public void setApplicationName(String app_name) {
        this.appName = app_name;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public static enum SourceTypes {
        SAMPLE,
        EXISTING,
        NEW,
        WIDGET;

    }
}

