/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.devices;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class AbstractDevicePropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Properties propValues;

    protected Control createContents(Composite parent) {
        Composite parentComposite = new Composite(parent, 0);
        parentComposite.setLayout((Layout)new GridLayout(2, false));
        parentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final Table propTable = new Table(parentComposite, 65540);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.heightHint = 150;
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        propTable.setLayoutData((Object)data);
        propTable.setLinesVisible(true);
        final TableColumn keyColumn = new TableColumn(propTable, 16384);
        keyColumn.setText(AndroidNLS.AbstractDevicePropertyPage_Property);
        keyColumn.setWidth(200);
        TableColumn valueColumn = new TableColumn(propTable, 16384);
        valueColumn.setText(AndroidNLS.AbstractDevicePropertyPage_Value);
        valueColumn.setWidth(200);
        propTable.setHeaderVisible(true);
        this.propValues = this.getDeviceProperties();
        if (this.propValues != null && !this.propValues.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.propValues.entrySet()) {
                TableItem item = new TableItem(propTable, 0);
                item.setText(new String[]{(String)entry.getKey(), (String)entry.getValue()});
            }
        }
        Button button = new Button(parentComposite, 8);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 1;
        buttonData.grabExcessVerticalSpace = false;
        buttonData.grabExcessHorizontalSpace = true;
        buttonData.horizontalAlignment = 0x1000008;
        buttonData.verticalAlignment = 0x1000000;
        button.setLayoutData((Object)buttonData);
        button.setText(AndroidNLS.AbstractDevicePropertyPage_CVS_Export);
        button.pack();
        if (this.propValues.isEmpty()) {
            button.setEnabled(false);
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void widgetSelected(SelectionEvent e) {
                FileDialog selectionDialog = new FileDialog(AbstractDevicePropertyPage.this.getShell(), 0x10002000);
                selectionDialog.setFilterExtensions(new String[]{"*.csv"});
                selectionDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
                String csvPath = selectionDialog.open();
                File csvFile = new File(csvPath);
                String fileName = csvFile.getName();
                if (csvFile != null && !"".equals(fileName)) {
                    int extensionIdx = fileName.lastIndexOf(".");
                    if (extensionIdx < 0 || "".equals(fileName.substring(extensionIdx))) {
                        csvFile = new File(String.valueOf(csvFile.getAbsolutePath()) + ".csv");
                    }
                    BufferedWriter outputWriter = null;
                    try {
                        try {
                            outputWriter = new BufferedWriter(new FileWriter(csvFile));
                            for (String string : AbstractDevicePropertyPage.this.propValues.keySet()) {
                                String value = (String)AbstractDevicePropertyPage.this.propValues.get(string);
                                outputWriter.append(string);
                                outputWriter.append(",");
                                if (value.contains(",")) {
                                    outputWriter.append("\"");
                                    outputWriter.append(value);
                                    outputWriter.append("\"");
                                } else {
                                    outputWriter.append(value);
                                }
                                outputWriter.newLine();
                            }
                            return;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            EclipseUtils.showErrorDialog((String)AndroidNLS.AbstractDevicePropertyPage_Error_Title, (String)AndroidNLS.AbstractDevicePropertyPage_Error_Message);
                            if (outputWriter == null) return;
                            try {
                                outputWriter.flush();
                                outputWriter.close();
                                return;
                            }
                            catch (IOException e1) {
                                AndmoreLogger.error((String)("Could not close stream. " + e1.getMessage()));
                            }
                            return;
                        }
                        catch (IOException iOException) {
                            EclipseUtils.showErrorDialog((String)AndroidNLS.AbstractDevicePropertyPage_Error_Title, (String)AndroidNLS.AbstractDevicePropertyPage_Error_Message);
                            if (outputWriter == null) return;
                            try {
                                outputWriter.flush();
                                outputWriter.close();
                                return;
                            }
                            catch (IOException e1) {
                                AndmoreLogger.error((String)("Could not close stream. " + e1.getMessage()));
                            }
                            return;
                        }
                    }
                    finally {
                        if (outputWriter != null) {
                            try {
                                outputWriter.flush();
                                outputWriter.close();
                            }
                            catch (IOException e1) {
                                AndmoreLogger.error((String)("Could not close stream. " + e1.getMessage()));
                            }
                        }
                    }
                }
                EclipseUtils.showErrorDialog((String)AndroidNLS.AbstractDevicePropertyPage_Error_Title, (String)AndroidNLS.AbstractDevicePropertyPage_Error_Message_Valid_File);
            }
        });
        propTable.pack();
        parentComposite.pack();
        SelectionAdapter sortListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumn sortColumn = propTable.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int columnIndex = currentColumn == keyColumn ? 0 : 1;
                int dir = propTable.getSortDirection();
                dir = sortColumn == currentColumn ? (dir == 128 ? 1024 : 128) : 128;
                AbstractDevicePropertyPage.this.sortTable(propTable, columnIndex, sortColumn, currentColumn, dir);
            }
        };
        keyColumn.addSelectionListener((SelectionListener)sortListener);
        valueColumn.addSelectionListener((SelectionListener)sortListener);
        propTable.setSortColumn(keyColumn);
        propTable.setSortDirection(128);
        this.sortTable(propTable, 0, keyColumn, keyColumn, 128);
        this.noDefaultAndApplyButton();
        return parentComposite;
    }

    protected abstract Properties getDeviceProperties();

    private void sortTable(Table table, int columnIndex, TableColumn sortColumn, TableColumn currentColumn, int dir) {
        table.setSortDirection(dir);
        TableItem[] items = table.getItems();
        Collator collator = Collator.getInstance(Locale.getDefault());
        int index = columnIndex;
        int i = 1;
        while (i < items.length) {
            String value1 = items[i].getText(index);
            int j = 0;
            while (j < i) {
                TableItem item;
                String[] values;
                String value2 = items[j].getText(index);
                if (dir == 128) {
                    if (collator.compare(value1, value2) < 0) {
                        values = new String[]{items[i].getText(0), items[i].getText(1)};
                        items[i].dispose();
                        item = new TableItem(table, 0, j);
                        item.setText(values);
                        items = table.getItems();
                        break;
                    }
                } else if (collator.compare(value1, value2) > 0) {
                    values = new String[]{items[i].getText(0), items[i].getText(1)};
                    items[i].dispose();
                    item = new TableItem(table, 0, j);
                    item.setText(values);
                    items = table.getItems();
                    break;
                }
                ++j;
            }
            ++i;
        }
        table.setSortColumn(currentColumn);
    }
}

