/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ConvertADTProject
extends AbstractHandler {
    private List<IProject> projectList = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null || workbench.isClosing()) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sselection = (IStructuredSelection)selection;
            Iterator it = sselection.iterator();
            this.projectList = new ArrayList<IProject>(sselection.size());
            while (it.hasNext()) {
                Object resource = it.next();
                if (resource instanceof IJavaProject) {
                    IJavaProject javaProject = (IJavaProject)resource;
                    this.projectList.add(javaProject.getProject());
                    continue;
                }
                if (!(resource instanceof IAdaptable)) continue;
                IAdaptable adaptable = (IAdaptable)resource;
                this.projectList.add((IProject)adaptable.getAdapter(IProject.class));
            }
            this.convertProjectsToAndmore();
        }
        return null;
    }

    protected void convertProjectsToAndmore() {
        for (IProject project : this.projectList) {
            try {
                if (!project.hasNature("com.android.ide.eclipse.adt.AndroidNature")) break;
                IJavaProject androidProject = JavaCore.create((IProject)project);
                this.updateProjectDescription(androidProject);
                this.updateClasspathEntries(androidProject);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateClasspathEntries(IJavaProject androidProject) throws JavaModelException {
        IClasspathEntry[] classpathEntries;
        ArrayList<IClasspathEntry> newclasspathEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = classpathEntries = androidProject.getRawClasspath();
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getEntryKind() == 5) {
                String classpathId = classpathEntry.getPath().toString();
                if (classpathId.equals("com.android.ide.eclipse.adt.DEPENDENCIES")) {
                    newclasspathEntries.add(this.createNewAndmoreContainer("org.eclipse.andmore.DEPENDENCIES"));
                } else if (classpathId.equals("com.android.ide.eclipse.adt.ANDROID_FRAMEWORK")) {
                    newclasspathEntries.add(this.createNewAndmoreContainer("org.eclipse.andmore.ANDROID_FRAMEWORK"));
                } else if (classpathId.equals("com.android.ide.eclipse.adt.LIBRARIES")) {
                    newclasspathEntries.add(this.createNewAndmoreContainer("org.eclipse.andmore.LIBRARIES"));
                } else {
                    newclasspathEntries.add(classpathEntry);
                }
            } else {
                newclasspathEntries.add(classpathEntry);
            }
            ++n2;
        }
        IClasspathEntry[] andmoreClasspathEntries = new IClasspathEntry[newclasspathEntries.size()];
        newclasspathEntries.toArray(andmoreClasspathEntries);
        androidProject.setRawClasspath(andmoreClasspathEntries, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private void updateProjectDescription(IJavaProject androidProject) throws CoreException {
        IProjectDescription description = androidProject.getProject().getDescription();
        description.setNatureIds(new String[]{"org.eclipse.andmore.AndroidNature", "org.eclipse.jdt.core.javanature"});
        ICommand[] commands = description.getBuildSpec();
        ArrayList<ICommand> acutalCommands = new ArrayList<ICommand>();
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (!(command.getBuilderName().equals("com.android.ide.eclipse.adt.PreCompilerBuilder") || command.getBuilderName().equals("com.android.ide.eclipse.adt.ResourceManagerBuilder") || command.getBuilderName().equals("com.android.ide.eclipse.adt.ApkBuilder"))) {
                acutalCommands.add(command);
            }
            ++n2;
        }
        ICommand[] keepCommands = new ICommand[acutalCommands.size()];
        acutalCommands.toArray(keepCommands);
        description.setBuildSpec(keepCommands);
        description.setBuildConfigs(new String[]{"org.eclipse.andmore.ResourceManagerBuilder", "org.eclipse.andmore.ApkBuilder", "org.eclipse.andmore.PreCompilerBuilder", "org.eclipse.jdt.core.javabuilder"});
        androidProject.getProject().setDescription(description, (IProgressMonitor)new NullProgressMonitor());
    }

    private IClasspathEntry createNewAndmoreContainer(String id) {
        IClasspathEntry andmoreClasspathEntry = JavaCore.newContainerEntry((IPath)new Path(id));
        return andmoreClasspathEntry;
    }
}

