/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.manager.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.framework.DevicePlugin;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.manager.persistence.IDeviceXmlTags;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DeviceXmlWriter
implements IDeviceXmlTags {
    public static void saveInstances() {
        File file = DevicePlugin.getDeviceXmlLocation();
        File file2 = new File(file, DevicePlugin.getDeviceXmlFileName());
        Document document = DeviceXmlWriter.createDocument(file2);
        if (document != null) {
            try {
                String[] stringArray;
                Element element = document.getDocumentElement();
                Element element2 = DeviceXmlWriter.createInstancesElement(document);
                element.appendChild(element2);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                if (!file2.getParentFile().exists()) {
                    file2.getParentFile().mkdirs();
                    if ("win32".equals(Platform.getOS())) {
                        stringArray = new String[]{"attrib", "+H", file2.getParentFile().getAbsolutePath()};
                        try {
                            Runtime.getRuntime().exec(stringArray);
                        }
                        catch (IOException iOException) {
                            BasePlugin.logError((String)"Unable to hide Sequoyah's configuration directory");
                        }
                    }
                }
                stringArray = new FileOutputStream(file2.getAbsoluteFile());
                StreamResult streamResult = new StreamResult((OutputStream)stringArray);
                DOMSource dOMSource = new DOMSource(document);
                transformer.transform(dOMSource, streamResult);
                stringArray.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                transformerConfigurationException.printStackTrace();
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                transformerFactoryConfigurationError.printStackTrace();
            }
            catch (TransformerException transformerException) {
                transformerException.printStackTrace();
            }
        }
    }

    private static Document createDocument(File file) {
        Document document = null;
        if (file != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
                document = dOMImplementation.createDocument(null, "sequoyah", null);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
        }
        return document;
    }

    private static Element createInstancesElement(Document document) {
        Element element = document.createElement("instances");
        InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
        for (IInstance iInstance : instanceRegistry.getInstances()) {
            IDeviceType iDeviceType = DeviceTypeRegistry.getInstance().getDeviceTypeById(iInstance.getDeviceTypeId());
            if (iDeviceType != null && !iDeviceType.isPersistent()) continue;
            Element element2 = document.createElement("instance");
            element2.setAttribute("name", iInstance.getName());
            String string = iInstance.getDeviceTypeId();
            element2.setAttribute("deviceType_id", string);
            if (element2 != null) {
                element.appendChild(element2);
            }
            Properties properties = iInstance.getProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                Element element3 = document.createElement(string2);
                Text text = document.createTextNode(string3);
                element3.appendChild(text);
                element2.appendChild(element3);
            }
        }
        return element;
    }
}

