/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;

public class FileUtils {
    private static final Function<File, String> GET_NAME = new Function<File, String>(){

        @Override
        public String apply(File file) {
            return file.getName();
        }
    };

    public static void deleteFolder(File folder) throws IOException {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                FileUtils.deleteFolder(file);
            }
        }
        if (!folder.delete()) {
            throw new IOException(String.format("Could not delete folder %s", folder));
        }
    }

    public static void emptyFolder(File folder) throws IOException {
        FileUtils.deleteFolder(folder);
        if (!folder.mkdirs()) {
            throw new IOException(String.format("Could not create empty folder %s", folder));
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        to = new File(to, from.getName());
        if (from.isDirectory()) {
            if (!to.exists() && !to.mkdirs()) {
                throw new IOException(String.format("Could not create directory %s", to));
            }
            File[] children = from.listFiles();
            if (children != null) {
                for (File child : children) {
                    FileUtils.copyFile(child, to);
                }
            }
        } else if (from.isFile()) {
            Files.copy(from, to);
        }
    }

    public static void delete(File file) throws IOException {
        boolean result = file.delete();
        if (!result) {
            throw new IOException("Failed to delete " + file.getAbsolutePath());
        }
    }

    public static void deleteIfExists(File file) throws IOException {
        boolean result = file.delete();
        if (!result && file.exists()) {
            throw new IOException("Failed to delete " + file.getAbsolutePath());
        }
    }

    public static File join(File dir, String ... paths) {
        return new File(dir, Joiner.on(File.separatorChar).join(paths));
    }

    public static String relativePath(File file, File dir) {
        Preconditions.checkArgument(file.isFile(), "%s is not a file.", file.getPath());
        Preconditions.checkArgument(dir.isDirectory(), "%s is not a directory.", dir.getPath());
        return dir.toURI().relativize(file.toURI()).getPath();
    }

    public static String sha1(File file) throws IOException {
        return Hashing.sha1().hashBytes(Files.toByteArray(file)).toString();
    }

    public static String getNamesAsCommaSeparatedList(Iterable<File> files) {
        return Joiner.on(", ").join(Iterables.transform(files, GET_NAME));
    }
}

