/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.screenrecord;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.ddmuilib.screenrecord.ScreenRecorderOptionsDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class ScreenRecorderAction {
    private static final String TITLE = "Screen Recorder";
    private static final String REMOTE_PATH = "/sdcard/ddmsrec.mp4";
    private final Shell mParentShell;
    private final IDevice mDevice;

    public ScreenRecorderAction(Shell parent, IDevice device) {
        this.mParentShell = parent;
        this.mDevice = device;
    }

    public void performAction() {
        ScreenRecorderOptionsDialog optionsDialog = new ScreenRecorderOptionsDialog(this.mParentShell);
        if (optionsDialog.open() == 1) {
            return;
        }
        final ScreenRecorderOptions options = new ScreenRecorderOptions.Builder().setBitRate(optionsDialog.getBitRate()).setSize(optionsDialog.getWidth(), optionsDialog.getHeight()).build();
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ScreenRecorderAction.this.mDevice.startScreenRecorder(ScreenRecorderAction.REMOTE_PATH, options, receiver);
                }
                catch (Exception e) {
                    ScreenRecorderAction.this.showError("Unexpected error while launching screenrecorder", e);
                    latch.countDown();
                }
            }
        }, TITLE).start();
        try {
            new ProgressMonitorDialog(this.mParentShell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int timeInSecond = 0;
                    monitor.beginTask("Recording...", -1);
                    while (!latch.await(1L, TimeUnit.SECONDS)) {
                        monitor.subTask(String.format("Recording...%d seconds elapsed", timeInSecond++));
                        if (!monitor.isCanceled()) continue;
                        receiver.cancel();
                        monitor.subTask("Stopping...");
                        latch.await(1L, TimeUnit.SECONDS);
                        break;
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            this.showError("Unexpected error while recording: ", e.getTargetException());
            return;
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        try {
            this.mDevice.pullFile(REMOTE_PATH, optionsDialog.getDestination().getAbsolutePath());
        }
        catch (Exception e) {
            this.showError("Unexpected error while copying video recording from device", e);
        }
        MessageDialog.openInformation((Shell)this.mParentShell, (String)TITLE, (String)("Screen recording saved at " + optionsDialog.getDestination().getAbsolutePath()));
    }

    private void showError(final String message, final Throwable e) {
        this.mParentShell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String msg = message;
                if (e != null) {
                    msg = msg + (e.getLocalizedMessage() != null ? ": " + e.getLocalizedMessage() : "");
                }
                MessageDialog.openError((Shell)ScreenRecorderAction.this.mParentShell, (String)ScreenRecorderAction.TITLE, (String)msg);
            }
        });
    }
}

