/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.net;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.TablePanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.DefaultKeyedValues2D;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class NetworkPanel
extends TablePanel {
    private static final long HISTORY_MILLIS = 30000L;
    private static final String PREFS_NETWORK_COL_TITLE = "networkPanel.title";
    private static final String PREFS_NETWORK_COL_RX_BYTES = "networkPanel.rxBytes";
    private static final String PREFS_NETWORK_COL_RX_PACKETS = "networkPanel.rxPackets";
    private static final String PREFS_NETWORK_COL_TX_BYTES = "networkPanel.txBytes";
    private static final String PREFS_NETWORK_COL_TX_PACKETS = "networkPanel.txPackets";
    private static final String PROC_XT_QTAGUID = "/proc/net/xt_qtaguid/stats";
    private static final Color TOTAL_COLOR = Color.GRAY;
    private static final Color[] SERIES_COLORS = new Color[]{Color.decode("0x2bc4c1"), Color.decode("0xD50F25"), Color.decode("0x3369E8"), Color.decode("0xEEB211"), Color.decode("0x00bd2e"), Color.decode("0xae26ae")};
    private Display mDisplay;
    private Composite mPanel;
    private Composite mHeader;
    private Label mSpeedLabel;
    private Combo mSpeedCombo;
    private long mSpeedMillis;
    private Button mRunningButton;
    private Button mResetButton;
    private JFreeChart mChart;
    private ChartComposite mChartComposite;
    private ValueAxis mDomainAxis;
    private TimeSeriesCollection mTotalCollection;
    private TimeSeries mRxTotalSeries;
    private TimeSeries mTxTotalSeries;
    private LiveTimeTableXYDataset mRxDetailDataset;
    private LiveTimeTableXYDataset mTxDetailDataset;
    private XYAreaRenderer mTotalRenderer;
    private StackedXYAreaRenderer2 mRenderer;
    private Table mTable;
    private TableViewer mTableViewer;
    private int mActiveUid = -1;
    private ArrayList<TrackedItem> mTrackedItems = new ArrayList();
    private SampleThread mSampleThread;
    private NetworkSnapshot mLastSnapshot;

    @Override
    protected Control createControl(Composite parent) {
        this.mDisplay = parent.getDisplay();
        this.mPanel = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        this.mPanel.setLayout((Layout)formLayout);
        this.createHeader();
        this.createChart();
        this.createTable();
        return this.mPanel;
    }

    private void createHeader() {
        this.mHeader = new Composite(this.mPanel, 0);
        RowLayout layout = new RowLayout();
        layout.center = true;
        this.mHeader.setLayout((Layout)layout);
        this.mSpeedLabel = new Label(this.mHeader, 0);
        this.mSpeedLabel.setText("Speed:");
        this.mSpeedCombo = new Combo(this.mHeader, 8);
        this.mSpeedCombo.add("Fast (100ms)");
        this.mSpeedCombo.add("Medium (250ms)");
        this.mSpeedCombo.add("Slow (500ms)");
        this.mSpeedCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkPanel.this.updateSpeed();
            }
        });
        this.mSpeedCombo.select(1);
        this.updateSpeed();
        this.mRunningButton = new Button(this.mHeader, 8);
        this.mRunningButton.setText("Start");
        this.mRunningButton.setEnabled(false);
        this.mRunningButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean alreadyRunning = NetworkPanel.this.mSampleThread != null;
                NetworkPanel.this.updateRunning(!alreadyRunning);
            }
        });
        this.mResetButton = new Button(this.mHeader, 8);
        this.mResetButton.setText("Reset");
        this.mResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkPanel.this.clearTrackedItems();
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.mHeader.setLayoutData((Object)data);
    }

    private void createChart() {
        this.mChart = ChartFactory.createTimeSeriesChart(null, null, null, null, (boolean)false, (boolean)false, (boolean)false);
        this.mRxTotalSeries = new TimeSeries((Comparable)((Object)"RX total"));
        this.mTxTotalSeries = new TimeSeries((Comparable)((Object)"TX total"));
        this.mRxTotalSeries.setMaximumItemAge(30000L);
        this.mTxTotalSeries.setMaximumItemAge(30000L);
        this.mTotalCollection = new TimeSeriesCollection();
        this.mTotalCollection.addSeries(this.mRxTotalSeries);
        this.mTotalCollection.addSeries(this.mTxTotalSeries);
        this.mRxDetailDataset = new LiveTimeTableXYDataset();
        this.mTxDetailDataset = new LiveTimeTableXYDataset();
        this.mTotalRenderer = new XYAreaRenderer(4);
        this.mRenderer = new StackedXYAreaRenderer2();
        XYPlot xyPlot = this.mChart.getXYPlot();
        xyPlot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        xyPlot.setDataset(0, (XYDataset)this.mTotalCollection);
        xyPlot.setDataset(1, (XYDataset)this.mRxDetailDataset);
        xyPlot.setDataset(2, (XYDataset)this.mTxDetailDataset);
        xyPlot.setRenderer(0, (XYItemRenderer)this.mTotalRenderer);
        xyPlot.setRenderer(1, (XYItemRenderer)this.mRenderer);
        xyPlot.setRenderer(2, (XYItemRenderer)this.mRenderer);
        this.mDomainAxis = xyPlot.getDomainAxis();
        this.mDomainAxis.setAutoRange(false);
        NumberAxis axis = new NumberAxis();
        axis.setNumberFormatOverride((NumberFormat)new BytesFormat(true));
        axis.setAutoRangeMinimumSize(50.0);
        xyPlot.setRangeAxis((ValueAxis)axis);
        xyPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        xyPlot.addRangeMarker((Marker)new ValueMarker(0.0, (Paint)Color.BLACK, (Stroke)new BasicStroke(2.0f)));
        ValueMarker rxMarker = new ValueMarker(0.0);
        rxMarker.setStroke((Stroke)new BasicStroke(0.0f));
        rxMarker.setLabel("RX");
        rxMarker.setLabelFont(rxMarker.getLabelFont().deriveFont(30.0f));
        rxMarker.setLabelPaint((Paint)Color.LIGHT_GRAY);
        rxMarker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        rxMarker.setLabelTextAnchor(TextAnchor.BOTTOM_RIGHT);
        xyPlot.addRangeMarker((Marker)rxMarker);
        ValueMarker txMarker = new ValueMarker(0.0);
        txMarker.setStroke((Stroke)new BasicStroke(0.0f));
        txMarker.setLabel("TX");
        txMarker.setLabelFont(txMarker.getLabelFont().deriveFont(30.0f));
        txMarker.setLabelPaint((Paint)Color.LIGHT_GRAY);
        txMarker.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
        txMarker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
        xyPlot.addRangeMarker((Marker)txMarker);
        this.mChartComposite = new ChartComposite(this.mPanel, 2048, this.mChart, 680, 420, 300, 200, 4096, 4096, true, true, true, true, false, true);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.mHeader);
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(70);
        data.right = new FormAttachment(100);
        this.mChartComposite.setLayoutData((Object)data);
    }

    private void createTable() {
        this.mTable = new Table(this.mPanel, 67586);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.mChartComposite);
        data.left = new FormAttachment((Control)this.mChartComposite, 0, 0x1000000);
        data.bottom = new FormAttachment(100);
        this.mTable.setLayoutData((Object)data);
        this.mTable.setHeaderVisible(true);
        this.mTable.setLinesVisible(true);
        IPreferenceStore store = DdmUiPreferences.getStore();
        TableHelper.createTableColumn(this.mTable, "", 0x1000000, NetworkPanel.buildSampleText(2), null, null);
        TableHelper.createTableColumn(this.mTable, "Tag", 16384, NetworkPanel.buildSampleText(32), PREFS_NETWORK_COL_TITLE, store);
        TableHelper.createTableColumn(this.mTable, "RX bytes", 131072, NetworkPanel.buildSampleText(12), PREFS_NETWORK_COL_RX_BYTES, store);
        TableHelper.createTableColumn(this.mTable, "RX packets", 131072, NetworkPanel.buildSampleText(12), PREFS_NETWORK_COL_RX_PACKETS, store);
        TableHelper.createTableColumn(this.mTable, "TX bytes", 131072, NetworkPanel.buildSampleText(12), PREFS_NETWORK_COL_TX_BYTES, store);
        TableHelper.createTableColumn(this.mTable, "TX packets", 131072, NetworkPanel.buildSampleText(12), PREFS_NETWORK_COL_TX_PACKETS, store);
        this.mTableViewer = new TableViewer(this.mTable);
        this.mTableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
    }

    private void updateSpeed() {
        switch (this.mSpeedCombo.getSelectionIndex()) {
            case 0: {
                this.mSpeedMillis = 100L;
                break;
            }
            case 1: {
                this.mSpeedMillis = 250L;
                break;
            }
            case 2: {
                this.mSpeedMillis = 500L;
            }
        }
    }

    private void updateRunning(boolean shouldRun) {
        boolean alreadyRunning;
        boolean bl = alreadyRunning = this.mSampleThread != null;
        if (alreadyRunning && !shouldRun) {
            this.mSampleThread.finish();
            this.mSampleThread = null;
            this.mRunningButton.setText("Start");
            this.mHeader.pack();
        } else if (!alreadyRunning && shouldRun) {
            this.mSampleThread = new SampleThread();
            this.mSampleThread.start();
            this.mRunningButton.setText("Stop");
            this.mHeader.pack();
        }
    }

    @Override
    public void setFocus() {
        this.mPanel.setFocus();
    }

    private static Color nextSeriesColor(int index) {
        return SERIES_COLORS[index % SERIES_COLORS.length];
    }

    public TrackedItem findOrCreateTrackedItem(int uid, int tag) {
        for (TrackedItem item : this.mTrackedItems) {
            if (item.uid != uid || item.tag != tag) continue;
            return item;
        }
        TrackedItem item = new TrackedItem(uid, tag);
        if (item.isTotal()) {
            item.color = TOTAL_COLOR;
            item.label = "Total";
        } else {
            int size = this.mTrackedItems.size();
            item.color = NetworkPanel.nextSeriesColor(size);
            Formatter formatter = new Formatter();
            item.label = "0x" + formatter.format("%08x", tag);
            formatter.close();
        }
        item.colorImage = new Image((Device)this.mDisplay, 20, 20);
        GC gc = new GC((Drawable)item.colorImage);
        gc.setBackground(new org.eclipse.swt.graphics.Color((Device)this.mDisplay, item.color.getRed(), item.color.getGreen(), item.color.getBlue()));
        gc.fillRectangle(item.colorImage.getBounds());
        gc.dispose();
        this.mTrackedItems.add(item);
        return item;
    }

    public void clearTrackedItems() {
        this.mRxTotalSeries.clear();
        this.mTxTotalSeries.clear();
        this.mRxDetailDataset.clear();
        this.mTxDetailDataset.clear();
        this.mTrackedItems.clear();
        this.mTableViewer.setInput(this.mTrackedItems);
    }

    private void updateSeriesPaint() {
        for (TrackedItem item : this.mTrackedItems) {
            int seriesIndex = this.mRxDetailDataset.getColumnIndex(item.label);
            if (seriesIndex < 0) continue;
            this.mRenderer.setSeriesPaint(seriesIndex, (Paint)item.color);
            this.mRenderer.setSeriesFillPaint(seriesIndex, (Paint)item.color);
        }
        int count = this.mTotalCollection.getSeriesCount();
        for (int i = 0; i < count; ++i) {
            this.mTotalRenderer.setSeriesPaint(i, (Paint)TOTAL_COLOR);
            this.mTotalRenderer.setSeriesFillPaint(i, (Paint)TOTAL_COLOR);
        }
    }

    @Override
    public void deviceSelected() {
        this.clientSelected();
    }

    @Override
    public void clientSelected() {
        this.mActiveUid = -1;
        Client client = this.getCurrentClient();
        if (client != null) {
            int pid = client.getClientData().getPid();
            try {
                UidParser uidParser = new UidParser();
                this.getCurrentDevice().executeShellCommand("cat /proc/" + pid + "/status", uidParser);
                this.mActiveUid = uidParser.uid;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (AdbCommandRejectedException e) {
                e.printStackTrace();
            }
            catch (ShellCommandUnresponsiveException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.clearTrackedItems();
        this.updateRunning(false);
        boolean validUid = this.mActiveUid != -1;
        this.mRunningButton.setEnabled(validUid);
    }

    @Override
    public void clientChanged(Client client, int changeMask) {
    }

    public void performSample() {
        IDevice device = this.getCurrentDevice();
        if (device == null) {
            return;
        }
        try {
            NetworkSnapshotParser parser = new NetworkSnapshotParser();
            device.executeShellCommand("cat /proc/net/xt_qtaguid/stats", parser);
            if (parser.isError()) {
                this.mDisplay.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NetworkPanel.this.updateRunning(false);
                        String title = "Problem reading stats";
                        String message = "Problem reading xt_qtaguid network statistics from selected device.";
                        Status status = new Status(4, "NetworkPanel", 0, "Problem reading xt_qtaguid network statistics from selected device.", null);
                        ErrorDialog.openError((Shell)NetworkPanel.this.mPanel.getShell(), (String)"Problem reading stats", (String)"Problem reading stats", (IStatus)status);
                    }
                });
                return;
            }
            NetworkSnapshot snapshot = parser.getParsedSnapshot();
            if (this.mLastSnapshot == null) {
                this.mLastSnapshot = snapshot;
                return;
            }
            NetworkSnapshot delta = NetworkSnapshot.subtract(snapshot, this.mLastSnapshot);
            this.mLastSnapshot = snapshot;
            if (!this.mDisplay.isDisposed()) {
                this.mDisplay.syncExec((Runnable)new UpdateDeltaRunnable(delta, snapshot.timestamp));
            }
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (AdbCommandRejectedException e) {
            e.printStackTrace();
        }
        catch (ShellCommandUnresponsiveException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private static String buildSampleText(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append("X");
        }
        return builder.toString();
    }

    public static class LiveTimeTableXYDataset
    extends AbstractIntervalXYDataset
    implements TableXYDataset {
        private DefaultKeyedValues2D mValues = new DefaultKeyedValues2D(true);

        public void addValue(Number value, TimePeriod rowKey, String columnKey) {
            this.mValues.addValue(value, (Comparable)rowKey, (Comparable)((Object)columnKey));
        }

        public void removeBefore(long beforeMillis) {
            TimePeriod period;
            while (this.mValues.getRowCount() > 0 && (period = (TimePeriod)this.mValues.getRowKey(0)).getEnd().getTime() < beforeMillis) {
                this.mValues.removeRow(0);
            }
        }

        public int getColumnIndex(String key) {
            return this.mValues.getColumnIndex((Comparable)((Object)key));
        }

        public void clear() {
            this.mValues.clear();
            this.fireDatasetChanged();
        }

        public void fireDatasetChanged() {
            super.fireDatasetChanged();
        }

        public int getItemCount() {
            return this.mValues.getRowCount();
        }

        public int getItemCount(int series) {
            return this.mValues.getRowCount();
        }

        public int getSeriesCount() {
            return this.mValues.getColumnCount();
        }

        public Comparable getSeriesKey(int series) {
            return this.mValues.getColumnKey(series);
        }

        public double getXValue(int series, int item) {
            TimePeriod period = (TimePeriod)this.mValues.getRowKey(item);
            return period.getStart().getTime();
        }

        public double getStartXValue(int series, int item) {
            return this.getXValue(series, item);
        }

        public double getEndXValue(int series, int item) {
            return this.getXValue(series, item);
        }

        public Number getX(int series, int item) {
            return this.getXValue(series, item);
        }

        public Number getStartX(int series, int item) {
            return this.getXValue(series, item);
        }

        public Number getEndX(int series, int item) {
            return this.getXValue(series, item);
        }

        public Number getY(int series, int item) {
            return this.mValues.getValue(item, series);
        }

        public Number getStartY(int series, int item) {
            return this.getY(series, item);
        }

        public Number getEndY(int series, int item) {
            return this.getY(series, item);
        }
    }

    private static class BytesFormat
    extends NumberFormat {
        private final String[] mUnits;
        private final DecimalFormat mFormat = new DecimalFormat("#.#");

        public BytesFormat(boolean perSecond) {
            this.mUnits = perSecond ? new String[]{"B/s", "KB/s", "MB/s"} : new String[]{"B", "KB", "MB"};
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            int i;
            double value = Math.abs(number);
            for (i = 0; value > 1024.0 && i < this.mUnits.length - 1; value /= 1024.0, ++i) {
            }
            toAppendTo.append(this.mFormat.format(value));
            toAppendTo.append(this.mUnits[i]);
            return toAppendTo;
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            return this.format((long)number, toAppendTo, pos);
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            return null;
        }
    }

    private static class LabelProvider
    implements ITableLabelProvider {
        private final DecimalFormat mFormat = new DecimalFormat("#,###");

        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof TrackedItem) {
                TrackedItem item = (TrackedItem)element;
                switch (columnIndex) {
                    case 0: {
                        return item.colorImage;
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TrackedItem) {
                TrackedItem item = (TrackedItem)element;
                switch (columnIndex) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return item.label;
                    }
                    case 2: {
                        return this.mFormat.format(item.rxBytes);
                    }
                    case 3: {
                        return this.mFormat.format(item.rxPackets);
                    }
                    case 4: {
                        return this.mFormat.format(item.txBytes);
                    }
                    case 5: {
                        return this.mFormat.format(item.txPackets);
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return NetworkPanel.this.mTrackedItems.toArray();
        }
    }

    private static class NetworkSnapshot
    implements Iterable<Entry> {
        private ArrayList<Entry> mStats = new ArrayList();
        public final long timestamp;

        public NetworkSnapshot(long timestamp) {
            this.timestamp = timestamp;
        }

        public void clear() {
            this.mStats.clear();
        }

        public void combine(Entry entry) {
            Entry existing = this.findEntry(entry.iface, entry.uid, entry.set, entry.tag);
            if (existing != null) {
                existing.rxBytes += entry.rxBytes;
                existing.rxPackets += entry.rxPackets;
                existing.txBytes += entry.txBytes;
                existing.txPackets += entry.txPackets;
            } else {
                this.mStats.add(entry);
            }
        }

        @Override
        public Iterator<Entry> iterator() {
            return this.mStats.iterator();
        }

        public Entry findEntry(String iface, int uid, int set, int tag) {
            for (Entry entry : this.mStats) {
                if (entry.uid != uid || entry.set != set || entry.tag != tag || !NetworkPanel.equal(entry.iface, iface)) continue;
                return entry;
            }
            return null;
        }

        public static NetworkSnapshot subtract(NetworkSnapshot left, NetworkSnapshot right) {
            NetworkSnapshot result = new NetworkSnapshot(left.timestamp - right.timestamp);
            for (Entry leftEntry : left) {
                Entry rightEntry = right.findEntry(leftEntry.iface, leftEntry.uid, leftEntry.set, leftEntry.tag);
                if (rightEntry == null) continue;
                Entry resultEntry = new Entry();
                resultEntry.iface = leftEntry.iface;
                resultEntry.uid = leftEntry.uid;
                resultEntry.set = leftEntry.set;
                resultEntry.tag = leftEntry.tag;
                resultEntry.rxBytes = leftEntry.rxBytes - rightEntry.rxBytes;
                resultEntry.rxPackets = leftEntry.rxPackets - rightEntry.rxPackets;
                resultEntry.txBytes = leftEntry.txBytes - rightEntry.txBytes;
                resultEntry.txPackets = leftEntry.txPackets - rightEntry.txPackets;
                result.combine(resultEntry);
            }
            return result;
        }

        public static class Entry {
            public String iface;
            public int uid;
            public int set;
            public int tag;
            public long rxBytes;
            public long rxPackets;
            public long txBytes;
            public long txPackets;

            public boolean isEmpty() {
                return this.rxBytes == 0L && this.rxPackets == 0L && this.txBytes == 0L && this.txPackets == 0L;
            }
        }
    }

    private static class NetworkSnapshotParser
    extends MultiLineReceiver {
        private NetworkSnapshot mSnapshot = new NetworkSnapshot(System.currentTimeMillis());

        public boolean isError() {
            return this.mSnapshot == null;
        }

        public NetworkSnapshot getParsedSnapshot() {
            return this.mSnapshot;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public void processNewLines(String[] lines) {
            for (String line : lines) {
                String[] cols;
                if (line.endsWith("No such file or directory")) {
                    this.mSnapshot = null;
                    return;
                }
                if (line.startsWith("idx") || (cols = line.split(" ")).length < 9) continue;
                NetworkSnapshot.Entry entry = new NetworkSnapshot.Entry();
                entry.iface = null;
                entry.uid = Integer.parseInt(cols[3]);
                entry.set = -1;
                entry.tag = NetworkSnapshotParser.kernelToTag(cols[2]);
                entry.rxBytes = Long.parseLong(cols[5]);
                entry.rxPackets = Long.parseLong(cols[6]);
                entry.txBytes = Long.parseLong(cols[7]);
                entry.txPackets = Long.parseLong(cols[8]);
                this.mSnapshot.combine(entry);
            }
        }

        public static int kernelToTag(String string) {
            int length = string.length();
            if (length > 10) {
                return Long.decode(string.substring(0, length - 8)).intValue();
            }
            return 0;
        }
    }

    private static class UidParser
    extends MultiLineReceiver {
        public int uid = -1;

        private UidParser() {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public void processNewLines(String[] lines) {
            for (String line : lines) {
                if (!line.startsWith("Uid:")) continue;
                String[] cols = line.split("\t");
                this.uid = Integer.parseInt(cols[1]);
            }
        }
    }

    private class UpdateDeltaRunnable
    implements Runnable {
        private final NetworkSnapshot mDelta;
        private final long mEndTime;

        public UpdateDeltaRunnable(NetworkSnapshot delta, long endTime) {
            this.mDelta = delta;
            this.mEndTime = endTime;
        }

        @Override
        public void run() {
            if (NetworkPanel.this.mDisplay.isDisposed()) {
                return;
            }
            Millisecond time = new Millisecond(new Date(this.mEndTime));
            for (NetworkSnapshot.Entry entry : this.mDelta) {
                if (NetworkPanel.this.mActiveUid != entry.uid) continue;
                TrackedItem item = NetworkPanel.this.findOrCreateTrackedItem(entry.uid, entry.tag);
                item.recordDelta(time, this.mDelta.timestamp, entry);
            }
            long beforeMillis = this.mEndTime - 30000L;
            NetworkPanel.this.mRxDetailDataset.removeBefore(beforeMillis);
            NetworkPanel.this.mTxDetailDataset.removeBefore(beforeMillis);
            NetworkPanel.this.mRxDetailDataset.fireDatasetChanged();
            NetworkPanel.this.mTxDetailDataset.fireDatasetChanged();
            NetworkPanel.this.mDomainAxis.setRange((double)(this.mEndTime - 30000L), (double)this.mEndTime);
            NetworkPanel.this.updateSeriesPaint();
            NetworkPanel.this.mTableViewer.setInput((Object)NetworkPanel.this.mTrackedItems);
        }
    }

    private class TrackedItem {
        public final int uid;
        public final int tag;
        public Color color;
        public Image colorImage;
        public String label;
        public long rxBytes;
        public long rxPackets;
        public long txBytes;
        public long txPackets;

        public TrackedItem(int uid, int tag) {
            this.uid = uid;
            this.tag = tag;
        }

        public boolean isTotal() {
            return this.tag == 0;
        }

        public void recordDelta(Millisecond time, long deltaMillis, NetworkSnapshot.Entry delta) {
            long rxBytesPerSecond = delta.rxBytes * 1000L / deltaMillis;
            long txBytesPerSecond = delta.txBytes * 1000L / deltaMillis;
            if (this.isTotal()) {
                NetworkPanel.this.mRxTotalSeries.addOrUpdate((RegularTimePeriod)time, (double)rxBytesPerSecond);
                NetworkPanel.this.mTxTotalSeries.addOrUpdate((RegularTimePeriod)time, (double)(-txBytesPerSecond));
            } else {
                NetworkPanel.this.mRxDetailDataset.addValue(rxBytesPerSecond, (TimePeriod)time, this.label);
                NetworkPanel.this.mTxDetailDataset.addValue(-txBytesPerSecond, (TimePeriod)time, this.label);
            }
            this.rxBytes += delta.rxBytes;
            this.rxPackets += delta.rxPackets;
            this.txBytes += delta.txBytes;
            this.txPackets += delta.txPackets;
        }
    }

    private class SampleThread
    extends Thread {
        private volatile boolean mFinish;

        private SampleThread() {
        }

        public void finish() {
            this.mFinish = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.mFinish && !NetworkPanel.this.mDisplay.isDisposed()) {
                NetworkPanel.this.performSample();
                try {
                    Thread.sleep(NetworkPanel.this.mSpeedMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

