/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class LogCatFilterSettingsDialog
extends TitleAreaDialog {
    private static final String TITLE = "Logcat Message Filter Settings";
    private static final String DEFAULT_MESSAGE = "Filter logcat messages by the source's tag, pid or minimum log level.\nEmpty fields will match all messages.";
    private String mFilterName;
    private String mTag;
    private String mText;
    private String mPid;
    private String mAppName;
    private String mLogLevel;
    private Text mFilterNameText;
    private Text mTagFilterText;
    private Text mTextFilterText;
    private Text mPidFilterText;
    private Text mAppNameFilterText;
    private Combo mLogLevelCombo;
    private Button mOkButton;

    public LogCatFilterSettingsDialog(Shell parentShell) {
        super(parentShell);
        this.setDefaults("", "", "", "", "", Log.LogLevel.VERBOSE);
    }

    public void setDefaults(String filterName, String tag, String text, String pid, String appName, Log.LogLevel level) {
        this.mFilterName = filterName;
        this.mTag = tag;
        this.mText = text;
        this.mPid = pid;
        this.mAppName = appName;
        this.mLogLevel = level.getStringValue();
    }

    protected Control createDialogArea(Composite shell) {
        this.setTitle(TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        Composite parent = (Composite)super.createDialogArea(shell);
        Composite c = new Composite(parent, 2048);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(1808));
        this.createLabel(c, "Filter Name:");
        this.mFilterNameText = new Text(c, 2048);
        this.mFilterNameText.setLayoutData((Object)new GridData(768));
        this.mFilterNameText.setText(this.mFilterName);
        this.createSeparator(c);
        this.createLabel(c, "by Log Tag:");
        this.mTagFilterText = new Text(c, 2048);
        this.mTagFilterText.setLayoutData((Object)new GridData(768));
        this.mTagFilterText.setText(this.mTag);
        this.createLabel(c, "by Log Message:");
        this.mTextFilterText = new Text(c, 2048);
        this.mTextFilterText.setLayoutData((Object)new GridData(768));
        this.mTextFilterText.setText(this.mText);
        this.createLabel(c, "by PID:");
        this.mPidFilterText = new Text(c, 2048);
        this.mPidFilterText.setLayoutData((Object)new GridData(768));
        this.mPidFilterText.setText(this.mPid);
        this.createLabel(c, "by Application Name:");
        this.mAppNameFilterText = new Text(c, 2048);
        this.mAppNameFilterText.setLayoutData((Object)new GridData(768));
        this.mAppNameFilterText.setText(this.mAppName);
        this.createLabel(c, "by Log Level:");
        this.mLogLevelCombo = new Combo(c, 12);
        this.mLogLevelCombo.setItems(LogCatFilterSettingsDialog.getLogLevels().toArray(new String[0]));
        this.mLogLevelCombo.select(LogCatFilterSettingsDialog.getLogLevels().indexOf(this.mLogLevel));
        ModifyListener m = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DialogStatus status = LogCatFilterSettingsDialog.this.validateDialog();
                LogCatFilterSettingsDialog.this.mOkButton.setEnabled(status.valid);
                LogCatFilterSettingsDialog.this.setErrorMessage(status.message);
            }
        };
        this.mFilterNameText.addModifyListener(m);
        this.mTagFilterText.addModifyListener(m);
        this.mTextFilterText.addModifyListener(m);
        this.mPidFilterText.addModifyListener(m);
        this.mAppNameFilterText.addModifyListener(m);
        return c;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.mOkButton = this.getButton(0);
        DialogStatus status = this.validateDialog();
        this.mOkButton.setEnabled(status.valid);
    }

    private DialogStatus validateDialog() {
        String appNameText;
        String messageText;
        String tagText;
        if (this.mFilterNameText.getText().trim().equals("")) {
            return new DialogStatus(false, "Please provide a name for this filter.");
        }
        String pidText = this.mPidFilterText.getText().trim();
        if (pidText.trim().length() > 0) {
            int pid = 0;
            try {
                pid = Integer.parseInt(pidText);
            }
            catch (NumberFormatException e) {
                return new DialogStatus(false, "PID should be a positive integer.");
            }
            if (pid < 0) {
                return new DialogStatus(false, "PID should be a positive integer.");
            }
        }
        if ((tagText = this.mTagFilterText.getText().trim()).trim().length() > 0) {
            try {
                Pattern.compile(tagText);
            }
            catch (PatternSyntaxException e) {
                return new DialogStatus(false, "Invalid regex used in tag field: " + e.getMessage());
            }
        }
        if ((messageText = this.mTextFilterText.getText().trim()).trim().length() > 0) {
            try {
                Pattern.compile(messageText);
            }
            catch (PatternSyntaxException e) {
                return new DialogStatus(false, "Invalid regex used in text field: " + e.getMessage());
            }
        }
        if ((appNameText = this.mAppNameFilterText.getText().trim()).trim().length() > 0) {
            try {
                Pattern.compile(appNameText);
            }
            catch (PatternSyntaxException e) {
                return new DialogStatus(false, "Invalid regex used in application name field: " + e.getMessage());
            }
        }
        return new DialogStatus(true, null);
    }

    private void createSeparator(Composite c) {
        Label l = new Label(c, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
    }

    private void createLabel(Composite c, String text) {
        Label l = new Label(c, 0);
        l.setText(text);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        l.setLayoutData((Object)gd);
    }

    protected void okPressed() {
        this.mFilterName = this.mFilterNameText.getText();
        this.mTag = this.mTagFilterText.getText();
        this.mText = this.mTextFilterText.getText();
        this.mLogLevel = this.mLogLevelCombo.getText();
        this.mPid = this.mPidFilterText.getText();
        this.mAppName = this.mAppNameFilterText.getText();
        super.okPressed();
    }

    public String getFilterName() {
        return this.mFilterName;
    }

    public String getTag() {
        return this.mTag;
    }

    public String getText() {
        return this.mText;
    }

    public String getPid() {
        return this.mPid;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public String getLogLevel() {
        return this.mLogLevel;
    }

    public static List<String> getLogLevels() {
        ArrayList<String> logLevels = new ArrayList<String>();
        for (Log.LogLevel l : Log.LogLevel.values()) {
            logLevels.add(l.getStringValue());
        }
        return logLevels;
    }

    private static final class DialogStatus {
        final boolean valid;
        final String message;

        private DialogStatus(boolean isValid, String errMessage) {
            this.valid = isValid;
            this.message = errMessage;
        }
    }
}

