/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.heap;

import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmlib.NativeLibraryMapInfo;
import com.android.ddmlib.NativeStackCallInfo;
import com.android.ddmuilib.DdmUiPreferences;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class NativeSymbolResolverTask
implements IRunnableWithProgress {
    private static final String ADDR2LINE;
    private static final String ADDR2LINE64;
    private static final String DEFAULT_SYMBOLS_FOLDER;
    private static final int ELF_CLASS32 = 1;
    private static final int ELF_CLASS64 = 2;
    private static final int ELF_DATA2LSB = 1;
    private static final int ELF_PT_LOAD = 1;
    private List<NativeAllocationInfo> mCallSites;
    private List<NativeLibraryMapInfo> mMappedLibraries;
    private List<String> mSymbolSearchFolders;
    private SortedSet<Long> mUnresolvedAddresses;
    private Set<Long> mUnresolvableAddresses;
    private Map<NativeLibraryMapInfo, Set<Long>> mUnresolvedAddressesPerLibrary;
    private Set<Long> mUnmappedAddresses;
    private Map<Long, NativeStackCallInfo> mAddressResolution;
    private Set<String> mNotFoundLibraries;
    private String mAddr2LineErrorMessage = null;
    private String mAddr2LineCmd;

    public NativeSymbolResolverTask(List<NativeAllocationInfo> callSites, List<NativeLibraryMapInfo> mappedLibraries, String symbolSearchPath, String abi) {
        this.mCallSites = callSites;
        this.mMappedLibraries = mappedLibraries;
        this.mSymbolSearchFolders = new ArrayList<String>();
        this.mSymbolSearchFolders.add(DEFAULT_SYMBOLS_FOLDER);
        this.mSymbolSearchFolders.addAll(Arrays.asList(symbolSearchPath.split(":")));
        this.mUnresolvedAddresses = new TreeSet<Long>();
        this.mUnresolvableAddresses = new HashSet<Long>();
        this.mUnresolvedAddressesPerLibrary = new HashMap<NativeLibraryMapInfo, Set<Long>>();
        this.mUnmappedAddresses = new HashSet<Long>();
        this.mAddressResolution = new HashMap<Long, NativeStackCallInfo>();
        this.mNotFoundLibraries = new HashSet<String>();
        this.mAddr2LineCmd = abi == null || abi.startsWith("32") ? ADDR2LINE : ADDR2LINE64;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Resolving symbols", -1);
        this.collectAllUnresolvedAddresses();
        this.checkCancellation(monitor);
        this.mapUnresolvedAddressesToLibrary();
        this.checkCancellation(monitor);
        this.resolveLibraryAddresses(monitor);
        this.checkCancellation(monitor);
        this.resolveCallSites(this.mCallSites);
        monitor.done();
    }

    private void collectAllUnresolvedAddresses() {
        for (NativeAllocationInfo callSite : this.mCallSites) {
            this.mUnresolvedAddresses.addAll(callSite.getStackCallAddresses());
        }
    }

    private void mapUnresolvedAddressesToLibrary() {
        HashSet<Long> mappedAddresses = new HashSet<Long>();
        for (NativeLibraryMapInfo lib : this.mMappedLibraries) {
            SortedSet<Long> addressesInLibrary = this.mUnresolvedAddresses.subSet(lib.getStartAddress(), lib.getEndAddress() + 1L);
            if (addressesInLibrary.size() <= 0) continue;
            this.mUnresolvedAddressesPerLibrary.put(lib, addressesInLibrary);
            mappedAddresses.addAll(addressesInLibrary);
        }
        this.mUnmappedAddresses.addAll(this.mUnresolvedAddresses);
        this.mUnmappedAddresses.removeAll(mappedAddresses);
    }

    private void resolveLibraryAddresses(IProgressMonitor monitor) throws InterruptedException {
        for (NativeLibraryMapInfo lib : this.mUnresolvedAddressesPerLibrary.keySet()) {
            String libPath = this.getLibraryLocation(lib);
            Set<Long> addressesToResolve = this.mUnresolvedAddressesPerLibrary.get(lib);
            if (libPath == null) {
                this.mNotFoundLibraries.add(lib.getLibraryName());
                this.markAddressesNotResolvable(addressesToResolve, lib);
            } else {
                monitor.subTask(String.format("Resolving addresses mapped to %s.", libPath));
                this.resolveAddresses(lib, libPath, addressesToResolve);
            }
            this.checkCancellation(monitor);
        }
    }

    private long unsigned(byte value, long shift) {
        return ((long)value & 0xFFL) << (int)shift;
    }

    private short elfGetHalfWord(RandomAccessFile file, long offset) throws IOException {
        byte[] buf = new byte[2];
        file.seek(offset);
        file.readFully(buf, 0, 2);
        return (short)(this.unsigned(buf[0], 0L) | this.unsigned(buf[1], 8L));
    }

    private int elfGetWord(RandomAccessFile file, long offset) throws IOException {
        byte[] buf = new byte[4];
        file.seek(offset);
        file.readFully(buf, 0, 4);
        return (int)(this.unsigned(buf[0], 0L) | this.unsigned(buf[1], 8L) | this.unsigned(buf[2], 16L) | this.unsigned(buf[3], 24L));
    }

    private long elfGetDoubleWord(RandomAccessFile file, long offset) throws IOException {
        byte[] buf = new byte[8];
        file.seek(offset);
        file.readFully(buf, 0, 8);
        return this.unsigned(buf[0], 0L) | this.unsigned(buf[1], 8L) | this.unsigned(buf[2], 16L) | this.unsigned(buf[3], 24L) | this.unsigned(buf[4], 32L) | this.unsigned(buf[5], 40L) | this.unsigned(buf[6], 48L) | this.unsigned(buf[7], 56L);
    }

    private long getLoadBase(String libPath) {
        long pVaddrOffset;
        long pOffsetOffset;
        long pTypeOffset;
        long ePhoffOffset;
        long ePhnumOffset;
        long elfPhdrSize;
        boolean elf32;
        RandomAccessFile file;
        try {
            file = new RandomAccessFile(libPath, "r");
        }
        catch (FileNotFoundException e) {
            return 0L;
        }
        byte[] buffer = new byte[8];
        try {
            file.readFully(buffer, 0, 6);
        }
        catch (IOException e) {
            return 0L;
        }
        if (buffer[0] != 127 || buffer[1] != 69 || buffer[2] != 76 || buffer[3] != 70 || buffer[5] != 1) {
            return 0L;
        }
        if (buffer[4] == 1) {
            elf32 = true;
            elfPhdrSize = 32L;
            ePhnumOffset = 44L;
            ePhoffOffset = 28L;
            pTypeOffset = 0L;
            pOffsetOffset = 4L;
            pVaddrOffset = 8L;
        } else if (buffer[4] == 2) {
            elf32 = false;
            elfPhdrSize = 56L;
            ePhnumOffset = 56L;
            ePhoffOffset = 32L;
            pTypeOffset = 0L;
            pOffsetOffset = 8L;
            pVaddrOffset = 16L;
        } else {
            return 0L;
        }
        try {
            int ePhnum = this.elfGetHalfWord(file, ePhnumOffset);
            long offset = elf32 ? (long)this.elfGetWord(file, ePhoffOffset) : this.elfGetDoubleWord(file, ePhoffOffset);
            for (int i = 0; i < ePhnum; ++i) {
                int pType = this.elfGetWord(file, offset + pTypeOffset);
                long pOffset = elf32 ? (long)this.elfGetWord(file, offset + pOffsetOffset) : this.elfGetDoubleWord(file, offset + pOffsetOffset);
                if (pType == 1 && pOffset == 0L) {
                    long pVaddr = elf32 ? (long)this.elfGetWord(file, offset + pVaddrOffset) : this.elfGetDoubleWord(file, offset + pVaddrOffset);
                    return pVaddr;
                }
                offset += elfPhdrSize;
            }
        }
        catch (IOException e) {
            return 0L;
        }
        return 0L;
    }

    private void resolveAddresses(NativeLibraryMapInfo lib, String libPath, Set<Long> addressesToResolve) {
        Process addr2line;
        try {
            addr2line = new ProcessBuilder(this.mAddr2LineCmd, "-C", "-f", "-e", libPath).start();
        }
        catch (IOException e) {
            this.mAddr2LineErrorMessage = e.getMessage();
            this.markAddressesNotResolvable(addressesToResolve, lib);
            return;
        }
        BufferedReader resultReader = new BufferedReader(new InputStreamReader(addr2line.getInputStream()));
        BufferedWriter addressWriter = new BufferedWriter(new OutputStreamWriter(addr2line.getOutputStream()));
        long libStartAddress = this.isExecutable(lib) ? 0L : lib.getStartAddress();
        long libLoadBase = this.isExecutable(lib) ? 0L : this.getLoadBase(libPath);
        try {
            for (Long addr : addressesToResolve) {
                long offset = addr - libStartAddress + libLoadBase;
                addressWriter.write(Long.toHexString(offset));
                addressWriter.newLine();
                addressWriter.flush();
                String method = resultReader.readLine();
                String sourceFile = resultReader.readLine();
                this.mAddressResolution.put(addr, new NativeStackCallInfo(addr, lib.getLibraryName(), method, sourceFile));
            }
        }
        catch (IOException e) {
            for (Long addr : addressesToResolve) {
                if (this.mAddressResolution.get(addr) != null) continue;
                this.markAddressNotResolvable(lib, addr);
            }
        }
        try {
            resultReader.close();
            addressWriter.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        addr2line.destroy();
    }

    private boolean isExecutable(NativeLibraryMapInfo object) {
        String devicePath = object.getLibraryName();
        return devicePath.contains("/bin/");
    }

    private void markAddressesNotResolvable(Set<Long> addressesToResolve, NativeLibraryMapInfo lib) {
        for (Long addr : addressesToResolve) {
            this.markAddressNotResolvable(lib, addr);
        }
    }

    private void markAddressNotResolvable(NativeLibraryMapInfo lib, Long addr) {
        this.mAddressResolution.put(addr, new NativeStackCallInfo(addr, lib.getLibraryName(), Long.toHexString(addr), ""));
        this.mUnresolvableAddresses.add(addr);
    }

    private String getLibraryLocation(NativeLibraryMapInfo lib) {
        String pathOnDevice = lib.getLibraryName();
        String libName = new File(pathOnDevice).getName();
        for (String p : this.mSymbolSearchFolders) {
            String fullPath = p + File.separator + pathOnDevice;
            if (new File(fullPath).exists()) {
                return fullPath;
            }
            fullPath = p + File.separator + libName;
            if (!new File(fullPath).exists()) continue;
            return fullPath;
        }
        return null;
    }

    private void resolveCallSites(List<NativeAllocationInfo> callSites) {
        for (NativeAllocationInfo callSite : callSites) {
            ArrayList<NativeStackCallInfo> stackInfo = new ArrayList<NativeStackCallInfo>();
            for (Long addr : callSite.getStackCallAddresses()) {
                NativeStackCallInfo info = this.mAddressResolution.get(addr);
                if (info == null) continue;
                stackInfo.add(info);
            }
            callSite.setResolvedStackCall(stackInfo);
        }
    }

    private void checkCancellation(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    public String getAddr2LineErrorMessage() {
        return this.mAddr2LineErrorMessage;
    }

    public Set<Long> getUnmappedAddresses() {
        return this.mUnmappedAddresses;
    }

    public Set<Long> getUnresolvableAddresses() {
        return this.mUnresolvableAddresses;
    }

    public Set<String> getNotFoundLibraries() {
        return this.mNotFoundLibraries;
    }

    static {
        String addr2lineEnv = System.getenv("ANDROID_ADDR2LINE");
        String addr2line64Env = System.getenv("ANDROID_ADDR2LINE64");
        ADDR2LINE = addr2lineEnv != null ? addr2lineEnv : DdmUiPreferences.getAddr2Line();
        ADDR2LINE64 = addr2line64Env != null ? addr2line64Env : DdmUiPreferences.getAddr2Line64();
        String symbols = System.getenv("ANDROID_SYMBOLS");
        DEFAULT_SYMBOLS_FOLDER = symbols != null ? symbols : DdmUiPreferences.getSymbolDirectory();
    }
}

