/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.heap;

import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmlib.NativeStackCallInfo;
import com.android.ddmuilib.heap.NativeHeapSnapshot;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class NativeHeapDataImporter
implements IRunnableWithProgress {
    private final LineNumberReader mReader;
    private int mStartLineNumber;
    private int mEndLineNumber;
    private NativeHeapSnapshot mSnapshot;

    public NativeHeapDataImporter(Reader stream) {
        this.mReader = new LineNumberReader(stream);
        this.mReader.setLineNumber(1);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Importing Heap Data", -1);
        ArrayList<NativeAllocationInfo> allocations = new ArrayList<NativeAllocationInfo>();
        try {
            String line;
            do {
                StringBuilder sb = new StringBuilder();
                this.mStartLineNumber = this.mReader.getLineNumber();
                while ((line = this.mReader.readLine()) != null && line.trim().length() != 0) {
                    sb.append(line);
                    sb.append('\n');
                }
                this.mEndLineNumber = this.mReader.getLineNumber();
                String allocationBlock = sb.toString();
                if (allocationBlock.trim().length() <= 0) continue;
                allocations.add(this.getNativeAllocation(allocationBlock));
            } while (line != null);
        }
        catch (Exception e2) {
            RuntimeException e2;
            if (e2.getMessage() == null) {
                e2 = new RuntimeException(this.genericErrorMessage("Unexpected Parse error"));
            }
            throw new InvocationTargetException(e2);
        }
        finally {
            try {
                this.mReader.close();
            }
            catch (IOException e) {}
            monitor.done();
        }
        this.mSnapshot = new NativeHeapSnapshot(allocations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeAllocationInfo getNativeAllocation(String block) {
        Scanner sc = new Scanner(block);
        try {
            String kw = sc.next();
            if (!"Allocations:".equals(kw)) {
                throw new InputMismatchException(this.expectedKeywordErrorMessage("Allocations:", kw));
            }
            int allocations = sc.nextInt();
            kw = sc.next();
            if (!"Size:".equals(kw)) {
                throw new InputMismatchException(this.expectedKeywordErrorMessage("Size:", kw));
            }
            int size = sc.nextInt();
            kw = sc.next();
            if (!"TotalSize:".equals(kw)) {
                throw new InputMismatchException(this.expectedKeywordErrorMessage("TotalSize:", kw));
            }
            int totalSize = sc.nextInt();
            if (totalSize != size * allocations) {
                throw new InputMismatchException(this.genericErrorMessage("Total Size does not match size * # of allocations"));
            }
            NativeAllocationInfo info = new NativeAllocationInfo(size, allocations);
            kw = sc.next();
            if (!"BeginStacktrace:".equals(kw)) {
                throw new InputMismatchException(this.expectedKeywordErrorMessage("BeginStacktrace:", kw));
            }
            ArrayList<NativeStackCallInfo> stackInfo = new ArrayList<NativeStackCallInfo>();
            Pattern endTracePattern = Pattern.compile("EndStacktrace");
            do {
                long address = sc.nextLong(16);
                info.addStackCallAddress(address);
                String library = sc.next();
                sc.next();
                String method = this.scanTillSeparator(sc, "---");
                String filename = "";
                if (!this.isUnresolved(method, address)) {
                    filename = sc.next();
                }
                stackInfo.add(new NativeStackCallInfo(address, library, method, filename));
            } while (!sc.hasNext(endTracePattern));
            info.setResolvedStackCall(stackInfo);
            NativeAllocationInfo nativeAllocationInfo = info;
            return nativeAllocationInfo;
        }
        finally {
            sc.close();
        }
    }

    private String scanTillSeparator(Scanner sc, String separator) {
        String token;
        StringBuilder sb = new StringBuilder();
        while (!(token = sc.next()).equals(separator)) {
            sb.append(token);
            sb.append(' ');
        }
        return sb.toString().trim();
    }

    private boolean isUnresolved(String method, long address) {
        return Long.toString(address, 16).equals(method);
    }

    private String genericErrorMessage(String message) {
        return String.format("%1$s between lines %2$d and %3$d", message, this.mStartLineNumber, this.mEndLineNumber);
    }

    private String expectedKeywordErrorMessage(String expected, String actual) {
        return String.format("Expected keyword '%1$s', saw '%2$s' between lines %3$d to %4$d.", expected, actual, this.mStartLineNumber, this.mEndLineNumber);
    }

    public NativeHeapSnapshot getImportedSnapshot() {
        return this.mSnapshot;
    }
}

