/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.Panel;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.vmtrace.VmTraceOptionsDialog;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public final class DevicePanel
extends Panel
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IClientChangeListener {
    private static final String PREFS_COL_NAME_SERIAL = "devicePanel.Col0";
    private static final String PREFS_COL_PID_STATE = "devicePanel.Col1";
    private static final String PREFS_COL_PORT_BUILD = "devicePanel.Col4";
    private static final int DEVICE_COL_SERIAL = 0;
    private static final int DEVICE_COL_STATE = 1;
    private static final int DEVICE_COL_BUILD = 4;
    private static final int CLIENT_COL_NAME = 0;
    private static final int CLIENT_COL_PID = 1;
    private static final int CLIENT_COL_THREAD = 2;
    private static final int CLIENT_COL_HEAP = 3;
    private static final int CLIENT_COL_PORT = 4;
    public static final int ICON_WIDTH = 16;
    public static final String ICON_THREAD = "thread.png";
    public static final String ICON_HEAP = "heap.png";
    public static final String ICON_HALT = "halt.png";
    public static final String ICON_GC = "gc.png";
    public static final String ICON_HPROF = "hprof.png";
    public static final String ICON_TRACING_START = "tracing_start.png";
    public static final String ICON_TRACING_STOP = "tracing_stop.png";
    private IDevice mCurrentDevice;
    private Client mCurrentClient;
    private Tree mTree;
    private TreeViewer mTreeViewer;
    private Image mDeviceImage;
    private Image mEmulatorImage;
    private Image mThreadImage;
    private Image mHeapImage;
    private Image mWaitingImage;
    private Image mDebuggerImage;
    private Image mDebugErrorImage;
    private final ArrayList<IUiSelectionListener> mListeners = new ArrayList();
    private final ArrayList<IDevice> mDevicesToExpand = new ArrayList();
    private boolean mAdvancedPortSupport;

    public DevicePanel(boolean advancedPortSupport) {
        this.mAdvancedPortSupport = advancedPortSupport;
    }

    public void addSelectionListener(IUiSelectionListener listener) {
        this.mListeners.add(listener);
    }

    public void removeSelectionListener(IUiSelectionListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    protected Control createControl(Composite parent) {
        this.loadImages(parent.getDisplay());
        parent.setLayout((Layout)new FillLayout());
        this.mTree = new Tree(parent, 65540);
        this.mTree.setHeaderVisible(true);
        this.mTree.setLinesVisible(true);
        IPreferenceStore store = DdmUiPreferences.getStore();
        TableHelper.createTreeColumn(this.mTree, "Name", 16384, "com.android.home", PREFS_COL_NAME_SERIAL, store);
        TableHelper.createTreeColumn(this.mTree, "", 16384, "Offline", PREFS_COL_PID_STATE, store);
        TreeColumn col = new TreeColumn(this.mTree, 0);
        col.setWidth(24);
        col.setResizable(false);
        col = new TreeColumn(this.mTree, 0);
        col.setWidth(24);
        col.setResizable(false);
        TableHelper.createTreeColumn(this.mTree, "", 16384, "9999-9999", PREFS_COL_PORT_BUILD, store);
        this.mTreeViewer = new TreeViewer(this.mTree);
        this.mTreeViewer.setAutoExpandLevel(-1);
        this.mTreeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.mTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DevicePanel.this.notifyListeners();
            }
        });
        return this.mTree;
    }

    @Override
    public void setFocus() {
        this.mTree.setFocus();
    }

    @Override
    protected void postCreation() {
        AndroidDebugBridge.addDebugBridgeChangeListener(this);
        AndroidDebugBridge.addDeviceChangeListener(this);
        AndroidDebugBridge.addClientChangeListener(this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener(this);
        AndroidDebugBridge.removeDeviceChangeListener(this);
        AndroidDebugBridge.removeClientChangeListener(this);
    }

    public Client getSelectedClient() {
        return this.mCurrentClient;
    }

    public IDevice getSelectedDevice() {
        return this.mCurrentDevice;
    }

    public void killSelectedClient() {
        if (this.mCurrentClient != null) {
            Client client = this.mCurrentClient;
            TreePath treePath = new TreePath(new Object[]{this.mCurrentDevice});
            TreeSelection treeSelection = new TreeSelection(treePath);
            this.mTreeViewer.setSelection((ISelection)treeSelection);
            client.kill();
        }
    }

    public void forceGcOnSelectedClient() {
        if (this.mCurrentClient != null) {
            this.mCurrentClient.executeGarbageCollector();
        }
    }

    public void dumpHprof() {
        if (this.mCurrentClient != null) {
            this.mCurrentClient.dumpHprof();
        }
    }

    public void toggleMethodProfiling() {
        if (this.mCurrentClient == null) {
            return;
        }
        try {
            this.toggleMethodProfiling(this.mCurrentClient);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.mTree.getShell(), (String)"Method Profiling", (String)("Unexpected I/O error while starting/stopping profiling: " + Throwables.getRootCause((Throwable)e).getMessage()));
        }
    }

    private void toggleMethodProfiling(Client client) throws IOException {
        ClientData cd = this.mCurrentClient.getClientData();
        if (cd.getMethodProfilingStatus() == ClientData.MethodProfilingStatus.TRACER_ON) {
            this.mCurrentClient.stopMethodTracer();
        } else if (cd.getMethodProfilingStatus() == ClientData.MethodProfilingStatus.SAMPLER_ON) {
            this.mCurrentClient.stopSamplingProfiler();
        } else {
            boolean supportsSampling = cd.hasFeature("method-sample-profiling");
            boolean shouldUseTracing = true;
            int samplingIntervalMicros = 1;
            if (supportsSampling) {
                VmTraceOptionsDialog dialog = new VmTraceOptionsDialog(this.mTree.getShell());
                if (dialog.open() == 1) {
                    return;
                }
                shouldUseTracing = dialog.shouldUseTracing();
                if (!shouldUseTracing) {
                    samplingIntervalMicros = dialog.getSamplingIntervalMicros();
                }
            }
            if (shouldUseTracing) {
                this.mCurrentClient.startMethodTracer();
            } else {
                this.mCurrentClient.startSamplingProfiler(samplingIntervalMicros, TimeUnit.MICROSECONDS);
            }
        }
    }

    public void setEnabledHeapOnSelectedClient(boolean enable) {
        if (this.mCurrentClient != null) {
            this.mCurrentClient.setHeapUpdateEnabled(enable);
        }
    }

    public void setEnabledThreadOnSelectedClient(boolean enable) {
        if (this.mCurrentClient != null) {
            this.mCurrentClient.setThreadUpdateEnabled(enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bridgeChanged(final AndroidDebugBridge bridge) {
        if (!this.mTree.isDisposed()) {
            this.exec(new Runnable(){

                @Override
                public void run() {
                    if (!DevicePanel.this.mTree.isDisposed()) {
                        DevicePanel.this.mTreeViewer.setInput((Object)bridge);
                        DevicePanel.this.notifyListeners();
                    } else {
                        AndroidDebugBridge.removeDebugBridgeChangeListener(DevicePanel.this);
                        AndroidDebugBridge.removeDeviceChangeListener(DevicePanel.this);
                        AndroidDebugBridge.removeClientChangeListener(DevicePanel.this);
                    }
                }
            });
        }
        ArrayList<IDevice> arrayList = this.mDevicesToExpand;
        synchronized (arrayList) {
            this.mDevicesToExpand.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceConnected(IDevice device) {
        this.exec(new Runnable(){

            @Override
            public void run() {
                if (!DevicePanel.this.mTree.isDisposed()) {
                    DevicePanel.this.mTreeViewer.refresh();
                    DevicePanel.this.notifyListeners();
                } else {
                    AndroidDebugBridge.removeDebugBridgeChangeListener(DevicePanel.this);
                    AndroidDebugBridge.removeDeviceChangeListener(DevicePanel.this);
                    AndroidDebugBridge.removeClientChangeListener(DevicePanel.this);
                }
            }
        });
        if (!device.hasClients()) {
            ArrayList<IDevice> arrayList = this.mDevicesToExpand;
            synchronized (arrayList) {
                this.mDevicesToExpand.add(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceDisconnected(IDevice device) {
        this.deviceConnected(device);
        ArrayList<IDevice> arrayList = this.mDevicesToExpand;
        synchronized (arrayList) {
            this.mDevicesToExpand.remove(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceChanged(final IDevice device, int changeMask) {
        boolean expand = false;
        ArrayList<IDevice> arrayList = this.mDevicesToExpand;
        synchronized (arrayList) {
            int index = this.mDevicesToExpand.indexOf(device);
            if (device.hasClients() && index != -1) {
                this.mDevicesToExpand.remove(index);
                expand = true;
            }
        }
        final boolean finalExpand = expand;
        this.exec(new Runnable(){

            @Override
            public void run() {
                if (!DevicePanel.this.mTree.isDisposed()) {
                    IDevice selectedDevice = DevicePanel.this.getSelectedDevice();
                    DevicePanel.this.mTreeViewer.refresh((Object)device);
                    if (selectedDevice == device && DevicePanel.this.mTreeViewer.getSelection().isEmpty()) {
                        DevicePanel.this.mTreeViewer.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{device})));
                    }
                    DevicePanel.this.notifyListeners();
                    if (finalExpand) {
                        DevicePanel.this.mTreeViewer.setExpandedState((Object)device, true);
                    }
                } else {
                    AndroidDebugBridge.removeDebugBridgeChangeListener(DevicePanel.this);
                    AndroidDebugBridge.removeDeviceChangeListener(DevicePanel.this);
                    AndroidDebugBridge.removeClientChangeListener(DevicePanel.this);
                }
            }
        });
    }

    @Override
    public void clientChanged(final Client client, final int changeMask) {
        this.exec(new Runnable(){

            @Override
            public void run() {
                if (!DevicePanel.this.mTree.isDisposed()) {
                    DevicePanel.this.mTreeViewer.refresh((Object)client);
                    if ((changeMask & 2) == 2 && client.getClientData().getDebuggerConnectionStatus() == ClientData.DebuggerStatus.WAITING) {
                        IDevice device = client.getDevice();
                        if (!DevicePanel.this.mTreeViewer.getExpandedState((Object)device)) {
                            DevicePanel.this.mTreeViewer.setExpandedState((Object)device, true);
                        }
                        TreePath treePath = new TreePath(new Object[]{device, client});
                        TreeSelection treeSelection = new TreeSelection(treePath);
                        DevicePanel.this.mTreeViewer.setSelection((ISelection)treeSelection);
                        if (DevicePanel.this.mAdvancedPortSupport) {
                            client.setAsSelectedClient();
                        }
                        DevicePanel.this.notifyListeners(device, client);
                    }
                } else {
                    AndroidDebugBridge.removeDebugBridgeChangeListener(DevicePanel.this);
                    AndroidDebugBridge.removeDeviceChangeListener(DevicePanel.this);
                    AndroidDebugBridge.removeClientChangeListener(DevicePanel.this);
                }
            }
        });
    }

    private void loadImages(Display display) {
        ImageLoader loader = ImageLoader.getDdmUiLibLoader();
        if (this.mDeviceImage == null) {
            this.mDeviceImage = loader.loadImage(display, "device.png", 16, 16, display.getSystemColor(3));
        }
        if (this.mEmulatorImage == null) {
            this.mEmulatorImage = loader.loadImage(display, "emulator.png", 16, 16, display.getSystemColor(9));
        }
        if (this.mThreadImage == null) {
            this.mThreadImage = loader.loadImage(display, ICON_THREAD, 16, 16, display.getSystemColor(7));
        }
        if (this.mHeapImage == null) {
            this.mHeapImage = loader.loadImage(display, ICON_HEAP, 16, 16, display.getSystemColor(9));
        }
        if (this.mWaitingImage == null) {
            this.mWaitingImage = loader.loadImage(display, "debug-wait.png", 16, 16, display.getSystemColor(3));
        }
        if (this.mDebuggerImage == null) {
            this.mDebuggerImage = loader.loadImage(display, "debug-attach.png", 16, 16, display.getSystemColor(5));
        }
        if (this.mDebugErrorImage == null) {
            this.mDebugErrorImage = loader.loadImage(display, "debug-error.png", 16, 16, display.getSystemColor(3));
        }
    }

    private static String getStateString(IDevice d) {
        IDevice.DeviceState deviceState = d.getState();
        if (deviceState == IDevice.DeviceState.ONLINE) {
            return "Online";
        }
        if (deviceState == IDevice.DeviceState.OFFLINE) {
            return "Offline";
        }
        if (deviceState == IDevice.DeviceState.BOOTLOADER) {
            return "Bootloader";
        }
        return "??";
    }

    private void exec(Runnable runnable) {
        try {
            Display display = this.mTree.getDisplay();
            display.asyncExec(runnable);
        }
        catch (SWTException e) {
            AndroidDebugBridge.removeDebugBridgeChangeListener(this);
            AndroidDebugBridge.removeDeviceChangeListener(this);
            AndroidDebugBridge.removeClientChangeListener(this);
        }
    }

    private void notifyListeners() {
        TreeItem[] items = this.mTree.getSelection();
        Client client = null;
        IDevice device = null;
        if (items.length == 1) {
            Object object = items[0].getData();
            if (object instanceof Client) {
                client = (Client)object;
                device = client.getDevice();
            } else if (object instanceof IDevice) {
                device = (IDevice)object;
            }
        }
        this.notifyListeners(device, client);
    }

    private void notifyListeners(IDevice selectedDevice, Client selectedClient) {
        if (selectedDevice != this.mCurrentDevice || selectedClient != this.mCurrentClient) {
            this.mCurrentDevice = selectedDevice;
            this.mCurrentClient = selectedClient;
            for (IUiSelectionListener listener : this.mListeners) {
                try {
                    listener.selectionChanged(selectedDevice, selectedClient);
                }
                catch (Exception e) {}
            }
        }
    }

    public static interface IUiSelectionListener {
        public void selectionChanged(IDevice var1, Client var2);
    }

    private class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof IDevice) {
                IDevice device = (IDevice)element;
                if (device.isEmulator()) {
                    return DevicePanel.this.mEmulatorImage;
                }
                return DevicePanel.this.mDeviceImage;
            }
            if (element instanceof Client) {
                Client client = (Client)element;
                ClientData cd = client.getClientData();
                switch (columnIndex) {
                    case 0: {
                        switch (cd.getDebuggerConnectionStatus()) {
                            case DEFAULT: {
                                return null;
                            }
                            case WAITING: {
                                return DevicePanel.this.mWaitingImage;
                            }
                            case ATTACHED: {
                                return DevicePanel.this.mDebuggerImage;
                            }
                            case ERROR: {
                                return DevicePanel.this.mDebugErrorImage;
                            }
                        }
                        return null;
                    }
                    case 2: {
                        if (client.isThreadUpdateEnabled()) {
                            return DevicePanel.this.mThreadImage;
                        }
                        return null;
                    }
                    case 3: {
                        if (client.isHeapUpdateEnabled()) {
                            return DevicePanel.this.mHeapImage;
                        }
                        return null;
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IDevice) {
                IDevice device = (IDevice)element;
                switch (columnIndex) {
                    case 0: {
                        return device.getName();
                    }
                    case 1: {
                        return DevicePanel.getStateString(device);
                    }
                    case 4: {
                        String version = device.getProperty("ro.build.version.release");
                        if (version != null) {
                            String debuggable = device.getProperty("ro.debuggable");
                            if (device.isEmulator()) {
                                String avdName = device.getAvdName();
                                if (avdName == null) {
                                    avdName = "?";
                                }
                                if (debuggable != null && debuggable.equals("1")) {
                                    return String.format("%1$s [%2$s, debug]", avdName, version);
                                }
                                return String.format("%1$s [%2$s]", avdName, version);
                            }
                            if (debuggable != null && debuggable.equals("1")) {
                                return String.format("%1$s, debug", version);
                            }
                            return String.format("%1$s", version);
                        }
                        return "unknown";
                    }
                }
            } else if (element instanceof Client) {
                Client client = (Client)element;
                ClientData cd = client.getClientData();
                switch (columnIndex) {
                    case 0: {
                        String name = cd.getClientDescription();
                        if (name != null) {
                            if (cd.isValidUserId() && cd.getUserId() != 0) {
                                return String.format(Locale.US, "%s (%d)", name, cd.getUserId());
                            }
                            return name;
                        }
                        return "?";
                    }
                    case 1: {
                        return Integer.toString(cd.getPid());
                    }
                    case 4: {
                        if (!DevicePanel.this.mAdvancedPortSupport) break;
                        int port = client.getDebuggerListenPort();
                        String portString = "?";
                        if (port != 0) {
                            portString = Integer.toString(port);
                        }
                        if (client.isSelectedClient()) {
                            return String.format("%1$s / %2$d", portString, DdmPreferences.getSelectedDebugPort());
                        }
                        return portString;
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IDevice) {
                return ((IDevice)parentElement).getClients();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Client) {
                return ((Client)element).getDevice();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IDevice) {
                return ((IDevice)element).hasClients();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof AndroidDebugBridge) {
                return ((AndroidDebugBridge)inputElement).getDevices();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

