/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.StackTracePanel;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.TablePanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class AllocationPanel
extends TablePanel {
    private static final String PREFS_ALLOC_COL_NUMBER = "allocPanel.Col00";
    private static final String PREFS_ALLOC_COL_SIZE = "allocPanel.Col0";
    private static final String PREFS_ALLOC_COL_CLASS = "allocPanel.Col1";
    private static final String PREFS_ALLOC_COL_THREAD = "allocPanel.Col2";
    private static final String PREFS_ALLOC_COL_TRACE_CLASS = "allocPanel.Col3";
    private static final String PREFS_ALLOC_COL_TRACE_METHOD = "allocPanel.Col4";
    private static final String PREFS_ALLOC_SASH = "allocPanel.sash";
    private static final String PREFS_STACK_COLUMN = "allocPanel.stack.col0";
    private Composite mAllocationBase;
    private Table mAllocationTable;
    private TableViewer mAllocationViewer;
    private StackTracePanel mStackTracePanel;
    private Table mStackTraceTable;
    private Button mEnableButton;
    private Button mRequestButton;
    private Button mTraceFilterCheck;
    private final AllocationInfo.AllocationSorter mSorter = new AllocationInfo.AllocationSorter();
    private TableColumn mSortColumn;
    private Image mSortUpImg;
    private Image mSortDownImg;
    private String mFilterText = null;

    @Override
    protected Control createControl(Composite parent) {
        final IPreferenceStore store = DdmUiPreferences.getStore();
        Display display = parent.getDisplay();
        this.mSortUpImg = ImageLoader.getDdmUiLibLoader().loadImage("sort_up.png", display);
        this.mSortDownImg = ImageLoader.getDdmUiLibLoader().loadImage("sort_down.png", display);
        this.mAllocationBase = new Composite(parent, 0);
        this.mAllocationBase.setLayout((Layout)new FormLayout());
        Composite topParent = new Composite(this.mAllocationBase, 0);
        topParent.setLayout((Layout)new GridLayout(6, false));
        this.mEnableButton = new Button(topParent, 8);
        this.mEnableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Client current = AllocationPanel.this.getCurrentClient();
                ClientData.AllocationTrackingStatus status = current.getClientData().getAllocationStatus();
                if (status == ClientData.AllocationTrackingStatus.ON) {
                    current.enableAllocationTracker(false);
                } else {
                    current.enableAllocationTracker(true);
                }
                current.requestAllocationStatus();
            }
        });
        this.mRequestButton = new Button(topParent, 8);
        this.mRequestButton.setText("Get Allocations");
        this.mRequestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AllocationPanel.this.getCurrentClient().requestAllocationDetails();
            }
        });
        this.setUpButtons(false, ClientData.AllocationTrackingStatus.OFF);
        Composite spacer = new Composite(topParent, 0);
        GridData gridData = new GridData(768);
        spacer.setLayoutData((Object)gridData);
        new Label(topParent, 0).setText("Filter:");
        final Text filterText = new Text(topParent, 2048);
        gridData = new GridData(768);
        filterText.setLayoutData((Object)gridData);
        gridData.widthHint = 200;
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AllocationPanel.this.mFilterText = filterText.getText().trim();
                AllocationPanel.this.mAllocationViewer.refresh();
            }
        });
        this.mTraceFilterCheck = new Button(topParent, 32);
        this.mTraceFilterCheck.setText("Inc. trace");
        this.mTraceFilterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AllocationPanel.this.mAllocationViewer.refresh();
            }
        });
        this.mAllocationTable = new Table(topParent, 65538);
        gridData = new GridData(1808);
        this.mAllocationTable.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 6;
        this.mAllocationTable.setHeaderVisible(true);
        this.mAllocationTable.setLinesVisible(true);
        final TableColumn numberCol = TableHelper.createTableColumn(this.mAllocationTable, "Alloc Order", 131072, "Alloc Order", PREFS_ALLOC_COL_NUMBER, store);
        numberCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AllocationPanel.this.setSortColumn(numberCol, AllocationInfo.SortMode.NUMBER);
            }
        });
        final TableColumn sizeCol = TableHelper.createTableColumn(this.mAllocationTable, "Allocation Size", 131072, "888", PREFS_ALLOC_COL_SIZE, store);
        sizeCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AllocationPanel.this.setSortColumn(sizeCol, AllocationInfo.SortMode.SIZE);
            }
        });
        final TableColumn classCol = TableHelper.createTableColumn(this.mAllocationTable, "Allocated Class", 16384, "Allocated Class", PREFS_ALLOC_COL_CLASS, store);
        classCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AllocationPanel.this.setSortColumn(classCol, AllocationInfo.SortMode.CLASS);
            }
        });
        final TableColumn threadCol = TableHelper.createTableColumn(this.mAllocationTable, "Thread Id", 16384, "999", PREFS_ALLOC_COL_THREAD, store);
        threadCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AllocationPanel.this.setSortColumn(threadCol, AllocationInfo.SortMode.THREAD);
            }
        });
        final TableColumn inClassCol = TableHelper.createTableColumn(this.mAllocationTable, "Allocated in", 16384, "utime", PREFS_ALLOC_COL_TRACE_CLASS, store);
        inClassCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AllocationPanel.this.setSortColumn(inClassCol, AllocationInfo.SortMode.IN_CLASS);
            }
        });
        final TableColumn inMethodCol = TableHelper.createTableColumn(this.mAllocationTable, "Allocated in", 16384, "utime", PREFS_ALLOC_COL_TRACE_METHOD, store);
        inMethodCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AllocationPanel.this.setSortColumn(inMethodCol, AllocationInfo.SortMode.IN_METHOD);
            }
        });
        switch (this.mSorter.getSortMode()) {
            case SIZE: {
                this.mSortColumn = sizeCol;
                break;
            }
            case CLASS: {
                this.mSortColumn = classCol;
                break;
            }
            case THREAD: {
                this.mSortColumn = threadCol;
                break;
            }
            case IN_CLASS: {
                this.mSortColumn = inClassCol;
                break;
            }
            case IN_METHOD: {
                this.mSortColumn = inMethodCol;
            }
        }
        this.mSortColumn.setImage(this.mSorter.isDescending() ? this.mSortDownImg : this.mSortUpImg);
        this.mAllocationViewer = new TableViewer(this.mAllocationTable);
        this.mAllocationViewer.setContentProvider((IContentProvider)new AllocationContentProvider());
        this.mAllocationViewer.setLabelProvider((IBaseLabelProvider)new AllocationLabelProvider());
        this.mAllocationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AllocationInfo selectedAlloc = AllocationPanel.this.getAllocationSelection(event.getSelection());
                AllocationPanel.this.updateAllocationStackTrace(selectedAlloc);
            }
        });
        final Sash sash = new Sash(this.mAllocationBase, 256);
        Color darkGray = parent.getDisplay().getSystemColor(16);
        sash.setBackground(darkGray);
        this.mStackTracePanel = new StackTracePanel();
        this.mStackTraceTable = this.mStackTracePanel.createPanel(this.mAllocationBase, PREFS_STACK_COLUMN, store);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)sash, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        topParent.setLayoutData((Object)data);
        final FormData sashData = new FormData();
        sashData.top = store != null && store.contains(PREFS_ALLOC_SASH) ? new FormAttachment(0, store.getInt(PREFS_ALLOC_SASH)) : new FormAttachment(50, 0);
        sashData.left = new FormAttachment(0, 0);
        sashData.right = new FormAttachment(100, 0);
        sash.setLayoutData((Object)sashData);
        data = new FormData();
        data.top = new FormAttachment((Control)sash, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.mStackTraceTable.setLayoutData((Object)data);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rectangle sashRect = sash.getBounds();
                Rectangle panelRect = AllocationPanel.this.mAllocationBase.getClientArea();
                int bottom = panelRect.height - sashRect.height - 100;
                e.y = Math.max(Math.min(e.y, bottom), 100);
                if (e.y != sashRect.y) {
                    sashData.top = new FormAttachment(0, e.y);
                    store.setValue(AllocationPanel.PREFS_ALLOC_SASH, e.y);
                    AllocationPanel.this.mAllocationBase.layout();
                }
            }
        });
        return this.mAllocationBase;
    }

    @Override
    public void dispose() {
        this.mSortUpImg.dispose();
        this.mSortDownImg.dispose();
        super.dispose();
    }

    @Override
    public void setFocus() {
        this.mAllocationTable.setFocus();
    }

    @Override
    public void clientChanged(final Client client, int changeMask) {
        if (client == this.getCurrentClient()) {
            if ((changeMask & 0x200) != 0) {
                try {
                    this.mAllocationTable.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AllocationPanel.this.mAllocationViewer.refresh();
                            AllocationPanel.this.updateAllocationStackCall();
                        }
                    });
                }
                catch (SWTException e) {}
            } else if ((changeMask & 0x400) != 0) {
                try {
                    this.mAllocationTable.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AllocationPanel.this.setUpButtons(true, client.getClientData().getAllocationStatus());
                        }
                    });
                }
                catch (SWTException sWTException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void deviceSelected() {
    }

    @Override
    public void clientSelected() {
        if (this.mAllocationTable.isDisposed()) {
            return;
        }
        Client client = this.getCurrentClient();
        this.mStackTracePanel.setCurrentClient(client);
        this.mStackTracePanel.setViewerInput(null);
        if (client != null) {
            this.setUpButtons(true, client.getClientData().getAllocationStatus());
        } else {
            this.setUpButtons(false, ClientData.AllocationTrackingStatus.OFF);
        }
        this.mAllocationViewer.setInput((Object)client);
    }

    private void updateAllocationStackCall() {
        Client client = this.getCurrentClient();
        if (client != null) {
            AllocationInfo selectedAlloc = this.getAllocationSelection(null);
            if (selectedAlloc != null) {
                this.updateAllocationStackTrace(selectedAlloc);
            } else {
                this.updateAllocationStackTrace(null);
            }
        }
    }

    private void updateAllocationStackTrace(AllocationInfo alloc) {
        this.mStackTracePanel.setViewerInput(alloc);
    }

    @Override
    protected void setTableFocusListener() {
        this.addTableToFocusListener(this.mAllocationTable);
        this.addTableToFocusListener(this.mStackTraceTable);
    }

    private AllocationInfo getAllocationSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection == null) {
            selection = this.mAllocationViewer.getSelection();
        }
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof AllocationInfo) {
            return (AllocationInfo)object;
        }
        return null;
    }

    private void setUpButtons(boolean enabled, ClientData.AllocationTrackingStatus trackingStatus) {
        if (enabled) {
            switch (trackingStatus) {
                case UNKNOWN: {
                    this.mEnableButton.setText("?");
                    this.mEnableButton.setEnabled(false);
                    this.mRequestButton.setEnabled(false);
                    break;
                }
                case OFF: {
                    this.mEnableButton.setText("Start Tracking");
                    this.mEnableButton.setEnabled(true);
                    this.mRequestButton.setEnabled(false);
                    break;
                }
                case ON: {
                    this.mEnableButton.setText("Stop Tracking");
                    this.mEnableButton.setEnabled(true);
                    this.mRequestButton.setEnabled(true);
                }
            }
        } else {
            this.mEnableButton.setEnabled(false);
            this.mRequestButton.setEnabled(false);
            this.mEnableButton.setText("Start Tracking");
        }
    }

    private void setSortColumn(TableColumn column, AllocationInfo.SortMode sortMode) {
        this.mSorter.setSortMode(sortMode);
        this.mAllocationTable.setRedraw(false);
        if (this.mSortColumn != column) {
            this.mSortColumn.setImage(null);
        }
        this.mSortColumn = column;
        if (this.mSorter.isDescending()) {
            this.mSortColumn.setImage(this.mSortDownImg);
        } else {
            this.mSortColumn.setImage(this.mSortUpImg);
        }
        this.mAllocationTable.setRedraw(true);
        this.mAllocationViewer.refresh();
    }

    private AllocationInfo[] getFilteredAllocations(AllocationInfo[] allocations, String filterText) {
        ArrayList<AllocationInfo> results = new ArrayList<AllocationInfo>();
        Locale locale = Locale.getDefault();
        filterText = filterText.toLowerCase(locale);
        boolean fullTrace = this.mTraceFilterCheck.getSelection();
        for (AllocationInfo info : allocations) {
            if (!info.filter(filterText, fullTrace, locale)) continue;
            results.add(info);
        }
        return results.toArray(new AllocationInfo[results.size()]);
    }

    private static class AllocationLabelProvider
    implements ITableLabelProvider {
        private AllocationLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof AllocationInfo) {
                AllocationInfo alloc = (AllocationInfo)element;
                switch (columnIndex) {
                    case 0: {
                        return Integer.toString(alloc.getAllocNumber());
                    }
                    case 1: {
                        return Integer.toString(alloc.getSize());
                    }
                    case 2: {
                        return alloc.getAllocatedClass();
                    }
                    case 3: {
                        return Short.toString(alloc.getThreadId());
                    }
                    case 4: {
                        return alloc.getFirstTraceClassName();
                    }
                    case 5: {
                        return alloc.getFirstTraceMethodName();
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class AllocationContentProvider
    implements IStructuredContentProvider {
        private AllocationContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] allocs;
            if (inputElement instanceof Client && (allocs = ((Client)inputElement).getClientData().getAllocations()) != null) {
                if (AllocationPanel.this.mFilterText != null && AllocationPanel.this.mFilterText.length() > 0) {
                    allocs = AllocationPanel.this.getFilteredAllocations((AllocationInfo[])allocs, AllocationPanel.this.mFilterText);
                }
                Arrays.sort(allocs, AllocationPanel.this.mSorter);
                return allocs;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

