/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.refactoring;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.ui.internal.refactoring.RefactoringMessages;

public class CreateFileChange
extends ResourceChange {
    private String fChangeName;
    private IPath fPath;
    private String fSource;
    private String fEncoding;
    private boolean fExplicitEncoding;
    private long fStampToRestore;

    public CreateFileChange(IPath path, String source, String encoding) {
        this(path, source, encoding, -1L);
    }

    public CreateFileChange(IPath path, String source, String encoding, long stampToRestore) {
        Assert.isNotNull((Object)path, (String)"path");
        Assert.isNotNull((Object)source, (String)"source");
        this.fPath = path;
        this.fSource = source;
        this.fEncoding = encoding;
        this.fExplicitEncoding = this.fEncoding != null;
        this.fStampToRestore = stampToRestore;
    }

    protected void setEncoding(String encoding, boolean explicit) {
        Assert.isNotNull((Object)encoding, (String)"encoding");
        this.fEncoding = encoding;
        this.fExplicitEncoding = explicit;
    }

    public String getName() {
        if (this.fChangeName == null) {
            return NLS.bind((String)RefactoringMessages.CreateFileChange_0, (Object)this.fPath);
        }
        return this.fChangeName;
    }

    public void setName(String name) {
        this.fChangeName = name;
    }

    protected void setSource(String source) {
        this.fSource = source;
    }

    protected String getSource() {
        return this.fSource;
    }

    protected void setPath(IPath path) {
        this.fPath = path;
    }

    protected IPath getPath() {
        return this.fPath;
    }

    protected IResource getModifiedResource() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
        URI location = file.getLocationURI();
        if (location == null) {
            result.addFatalError(NLS.bind((String)RefactoringMessages.CreateFileChange_1, (Object)file.getFullPath()));
            return result;
        }
        IFileInfo jFile = EFS.getStore((URI)location).fetchInfo();
        if (jFile.exists()) {
            result.addFatalError(NLS.bind((String)RefactoringMessages.CreateFileChange_2, (Object)file.getFullPath()));
            return result;
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        InputStream is = null;
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (String)RefactoringMessages.CreateFileChange_3, (int)3);
            this.initializeEncoding();
            IFile file = this.getOldFile((IProgressMonitor)subMonitor.split(1));
            try {
                is = new ByteArrayInputStream(this.fSource.getBytes(this.fEncoding));
                file.create(is, false, (IProgressMonitor)subMonitor.split(1));
                if (this.fStampToRestore != -1L) {
                    file.revertModificationStamp(this.fStampToRestore);
                }
                if (this.fExplicitEncoding) {
                    file.setCharset(this.fEncoding, (IProgressMonitor)subMonitor.split(1));
                } else {
                    subMonitor.worked(1);
                }
                DeleteResourceChange deleteResourceChange = new DeleteResourceChange(file.getFullPath(), true);
                return deleteResourceChange;
            }
            catch (UnsupportedEncodingException e) {
                throw new JavaModelException((Throwable)e, 985);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                throw new JavaModelException((Throwable)ioe, 985);
            }
        }
    }

    protected IFile getOldFile(IProgressMonitor pm) throws OperationCanceledException {
        SubMonitor.convert((IProgressMonitor)pm, (int)1);
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }

    private void initializeEncoding() {
        if (this.fEncoding == null) {
            this.fExplicitEncoding = false;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            if (file != null) {
                try {
                    if (file.exists()) {
                        this.fEncoding = file.getCharset(false);
                        if (this.fEncoding == null) {
                            this.fEncoding = file.getCharset(true);
                        } else {
                            this.fExplicitEncoding = true;
                        }
                    } else {
                        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
                        if (contentType != null) {
                            this.fEncoding = contentType.getDefaultCharset();
                        }
                        if (this.fEncoding == null) {
                            this.fEncoding = file.getCharset(true);
                        }
                    }
                }
                catch (CoreException coreException) {
                    this.fEncoding = ResourcesPlugin.getEncoding();
                    this.fExplicitEncoding = true;
                }
            } else {
                this.fEncoding = ResourcesPlugin.getEncoding();
                this.fExplicitEncoding = true;
            }
        }
        Assert.isNotNull((Object)this.fEncoding);
    }
}

