/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui.wizards;

import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.Field;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddTableFieldDialog
extends Dialog {
    private Field field;
    private Text nameText;
    private Combo typeCombo;
    private Text defaultText;
    private Button isPrimaryButton;
    private Composite primaryKeyOptions;
    private Button noneButton;
    private Button incrementalButton;
    private Button decrementalButton;
    private Label primaryKeyBehavior;

    public AddTableFieldDialog(Shell parentShell) {
        super(parentShell);
    }

    public AddTableFieldDialog(Shell parentShell, Field newField) {
        super(parentShell);
        this.field = newField;
    }

    public Control createDialogArea(Composite parent) {
        this.getShell().setText(DbCoreNLS.CreateTableWizardPage_AddEditField_DialogTitle);
        Composite composite = new Composite(parent, 4);
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)layoutData);
        layoutData = new GridData(16384, 0x1000000, false, false);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(DbCoreNLS.AddTableFieldDialog_FieldNameLabel);
        nameLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 0x1000000, true, false);
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)layoutData);
        if (this.field != null) {
            this.nameText.setText(this.field.getName());
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddTableFieldDialog.this.getButton(0).setEnabled(AddTableFieldDialog.this.nameText.getText().trim().length() > 0 && !AddTableFieldDialog.this.nameText.getText().trim().contains(" "));
            }
        });
        layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.isPrimaryButton = new Button(composite, 32);
        this.isPrimaryButton.setLayoutData((Object)layoutData);
        this.isPrimaryButton.setText(DbCoreNLS.AddTableFieldDialog_PrimaryKeyLabel);
        if (this.field != null) {
            this.isPrimaryButton.setSelection(this.field.isPrimaryKey());
        }
        this.isPrimaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddTableFieldDialog.this.defaultText.setEnabled(!AddTableFieldDialog.this.isPrimaryButton.getSelection());
                AddTableFieldDialog.this.primaryKeyOptions.setEnabled(AddTableFieldDialog.this.isPrimaryButton.getSelection());
            }
        });
        this.primaryKeyOptions = new Composite(composite, 2048){

            public void setEnabled(boolean enabled) {
                AddTableFieldDialog.this.noneButton.setEnabled(enabled);
                AddTableFieldDialog.this.incrementalButton.setEnabled(enabled);
                AddTableFieldDialog.this.decrementalButton.setEnabled(enabled);
                AddTableFieldDialog.this.primaryKeyBehavior.setEnabled(enabled);
                super.setEnabled(enabled);
            }
        };
        layoutData = new GridData(4, 4, true, true, 2, 1);
        this.primaryKeyOptions.setLayout((Layout)new GridLayout(1, false));
        this.primaryKeyOptions.setLayoutData((Object)layoutData);
        this.primaryKeyBehavior = new Label(this.primaryKeyOptions, 0);
        this.primaryKeyBehavior.setLayoutData((Object)layoutData);
        this.primaryKeyBehavior.setText(DbCoreNLS.AddTableFieldDialog_PrimaryKeyAutomaticBehaviourLabel);
        layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.noneButton = new Button(this.primaryKeyOptions, 16);
        this.noneButton.setLayoutData((Object)layoutData);
        this.noneButton.setText(DbCoreNLS.AddTableFieldDialog_PrimaryKeyAutomaticBehaviour_NoneLabel);
        this.incrementalButton = new Button(this.primaryKeyOptions, 16);
        this.incrementalButton.setLayoutData((Object)layoutData);
        this.incrementalButton.setText(DbCoreNLS.AddTableFieldDialog_PrimaryKeyAutomaticBehaviour_IncrementalLabel);
        this.decrementalButton = new Button(this.primaryKeyOptions, 16);
        this.decrementalButton.setLayoutData((Object)layoutData);
        this.decrementalButton.setText(DbCoreNLS.AddTableFieldDialog_PrimaryKeyAutomaticBehaviour_DecrementalLabel);
        Boolean isNew = this.field != null && this.field.isPrimaryKey();
        if (isNew.booleanValue()) {
            this.noneButton.setSelection(this.field.getAutoIncrementType() == Field.AutoIncrementType.NONE);
            this.incrementalButton.setSelection(this.field.getAutoIncrementType() == Field.AutoIncrementType.ASCENDING);
            this.decrementalButton.setSelection(this.field.getAutoIncrementType() == Field.AutoIncrementType.DESCENDING);
        } else {
            this.noneButton.setSelection(true);
        }
        this.primaryKeyOptions.setEnabled(isNew.booleanValue());
        layoutData = new GridData(16384, 0x1000000, false, false);
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText(DbCoreNLS.AddTableFieldDialog_FieldTypeLabel);
        typeLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 0x1000000, true, false);
        this.typeCombo = new Combo(composite, 8);
        this.typeCombo.setLayoutData((Object)layoutData);
        int integerTypeIndex = 0;
        Field.DataType[] dataTypeArray = Field.DataType.values();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field.DataType type = dataTypeArray[n2];
            this.typeCombo.add(type.toString());
            if (type.equals((Object)Field.DataType.INTEGER)) {
                integerTypeIndex = this.typeCombo.getItemCount() - 1;
            }
            ++n2;
        }
        this.typeCombo.select(integerTypeIndex);
        if (this.field != null) {
            this.typeCombo.select(this.typeCombo.indexOf(this.field.getType().toString()));
        }
        layoutData = new GridData(16384, 0x1000000, false, false);
        Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText(DbCoreNLS.AddTableFieldDialog_FieldDefaultValueLabel);
        defaultLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 0x1000000, true, false);
        this.defaultText = new Text(composite, 2048);
        this.defaultText.setLayoutData((Object)layoutData);
        if (this.field != null) {
            this.defaultText.setText(this.field.getDefaultValue());
        }
        if (this.field != null) {
            this.defaultText.setEnabled(!this.field.isPrimaryKey());
            this.primaryKeyOptions.setEnabled(this.field.isPrimaryKey());
        }
        composite.layout();
        return composite;
    }

    protected void okPressed() {
        if (this.field == null) {
            this.field = new Field();
        }
        this.field.setName(this.nameText.getText());
        this.field.setPrimaryKey(this.isPrimaryButton.getSelection());
        this.field.setDefaultValue(this.defaultText.getText().trim());
        this.field.setType(Field.DataType.valueOf(this.typeCombo.getItem(this.typeCombo.getSelectionIndex())));
        if (this.noneButton.getSelection()) {
            this.field.setAutoIncrementType(Field.AutoIncrementType.NONE);
        } else if (this.incrementalButton.getSelection()) {
            this.field.setAutoIncrementType(Field.AutoIncrementType.ASCENDING);
        } else if (this.decrementalButton.getSelection()) {
            this.field.setAutoIncrementType(Field.AutoIncrementType.DESCENDING);
        }
        super.okPressed();
    }

    public Field getField() {
        return this.field;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        button.setEnabled(id != 0 || this.field != null);
        return button;
    }
}

