/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui.tree;

import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class DatabaseExplorerTreeLabelProvider
extends CellLabelProvider {
    final IDecoratorManager decorator = PlatformUI.getWorkbench().getDecoratorManager();

    public void addListener(ILabelProviderListener listener) {
        this.decorator.addListener(listener);
        super.addListener(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.decorator.removeListener(listener);
        super.removeListener(listener);
    }

    public Image getImage(Object element) {
        ITreeNode treeNode;
        Image defaultImage;
        Image result = null;
        if (element instanceof AbstractTreeNode && (result = this.decorator.decorateImage(defaultImage = (treeNode = (ITreeNode)element).getIcon().createImage(), element)) == null) {
            result = defaultImage;
        }
        return result;
    }

    public String getText(Object element) {
        if (element instanceof AbstractTreeNode) {
            ITreeNode treeNode = (ITreeNode)element;
            return treeNode.getName();
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        boolean isLabelProperty = false;
        LabelProperty labelProperty = LabelProperty.valueOf(property);
        if (labelProperty != null) {
            isLabelProperty = true;
        }
        return isLabelProperty;
    }

    public String getToolTipText(Object element) {
        if (element instanceof ITreeNode) {
            String statusMessage;
            ITreeNode treeNode = (ITreeNode)element;
            String tooltipText = treeNode.getTooltip();
            IStatus nodeStatus = treeNode.getNodeStatus();
            if (nodeStatus != null && !nodeStatus.isOK() && (statusMessage = nodeStatus.getMessage()) != null && !statusMessage.isEmpty()) {
                tooltipText = NLS.bind((String)DbCoreNLS.DatabaseExplorerTreeLabelProvider_Error_Tooltip_Prefix, (Object)statusMessage);
            }
            return tooltipText;
        }
        return super.getToolTipText(element);
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 4000;
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 500;
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public void update(ViewerCell cell) {
        Object cellElement = cell.getElement();
        cell.setText(this.getText(cellElement));
        cell.setImage(this.getImage(cellElement));
    }

    public static enum LabelProperty {
        TEXT,
        IMAGE;

    }
}

