/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui.tree;

import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.LoadingNode;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class DatabaseExplorerTreeContentProvider
implements ILazyTreeContentProvider {
    private final TreeViewer treeViewer;

    public DatabaseExplorerTreeContentProvider(TreeViewer viewer) {
        this.treeViewer = viewer;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object getParent(Object element) {
        if (element instanceof AbstractTreeNode) {
            ITreeNode treeNode = (ITreeNode)element;
            return treeNode.getParent();
        }
        return null;
    }

    public void updateElement(Object parent, int index) {
        if (parent instanceof ITreeNode) {
            ITreeNode parentTreeNode = (ITreeNode)parent;
            ITreeNode child = null;
            child = index == 0 && parentTreeNode.isLoading() ? new LoadingNode(parentTreeNode) : parentTreeNode.getChild(index);
            if (child != null) {
                this.treeViewer.replace(parent, index, (Object)child);
                if (!child.isLeaf()) {
                    this.treeViewer.setHasChildren((Object)child, true);
                }
            }
        }
    }

    public void updateChildCount(Object element, int currentChildCount) {
        if (element instanceof AbstractTreeNode) {
            ITreeNode treeNode = (ITreeNode)element;
            treeNode.refreshAsync();
            int childCount = 0;
            childCount = treeNode.isLoading() ? 1 : treeNode.getChildren().size();
            if (childCount != currentChildCount) {
                this.treeViewer.setChildCount(element, childCount);
            }
        }
    }
}

