/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui.action;

import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.db.core.command.BrowseTableContentsHandler;
import org.eclipse.andmore.android.db.core.command.CreateDatabaseManagementClassesHandler;
import org.eclipse.andmore.android.db.core.command.DbConnectHandler;
import org.eclipse.andmore.android.db.core.command.DbCreateHandler;
import org.eclipse.andmore.android.db.core.command.DbDisconnectHandler;
import org.eclipse.andmore.android.db.core.command.DeleteDatabaseHandler;
import org.eclipse.andmore.android.db.core.command.DeleteTableHandler;
import org.eclipse.andmore.android.db.core.command.ExtractDataHandler;
import org.eclipse.andmore.android.db.core.command.LoadDataHandler;
import org.eclipse.andmore.android.db.core.command.MapDatabaseHandler;
import org.eclipse.andmore.android.db.core.command.RefreshNodeHandler;
import org.eclipse.andmore.android.db.core.command.SampleContentsHandler;
import org.eclipse.andmore.android.db.core.command.TableCreateHandler;
import org.eclipse.andmore.android.db.core.command.UnmapDatabaseHandler;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.IDataSampler;
import org.eclipse.andmore.android.db.core.ui.IDbMapperNode;
import org.eclipse.andmore.android.db.core.ui.IDbNode;
import org.eclipse.andmore.android.db.core.ui.ITableNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.TableNode;
import org.eclipse.andmore.android.db.core.ui.action.IDbCreatorNode;
import org.eclipse.andmore.android.db.core.ui.action.ITableCreatorNode;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class PopupMenuActionDelegate
implements IObjectActionDelegate {
    private ITreeNode currentNode;

    public void run(IAction action) {
        ActionHandlers type = ActionHandlers.getActionHandlerbyId(action.getId());
        IHandler handler = null;
        if (type != null) {
            handler = type.getHandler(this.currentNode);
        }
        if (handler != null) {
            ExecutionEvent event = new ExecutionEvent();
            try {
                handler.execute(event);
            }
            catch (ExecutionException executionException) {
                AndmoreLogger.debug((String)"Could not execute popupHandler");
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object selectedObject;
        if (selection instanceof IStructuredSelection && (selectedObject = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof AbstractTreeNode) {
            this.currentNode = (ITreeNode)selectedObject;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    static enum ActionHandlers {
        CREATE_DB("org.eclipse.andmore.android.db.core.ui.action.createDbAction"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new DbCreateHandler((IDbCreatorNode)node);
            }
        }
        ,
        CREATE_TABLE("org.eclipse.andmore.android.db.core.ui.action.createTableAction"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new TableCreateHandler((ITableCreatorNode)node);
            }
        }
        ,
        CONNECT("org.eclipse.andmore.android.db.core.ui.action.connect"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new DbConnectHandler((IDbNode)node);
            }
        }
        ,
        DISCONNECT("org.eclipse.andmore.android.db.core.ui.action.disconnect"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new DbDisconnectHandler((IDbNode)node);
            }
        }
        ,
        REFRESH_PROJECT("org.eclipse.andmore.android.db.core.ui.action.refreshProjectNode"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new RefreshNodeHandler(node);
            }
        }
        ,
        REFRESH_WORKSPACE("org.eclipse.andmore.android.db.core.ui.action.refreshWorkspaceNode"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new RefreshNodeHandler(node);
            }
        }
        ,
        REFRESH_FILESYSTEM("org.eclipse.andmore.android.db.core.ui.action.refreshFileSystemNode"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new RefreshNodeHandler(node);
            }
        }
        ,
        REFRESH_DB("org.eclipse.andmore.android.db.core.ui.action.refreshDbNode"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new RefreshNodeHandler(node);
            }
        }
        ,
        REFRESH_TABLE("org.eclipse.andmore.android.db.core.ui.action.refreshTableNode"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new RefreshNodeHandler(node);
            }
        }
        ,
        REFRESH_DB_MAPPER_NODE("org.eclipse.andmore.android.db.core.ui.action.refreshDbMapperNode"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new RefreshNodeHandler(node);
            }
        }
        ,
        DELETE_TABLE("org.eclipse.andmore.android.db.core.ui.action.deleteTable"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new DeleteTableHandler(node);
            }
        }
        ,
        DELETE_DATABASE("org.eclipse.andmore.android.db.core.ui.action.deleteDatabase"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new DeleteDatabaseHandler(node);
            }
        }
        ,
        BROWSE_TABLE_CONTENTS("org.eclipse.andmore.android.db.core.ui.action.browseTableContents"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new BrowseTableContentsHandler((TableNode)node);
            }
        }
        ,
        CREATE_DB_MANAGEMENT_CLASSES("org.eclipse.andmore.android.db.core.ui.action.createDatabaseManagementClasses"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new CreateDatabaseManagementClassesHandler((IDbNode)node);
            }
        }
        ,
        MAP_DATABASE("org.eclipse.andmore.android.db.core.ui.action.mapDbNode"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new MapDatabaseHandler((IDbMapperNode)node);
            }
        }
        ,
        UNMAP_DATABASE("org.eclipse.andmore.android.db.core.ui.action.unmapDbNode"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new UnmapDatabaseHandler((IDbMapperNode)node);
            }
        }
        ,
        SAMPLE_CONTENTS("org.eclipse.andmore.android.db.core.ui.action.sampleContents"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new SampleContentsHandler((IDataSampler)node);
            }
        }
        ,
        EXTRACT_DATA("org.eclipse.andmore.android.db.core.ui.action.extractData"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new ExtractDataHandler((ITableNode)node);
            }
        }
        ,
        LOAD_DATA("org.eclipse.andmore.android.db.core.ui.action.loadData"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new LoadDataHandler((ITableNode)node);
            }
        };

        private final String actionId;

        private ActionHandlers(String actionId) {
            this.actionId = actionId;
        }

        public abstract IHandler getHandler(ITreeNode var1);

        public static ActionHandlers getActionHandlerbyId(String id) {
            ActionHandlers ret = null;
            ActionHandlers[] actionHandlersArray = ActionHandlers.values();
            int n = actionHandlersArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionHandlers h = actionHandlersArray[n2];
                if (h.actionId.equals(id)) {
                    ret = h;
                    break;
                }
                ++n2;
            }
            return ret;
        }
    }
}

