/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.model;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.Field;

public class TableModel {
    private String name = "SampleTable";
    private List<Field> fields;

    public TableModel() {
        this.fields = new LinkedList<Field>();
    }

    public TableModel(String name, List<Field> fields) {
        this.name = name;
        this.fields = fields;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public void removeField(Field field) {
        this.fields.remove(field);
    }

    public static boolean validateName(String name) {
        String[] keywords;
        boolean isValid = true;
        String[] stringArray = keywords = new String[]{"ABORT", "ACTION", "ADD", "AFTER", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ATTACH", "AUTOINCREMENT", "BEFORE", "BEGIN", "BETWEEN", "BY", "CASCADE", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "COMMIT", "CONFLICT", "CONSTRAINT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATABASE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DETACH", "DISTINCT", "DROP", "EACH", "ELSE", "END", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXISTS", "EXPLAIN", "FAIL", "FOR", "FOREIGN", "FROM", "FULL", "GLOB", "GROUP", "HAVING", "IF", "IGNORE", "IMMEDIATE", "IN", "INDEX", "INDEXED", "INITIALLY", "INNER", "INSERT", "INSTEAD", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "KEY", "LEFT", "LIKE", "LIMIT", "MATCH", "NATURAL", "NO", "NOT", "NOTNULL", "NULL", "OF", "OFFSET", "ON", "OR", "ORDER", "OUTER", "PLAN", "PRAGMA", "PRIMARY", "QUERY", "RAISE", "REFERENCES", "REGEXP", "REINDEX", "RELEASE", "RENAME", "REPLACE", "RESTRICT", "RIGHT", "ROLLBACK", "ROW", "SAVEPOINT", "SELECT", "SET", "TABLE", "TEMP", "TEMPORARY", "THEN", "TO", "TRANSACTION", "TRIGGER", "UNION", "UNIQUE", "UPDATE", "USING", "VACUUM", "VALUES", "VIEW", "VIRTUAL", "WHEN", "WHERE"};
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (keyword.toLowerCase().compareTo(name.toLowerCase()) == 0) {
                isValid = false;
            }
            ++n2;
        }
        return isValid;
    }

    public String getErrorMessage() {
        Iterator<Field> it = this.fields.iterator();
        String msg = null;
        while (it.hasNext() && msg == null) {
            Field field = it.next();
            msg = field.getErrorMessage();
            if (msg == null && field.getName().trim().contains(" ")) {
                msg = DbCoreNLS.Table_ErrorUnamedColumns;
                continue;
            }
            if (msg != null) continue;
            Iterator<Field> iterator = this.fields.iterator();
            while (iterator.hasNext() && msg == null) {
                Field testField = iterator.next();
                if (field == testField) continue;
                if (field.getName().equalsIgnoreCase(testField.getName())) {
                    msg = String.valueOf(DbCoreNLS.Table_ErrorConflictingNames) + field.getName() + ", " + testField.getName();
                    continue;
                }
                if (!field.isPrimaryKey() || !testField.isPrimaryKey()) continue;
                msg = String.valueOf(DbCoreNLS.Table_ErrorMoreThanOnePrimaryKey) + field.getName() + ", " + testField.getName();
            }
        }
        return msg;
    }
}

