/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.andmore.android.common.CommonPlugin;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.db.core.DbCoreActivator;
import org.eclipse.andmore.android.db.core.exception.AndmoreDbException;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.Field;
import org.eclipse.andmore.android.db.core.model.TableModel;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataEditor;
import org.eclipse.datatools.sqltools.internal.refresh.ICatalogObject2;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;

public class DbModel {
    static final String JDBC_DRIVER_INSTANCE_NAME = "andmore_jdbc_driver";
    public static final String DBNAME_PROPERTY = "org.eclipse.datatools.connectivity.db.databaseName";
    public static final String PROVIDER_ID = "org.eclipse.datatools.enablement.sqlite.connectionProfile";
    public static final String URL_PROPERTY = "org.eclipse.datatools.connectivity.db.URL";
    public static final String JDBC_SQLITE_PREFIX = "jdbc:sqlite:";
    public static final String LOCALPATH_PROPERTY = "org.eclipse.andmore.db.localPathProperty";
    private final IConnectionProfile connProfile;
    private final IPath dbPath;

    public DbModel(IPath dbPath) throws AndmoreDbException {
        this(dbPath, false);
    }

    public DbModel(IPath dbPath, boolean create) throws AndmoreDbException {
        this(dbPath, create, false);
    }

    public DbModel(IPath dbPath, boolean create, boolean overwrite) throws AndmoreDbException {
        if (create) {
            File dbFile = dbPath.toFile();
            try {
                DbCoreActivator.getDefault().copyTemplateDbFile(dbFile, overwrite);
            }
            catch (IOException e) {
                throw new AndmoreDbException(e);
            }
        }
        this.dbPath = dbPath;
        if (!DbModel.isValidSQLiteDatabase(dbPath.toFile())) {
            throw new AndmoreDbException(NLS.bind((String)DbCoreNLS.DbModel_Not_Valid_Database, (Object)dbPath.toOSString()));
        }
        this.connProfile = this.getProfile(dbPath);
    }

    public static void assertDriverExistsAtModel() {
        DriverManager driverMan = DriverManager.getInstance();
        String allDrivers = driverMan.getFullJarList();
        String driverPath = DbModel.getDriverPath();
        if (allDrivers == null || !allDrivers.contains(driverPath)) {
            String templateId = "org.eclipse.datatools.enablement.sqlite.3_5_9.driver";
            driverMan.createNewDriverInstance(templateId, JDBC_DRIVER_INSTANCE_NAME, driverPath);
            AndmoreLogger.info((String)"Created a JDBC driver instance at Data Tools.");
        }
    }

    public static void deleteDriverFromModel() {
        DriverManager driverMan = DriverManager.getInstance();
        String jarList = driverMan.getFullJarList();
        if (jarList != null && jarList.contains(JDBC_DRIVER_INSTANCE_NAME)) {
            driverMan.removeDriverInstance(JDBC_DRIVER_INSTANCE_NAME);
            AndmoreLogger.info((String)"Removed the JDBC driver instance from Data Tools.");
        }
    }

    private IConnectionProfile getProfile(IPath dbPath) throws AndmoreDbException {
        String fullPath = dbPath.toOSString();
        IConnectionProfile profile = null;
        profile = ProfileManager.getInstance().getProfileByFullPath(fullPath);
        if (profile == null) {
            Properties prop = DbModel.getBaseConnProperties(DbModel.getDriverPath(), dbPath.lastSegment(), dbPath.toOSString());
            try {
                profile = ProfileManager.getInstance().createProfile(fullPath, "", PROVIDER_ID, prop);
                profile.setBaseProperties(prop);
            }
            catch (ConnectionProfileException connectionProfileException) {
                throw new AndmoreDbException(NLS.bind((String)"Unable to create Profile for db {0}", (Object)dbPath.toOSString()));
            }
        }
        return profile;
    }

    private static String getDriverPath() {
        String driverPath = null;
        driverPath = CommonPlugin.getDefault().getDriverPath();
        if (driverPath == null) {
            driverPath = "";
        }
        return driverPath;
    }

    public static Properties getBaseConnProperties(String driverPath, String dbName, String dbPath) {
        Properties prop = new Properties();
        prop.put("org.eclipse.datatools.connectivity.db.vendor", "SQLITE");
        prop.put("org.eclipse.datatools.connectivity.db.password", "");
        prop.put("org.eclipse.datatools.connectivity.driverDefinitionID", "DriverDefn.org.eclipse.datatools.enablement.sqlite.3_5_9.driver.andmore_jdbc_driver");
        prop.put("org.eclipse.datatools.connectivity.drivers.defnType", "org.eclipse.datatools.enablement.sqlite.3_5_9.driver");
        prop.put("org.eclipse.datatools.connectivity.db.savePWD", "false");
        prop.put("org.eclipse.datatools.connectivity.db.connectionProperties", "");
        prop.put("org.eclipse.datatools.connectivity.db.version", "3.5.9");
        prop.put(DBNAME_PROPERTY, dbName);
        prop.put("jarList", driverPath);
        prop.put("org.eclipse.datatools.connectivity.db.username", "");
        prop.put("org.eclipse.datatools.connectivity.db.driverClass", "org.sqlite.JDBC");
        prop.put(URL_PROPERTY, JDBC_SQLITE_PREFIX + dbPath);
        prop.put(LOCALPATH_PROPERTY, dbPath);
        return prop;
    }

    public IStatus connect() {
        IPath dbPath = this.getDbPath();
        File file = dbPath.toFile();
        if (file.exists() && DbModel.isValidSQLiteDatabase(file)) {
            return this.connProfile.connect();
        }
        return new Status(4, "org.eclipse.andmore.android.db.core", NLS.bind((String)DbCoreNLS.Invalid_Db_Error, (Object)dbPath));
    }

    public IStatus disconnect() {
        return this.connProfile.disconnect();
    }

    public IStatus createTable(TableModel table) {
        StringBuilder strBuilder = new StringBuilder("CREATE TABLE ");
        strBuilder.append(table.getName());
        strBuilder.append("(");
        List<Field> fields = table.getFields();
        boolean firstField = true;
        for (Field field : fields) {
            if (firstField) {
                firstField = false;
            } else {
                strBuilder.append(", ");
            }
            strBuilder.append(field.getName());
            strBuilder.append(" ");
            strBuilder.append(field.getType().toString());
            if (field.isPrimaryKey()) {
                strBuilder.append(" PRIMARY KEY");
                if (field.getAutoIncrementType() != Field.AutoIncrementType.NONE) {
                    strBuilder.append(" ");
                    strBuilder.append(field.getAutoIncrementType().toString());
                }
            }
            if (field.getDefaultValue() == null || field.getDefaultValue().equals("")) continue;
            strBuilder.append(" default '");
            strBuilder.append(field.getDefaultValue());
            strBuilder.append("'");
        }
        strBuilder.append(")");
        return this.executeSingleStatement(strBuilder.toString());
    }

    public IStatus deleteTable(String tableName) {
        return this.executeSingleStatement("DROP TABLE " + tableName);
    }

    public Table getTable(String tableName) {
        List<Table> tables = this.getTables();
        Table table = null;
        for (Table t : tables) {
            if (!t.getName().toUpperCase().equals(tableName.toUpperCase())) continue;
            table = t;
            break;
        }
        return table;
    }

    public List<Table> getTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        ConnectionInfo connectionInfo = this.getConnectionInfo();
        if (connectionInfo != null) {
            Database database = connectionInfo.getSharedDatabase();
            connectionInfo = DatabaseConnectionRegistry.getConnectionForDatabase((Database)database);
            EList catalogs = database.getCatalogs();
            for (Catalog catalog : catalogs) {
                EList schemas = catalog.getSchemas();
                schemas.addAll((Collection)database.getSchemas());
                for (Schema schema : schemas) {
                    if (schema instanceof ICatalogObject2) {
                        String context = ((ICatalogObject2)schema).getRefreshContext((Object)new Integer(10));
                        ((ICatalogObject2)schema).refresh(context);
                    } else {
                        ((ICatalogObject)schema).refresh();
                    }
                    EList schemaTables = schema.getTables();
                    tables.addAll((Collection<Table>)schemaTables);
                }
            }
        }
        return tables;
    }

    public IStatus deleteDb() {
        IStatus status = Status.OK_STATUS;
        if (this.connProfile.getConnectionState() != 0) {
            this.disconnect();
        }
        try {
            this.cleanModel();
            boolean deleteSuccesfull = this.dbPath.toFile().delete();
            if (!deleteSuccesfull) {
                status = new Status(4, "org.eclipse.andmore.android.db.core", NLS.bind((String)DbCoreNLS.DbModel_Could_Not_Delete_DbFile, (Object)this.dbPath.toOSString()));
            }
        }
        catch (ConnectionProfileException e) {
            status = new Status(4, "org.eclipse.andmore.android.db.core", NLS.bind((String)DbCoreNLS.DbModel_Could_Not_Disconnect_Profile, (Object)this.connProfile.getName()), (Throwable)e);
        }
        return status;
    }

    public void cleanModel() throws ConnectionProfileException {
        this.disconnect();
        ProfileManager.getInstance().deleteProfile(this.connProfile);
    }

    public static boolean isValidSQLiteDatabase(File databaseFile) {
        byte[] fileByteArray;
        byte[] headerByteArray;
        boolean result;
        block24: {
            result = true;
            headerByteArray = new byte[]{83, 81, 76, 105, 116, 101, 32, 102, 111, 114, 109, 97, 116, 32, 51, 0};
            fileByteArray = new byte[16];
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(databaseFile);
                    fis.read(fileByteArray);
                }
                catch (Exception exception) {
                    result = false;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(fileByteArray);
            int aux = 0;
            while (aux < 16) {
                int myByte = bais.read();
                if (myByte != headerByteArray[aux]) {
                    result = false;
                }
                ++aux;
            }
        }
        catch (Throwable throwable) {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bais != null) {
            try {
                bais.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private ConnectionInfo getConnectionInfo() {
        if (!this.isConnected()) {
            this.connProfile.connect();
        }
        IManagedConnection managedConnection = this.connProfile.getManagedConnection(ConnectionInfo.class.getName());
        ConnectionInfo connectionInfo = null;
        if (managedConnection != null) {
            connectionInfo = (ConnectionInfo)managedConnection.getConnection().getRawConnection();
        }
        return connectionInfo;
    }

    public boolean isConnected() {
        return this.connProfile.getConnectionState() == 1;
    }

    private IStatus executeSingleStatement(String statement) {
        IStatus status = Status.OK_STATUS;
        Connection connection = this.getManagedSqlConnection();
        try {
            Statement sqlStatement = connection.createStatement();
            sqlStatement.execute(statement);
        }
        catch (Exception e) {
            status = new Status(4, "org.eclipse.andmore.android.db.core", NLS.bind((String)DbCoreNLS.DbModel_Could_Not_Execute_Statement, (Object)statement), (Throwable)e);
        }
        return status;
    }

    private Connection getManagedSqlConnection() {
        if (!this.isConnected()) {
            this.connProfile.connect();
        }
        IManagedConnection managedConnection = this.connProfile.getManagedConnection(Connection.class.getName());
        Connection connection = (Connection)managedConnection.getConnection().getRawConnection();
        return connection;
    }

    public IPath getDbPath() {
        return this.dbPath;
    }

    public String getProfileName() {
        return this.connProfile.getName();
    }

    public Set<IEditorPart> getAssociatedEditors() {
        Collection allEditors = EclipseUtils.getAllOpenedEditors();
        HashSet<IEditorPart> selectedEditors = new HashSet<IEditorPart>();
        for (IEditorPart e : allEditors) {
            IConnectionProfile editorProfile;
            TableDataEditor tde;
            Table table;
            Catalog cat;
            Database database;
            ConnectionInfo connInfo;
            if (!(e instanceof TableDataEditor) || (connInfo = DatabaseConnectionRegistry.getConnectionForDatabase((Database)(database = (cat = (table = (tde = (TableDataEditor)e).getSqlTable()).getSchema().getCatalog()) != null ? cat.getDatabase() : table.getSchema().getDatabase()))) == null || (editorProfile = ((ConnectionInfoImpl)connInfo).getConnectionProfile()) != this.connProfile) continue;
            selectedEditors.add(e);
        }
        return selectedEditors;
    }

    private void sampleContents(Table table, Column column) {
        String tableName = table.getName();
        StringBuilder queryBuilder = new StringBuilder("select ");
        if (column != null) {
            queryBuilder.append(column.getName());
        } else {
            queryBuilder.append("*");
        }
        queryBuilder.append(" from ");
        queryBuilder.append(tableName);
        String queryString = queryBuilder.toString();
        this.executeSingleStatement(queryString);
        String cosummerName = null;
        String dbName = null;
        OperationCommand cmd = new OperationCommand(1, queryString, cosummerName, this.connProfile.getName(), dbName);
        ResultsViewAPI resultsView = ResultsViewAPI.getInstance();
        resultsView.createNewInstance(cmd, null);
        resultsView.appendStatusMessage(cmd, String.valueOf(DbCoreNLS.DbModel_Sampling_Contents_From) + tableName);
        Connection managedSqlConnection = this.getManagedSqlConnection();
        try {
            Statement statement = managedSqlConnection.createStatement();
            ResultSet resultSet = statement.executeQuery(queryString);
            resultsView.appendResultSet(cmd, resultSet);
            resultsView.updateStatus(cmd, 3);
        }
        catch (SQLException e) {
            resultsView.appendThrowable(cmd, (Throwable)e);
            resultsView.updateStatus(cmd, 6);
        }
    }

    public void sampleContents(Table table) {
        this.sampleContents(table, null);
    }

    public void sampleContents(Column column) {
        this.sampleContents(column.getTable(), column);
    }

    public static void cleanPreviousProfiles() {
        IConnectionProfile[] profiles;
        ProfileManager profileManager = ProfileManager.getInstance();
        IConnectionProfile[] iConnectionProfileArray = profiles = profileManager.getProfiles();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile profile = iConnectionProfileArray[n2];
            try {
                profileManager.deleteProfile(profile);
            }
            catch (ConnectionProfileException e) {
                AndmoreLogger.error(DbModel.class, (String)"Could not delete all profiles", (Throwable)e);
            }
            ++n2;
        }
    }
}

