/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.command;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.andmore.android.db.core.DbCoreActivator;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.TableModel;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.action.ITableCreatorNode;
import org.eclipse.andmore.android.db.core.ui.wizards.CreateTableWizard;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TableCreateHandler
extends AbstractHandler {
    private ITableCreatorNode tableCreatorNode = null;

    public TableCreateHandler() {
    }

    public TableCreateHandler(ITableCreatorNode tableCreatorNode) {
        this.tableCreatorNode = tableCreatorNode;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.tableCreatorNode == null) {
            this.tableCreatorNode = this.getSelectedItem();
        }
        if (this.tableCreatorNode != null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean tableAdded = false;
            while (!tableAdded) {
                CreateTableWizard createTableWizard = new CreateTableWizard();
                Set<String> notAllowedNames = this.getNotAllowedNames(this.tableCreatorNode.getTables());
                createTableWizard.setNotAllowedNames(notAllowedNames);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)createTableWizard);
                dialog.open();
                if (dialog.getReturnCode() != 0) break;
                TableModel newTable = createTableWizard.getTable();
                if (newTable == null) continue;
                boolean tableNameAlreadyExists = false;
                for (Table table : this.tableCreatorNode.getTables()) {
                    if (!table.getName().equalsIgnoreCase(newTable.getName())) continue;
                    tableNameAlreadyExists = true;
                    break;
                }
                if (!tableNameAlreadyExists) {
                    this.tableCreatorNode.createTable(newTable);
                    this.tableCreatorNode = null;
                    tableAdded = true;
                    continue;
                }
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DbCoreNLS.CreateDatabaseWizardPage_Table_Already_Exists_Title, (String)NLS.bind((String)DbCoreNLS.CreateDatabaseWizardPage_Table_Already_Exists_Msg, (Object)newTable.getName()));
            }
        }
        return null;
    }

    private ITableCreatorNode getSelectedItem() {
        ITableCreatorNode selectedNode = null;
        ITreeNode selectedItem = DbCoreActivator.getAndmoreDatabaseExplorerView().getSelectedItemOnTree();
        if (selectedItem instanceof ITableCreatorNode) {
            selectedNode = (ITableCreatorNode)selectedItem;
        }
        return selectedNode;
    }

    private Set<String> getNotAllowedNames(List<Table> list) {
        HashSet<String> names = new HashSet<String>();
        for (Table table : list) {
            names.add(table.getName().toUpperCase());
        }
        return names;
    }
}

