/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.devices.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.DDMSUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DeviceDbUtils {
    private static final String DB_EXTENSION = "db";
    private static final String APPNAME_KEY = "#APP_NAME";
    private static final String remoteDbPathMask = "/data/data/#APP_NAME/databases/";

    public static IPath getRemoteDbFolder(String appName) {
        String remoteDbFolder = remoteDbPathMask.replace(APPNAME_KEY, appName);
        return new Path(remoteDbFolder);
    }

    public static IPath getRemoteDbPath(String appName, String dbFileName) {
        IPath remoteDbFolder = DeviceDbUtils.getRemoteDbFolder(appName);
        IPath remoteDbPath = remoteDbFolder.append(dbFileName);
        String fileExtension = remoteDbPath.getFileExtension();
        if (fileExtension == null || !fileExtension.equals(DB_EXTENSION)) {
            remoteDbPath = remoteDbPath.addFileExtension(DB_EXTENSION);
        }
        return remoteDbPath;
    }

    public static Object[] listInstalledPackages(String serialNumber, boolean filterDBbApplications) throws IOException {
        Object[] returnArray = new Object[2];
        Map allPackages = DDMSUtils.listInstalledPackages((String)serialNumber);
        if (filterDBbApplications) {
            LinkedHashMap<String, String> filteredPackages = new LinkedHashMap<String, String>();
            Collection appDataDirs = DDMSFacade.execRemoteApp((String)serialNumber, (String)"ls /data/data/", (IProgressMonitor)new NullProgressMonitor());
            for (String appPackage : appDataDirs) {
                IPath remoteDbFolder = DeviceDbUtils.getRemoteDbFolder(appPackage);
                Collection databases = DDMSFacade.execRemoteApp((String)serialNumber, (String)("ls " + remoteDbFolder.toString()), (IProgressMonitor)new NullProgressMonitor());
                for (String commandOutline : databases) {
                    String[] strings;
                    String[] stringArray = strings = commandOutline.split(" ");
                    int n = strings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        if (string.trim().endsWith(".db")) {
                            filteredPackages.put(appPackage, (String)allPackages.get(appPackage));
                        }
                        ++n2;
                    }
                }
            }
            returnArray[0] = filteredPackages;
            returnArray[1] = allPackages.size() - filteredPackages.size();
        } else {
            returnArray[0] = allPackages;
            returnArray[1] = 0;
        }
        return returnArray;
    }
}

