/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.devices.ui.action;

import java.io.File;
import java.io.IOException;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.devices.i18n.DbDevicesNLS;
import org.eclipse.andmore.android.db.devices.model.DeviceDbNode;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveDatabaseToFileHandler
extends AbstractHandler
implements IHandler {
    private DeviceDbNode deviceDbNode;

    public SaveDatabaseToFileHandler(ITreeNode node) {
        if (node instanceof DeviceDbNode) {
            this.deviceDbNode = (DeviceDbNode)node;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.deviceDbNode != null) {
            Shell shell = Display.getCurrent().getActiveShell();
            FileDialog dialog = new FileDialog(shell, 8192);
            dialog.setFileName(this.deviceDbNode.getRemoteDbPath().lastSegment());
            dialog.setFilterNames(new String[]{DbDevicesNLS.SaveDatabaseToFile_DbFiles, DbDevicesNLS.SaveDatabaseToFile_AllFiles});
            dialog.setFilterExtensions(new String[]{"*.db", "*.*"});
            String selectedFilePath = dialog.open();
            if (selectedFilePath != null) {
                File targetFile = new File(selectedFilePath);
                IPath temporaryFilePath = this.deviceDbNode.getPath();
                File sourceFile = temporaryFilePath.toFile();
                try {
                    FileUtil.copyFile((File)sourceFile, (File)targetFile);
                }
                catch (IOException e) {
                    throw new ExecutionException(NLS.bind((String)DbDevicesNLS.SaveDatabaseToFile_CopyDatabase_Error, (Object)this.deviceDbNode.getName(), (Object)targetFile), (Throwable)e);
                }
            }
        }
        return null;
    }
}

