/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.devices.ui.action;

import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.db.core.command.RefreshNodeHandler;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.devices.ui.action.FilterDbApplicationHandler;
import org.eclipse.andmore.android.db.devices.ui.action.MapDeviceDatabaseHandler;
import org.eclipse.andmore.android.db.devices.ui.action.SaveDatabaseToFileHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class PopupMenuActionDelegate
implements IObjectActionDelegate {
    private ITreeNode currentNode;

    public void run(IAction action) {
        ActionHandlers type = ActionHandlers.getActionHandlerbyId(action.getId());
        IHandler handler = null;
        if (type != null) {
            handler = type.getHandler(this.currentNode);
        }
        if (handler != null) {
            ExecutionEvent event = new ExecutionEvent();
            try {
                handler.execute(event);
            }
            catch (ExecutionException e) {
                AndmoreLogger.error((String)"Could not execute command: ", (String)e.getMessage());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object selectedObject;
        if (selection instanceof IStructuredSelection && (selectedObject = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof AbstractTreeNode) {
            this.currentNode = (ITreeNode)selectedObject;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    static enum ActionHandlers {
        REFRESH_DEVICE("org.eclipse.andmore.android.db.devices.ui.action.refreshDeviceNode"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new RefreshNodeHandler(node);
            }
        }
        ,
        FILTER_DB_APPNODE("org.eclipse.andmore.android.db.devices.ui.action.filterDbApplicationNode"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new FilterDbApplicationHandler(node);
            }
        }
        ,
        MAP_DEVICE_DB_APPNODE("org.eclipse.andmore.android.db.devices.ui.action.mapDeviceDbNode"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new MapDeviceDatabaseHandler(node);
            }
        }
        ,
        SAVE_TO_LOCAL_FILE("org.eclipse.andmore.android.db.devices.ui.action.saveToLocalFile"){

            @Override
            public IHandler getHandler(ITreeNode node) {
                return new SaveDatabaseToFileHandler(node);
            }
        };

        private final String actionId;

        private ActionHandlers(String actionId) {
            this.actionId = actionId;
        }

        public abstract IHandler getHandler(ITreeNode var1);

        public static ActionHandlers getActionHandlerbyId(String id) {
            ActionHandlers ret = null;
            ActionHandlers[] actionHandlersArray = ActionHandlers.values();
            int n = actionHandlersArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionHandlers h = actionHandlersArray[n2];
                if (h.actionId.equals(id)) {
                    ret = h;
                    break;
                }
                ++n2;
            }
            return ret;
        }
    }
}

