/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutable;
import org.eclipse.cdt.dsf.concurrent.DsfMultiStatus;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

@ThreadSafe
public class RequestMonitor
extends DsfExecutable {
    private final Executor fExecutor;
    private final RequestMonitor fParentRequestMonitor;
    private List<ICanceledListener> fCancelListeners;
    private IStatus fStatus = Status.OK_STATUS;
    private boolean fCanceled = false;
    private boolean fDone = false;
    private final ICanceledListener fCanceledListener;
    private String fMonitorBacktrace;

    public RequestMonitor(Executor executor, RequestMonitor parentRequestMonitor) {
        this.fExecutor = executor;
        this.fParentRequestMonitor = parentRequestMonitor;
        if (this.fParentRequestMonitor != null) {
            this.fCanceledListener = new ICanceledListener(){

                @Override
                public void requestCanceled(RequestMonitor rm) {
                    RequestMonitor.this.cancel();
                }
            };
            this.fParentRequestMonitor.addCancelListener(this.fCanceledListener);
        } else {
            this.fCanceledListener = null;
        }
        if (DEBUG_MONITORS) {
            this.createMonitorBacktrace();
        }
    }

    public synchronized void setStatus(IStatus status) {
        assert (this.isCanceled() || status.getSeverity() != 8);
        this.fStatus = status;
    }

    public synchronized IStatus getStatus() {
        if (this.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return this.fStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ICanceledListener[] listeners = null;
        RequestMonitor requestMonitor = this;
        synchronized (requestMonitor) {
            if (!this.fCanceled) {
                this.fCanceled = true;
                if (this.fCancelListeners != null) {
                    listeners = this.fCancelListeners.toArray(new ICanceledListener[this.fCancelListeners.size()]);
                }
            }
        }
        if (listeners != null) {
            ICanceledListener[] iCanceledListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ICanceledListener listener = iCanceledListenerArray[n2];
                listener.requestCanceled(this);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        boolean canceled = false;
        RequestMonitor requestMonitor = this;
        synchronized (requestMonitor) {
            canceled = this.fCanceled;
        }
        return canceled || this.fParentRequestMonitor != null && this.fParentRequestMonitor.isCanceled();
    }

    public synchronized void addCancelListener(ICanceledListener listener) {
        if (this.fCancelListeners == null) {
            this.fCancelListeners = new ArrayList<ICanceledListener>(1);
        }
        this.fCancelListeners.add(listener);
    }

    public synchronized void removeCancelListener(ICanceledListener listener) {
        if (this.fCancelListeners != null) {
            this.fCancelListeners.remove(listener);
        }
    }

    public synchronized void done() {
        this.setSubmitted();
        if (this.fDone) {
            throw new IllegalStateException("RequestMonitor: " + this + ", done() method called more than once");
        }
        this.fDone = true;
        this.fCancelListeners = null;
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.removeCancelListener(this.fCanceledListener);
        }
        if (DEBUG_MONITORS && !this.isSuccess()) {
            IStatus status = this.getStatus();
            try {
                throw new Exception();
            }
            catch (Exception e) {
                DsfPlugin.getDefault().getLog().log((IStatus)new Status(status.getSeverity(), "org.eclipse.cdt.dsf", status.getCode(), String.valueOf(status.getMessage()) + "\n\nMonitor Back Trace:\n" + this.fMonitorBacktrace.toString(), (Throwable)e));
            }
        }
        try {
            this.fExecutor.execute(new DsfRunnable(){

                @Override
                public void run() {
                    RequestMonitor.this.handleCompleted();
                }

                public String toString() {
                    return "Completed: " + RequestMonitor.this.toString();
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.handleRejectedExecutionException();
        }
    }

    public synchronized void done(IStatus status) {
        this.setStatus(status);
        this.done();
    }

    public String toString() {
        return "RequestMonitor (" + super.toString() + "): " + this.getStatus().toString();
    }

    public boolean isSuccess() {
        return !this.isCanceled() && this.getStatus().getSeverity() <= 1;
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleCompleted() {
        if (this.isSuccess()) {
            this.handleSuccess();
        } else {
            this.handleFailure();
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleSuccess() {
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.done();
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleFailure() {
        assert (!this.isSuccess());
        if (this.isCanceled()) {
            this.handleCancel();
        } else {
            if (this.getStatus().getSeverity() == 8) {
                DsfPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10005, "Request monitor: '" + this + "' resulted in a cancel status: " + this.getStatus() + ", even though the request is not set to cancel.", null));
            }
            this.handleErrorOrWarning();
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleErrorOrWarning() {
        if (this.getStatus().getSeverity() == 4) {
            this.handleError();
        } else {
            this.handleWarning();
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleError() {
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.setStatus(this.getStatus());
            this.fParentRequestMonitor.done();
        } else {
            MultiStatus logStatus = new MultiStatus("org.eclipse.cdt.dsf", 10005, "Request for monitor: '" + this.toString() + "' resulted in an error.", null);
            logStatus.merge(this.getStatus());
            DsfPlugin.getDefault().getLog().log((IStatus)logStatus);
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleWarning() {
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.setStatus(this.getStatus());
            this.fParentRequestMonitor.done();
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleCancel() {
        if (this.fParentRequestMonitor != null) {
            if (this.getStatus().getSeverity() == 8 && !this.fParentRequestMonitor.isCanceled()) {
                this.fParentRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10005, "Sub-request " + this.toString() + " was canceled and not handled.'", null));
            } else {
                this.fParentRequestMonitor.setStatus(this.getStatus());
            }
            this.fParentRequestMonitor.done();
        }
    }

    protected void handleRejectedExecutionException() {
        Object rejectedStatus = new Status(4, "org.eclipse.cdt.dsf", 10005, "Request for monitor: '" + this.toString() + "' resulted in a rejected execution exception.", null);
        if (!this.getStatus().isOK()) {
            DsfMultiStatus multiStatus = new DsfMultiStatus("org.eclipse.cdt.dsf", 0, "Composite status", null);
            multiStatus.merge(this.getStatus());
            multiStatus.merge((IStatus)rejectedStatus);
            rejectedStatus = multiStatus;
        }
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.setStatus((IStatus)rejectedStatus);
            this.fParentRequestMonitor.done();
        } else {
            DsfPlugin.getDefault().getLog().log((IStatus)rejectedStatus);
        }
    }

    private void createMonitorBacktrace() {
        StringBuilder str = new StringBuilder();
        RequestMonitor nextrm = this;
        while (nextrm != null) {
            StackTraceElement[] stackTraceElems;
            StackTraceElement[] stackTraceElementArray = stackTraceElems = nextrm.fCreatedAt != null ? nextrm.fCreatedAt.fStackTraceElements : null;
            if (stackTraceElems != null && stackTraceElems.length > 0) {
                str.append(stackTraceElems[0] + "\n");
            } else {
                str.append("<unknown>\n");
            }
            nextrm = nextrm.fParentRequestMonitor;
        }
        this.fMonitorBacktrace = str.toString();
    }

    public static interface ICanceledListener {
        public void requestCanceled(RequestMonitor var1);
    }
}

