/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.logger.collector.ui.wizard;

import org.eclipse.andmore.android.logger.collector.ui.wizard.LoggerCollectorWizardPage;
import org.eclipse.andmore.android.logger.collector.util.LoggerCollectorMessages;
import org.eclipse.andmore.android.logger.collector.util.PlatformException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class LoggerCollectorWizard
extends Wizard {
    private final LoggerCollectorWizardPage loggerCollectorWizardPage = new LoggerCollectorWizardPage("wizardPage");

    public LoggerCollectorWizard() {
        this.setWindowTitle(LoggerCollectorMessages.getInstance().getString("logger.collector.wizard.page.title"));
    }

    public boolean canFinish() {
        return this.loggerCollectorWizardPage.isPageComplete();
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.loggerCollectorWizardPage);
    }

    public boolean performFinish() {
        if (this.loggerCollectorWizardPage.getLogFileColumn() != null) {
            try {
                Path filename = new Path(this.loggerCollectorWizardPage.getFilename());
                if (filename.getFileExtension() == null || !filename.getFileExtension().equalsIgnoreCase("zip")) {
                    filename = filename.addFileExtension("zip");
                }
                if (this.loggerCollectorWizardPage.getLogFileColumn().collect(filename.toOSString())) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)LoggerCollectorMessages.getInstance().getString("logger.collector.wizard.page.title"), (String)LoggerCollectorMessages.getInstance().getString("logger.collector.wizard.success"));
                }
                return true;
            }
            catch (PlatformException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)LoggerCollectorMessages.getInstance().getString("logger.collector.wizard.page.title"), (String)e.getMessage());
                return false;
            }
        }
        return false;
    }
}

