/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.reflect;

import com.google.common.collect.Maps;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ClassMap;

public class ReflectionUtils {
    private static final ClassMap<Map<String, Method>> m_getMethodBySignature = ClassMap.create();

    private ReflectionUtils() {
    }

    public static String getFullyQualifiedName(Type type, boolean runtime) {
        Assert.isNotNull(type);
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return ReflectionUtils.getFullyQualifiedName(clazz.getComponentType(), runtime) + "[]";
            }
            String name = clazz.getName();
            if (!runtime) {
                name = name.replace('$', '.');
            }
            return name;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return ReflectionUtils.getFullyQualifiedName(genericArrayType.getGenericComponentType(), runtime) + "[]";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            StringBuilder sb = new StringBuilder();
            sb.append(ReflectionUtils.getFullyQualifiedName(rawType, runtime));
            sb.append("<");
            boolean firstTypeArgument = true;
            for (Type typeArgument : parameterizedType.getActualTypeArguments()) {
                if (!firstTypeArgument) {
                    sb.append(",");
                }
                firstTypeArgument = false;
                sb.append(ReflectionUtils.getFullyQualifiedName(typeArgument, runtime));
            }
            sb.append(">");
            return sb.toString();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return "? extends " + ReflectionUtils.getFullyQualifiedName(wildcardType.getUpperBounds()[0], runtime);
        }
        TypeVariable typeVariable = (TypeVariable)type;
        return typeVariable.getName();
    }

    private static void appendParameterTypes(StringBuilder buffer, Type[] parameterTypes) {
        buffer.append('(');
        boolean firstParameter = true;
        for (Type parameterType : parameterTypes) {
            if (firstParameter) {
                firstParameter = false;
            } else {
                buffer.append(',');
            }
            buffer.append(ReflectionUtils.getFullyQualifiedName(parameterType, false));
        }
        buffer.append(')');
    }

    public static Map<String, Method> getMethods(Class<?> clazz) {
        HashMap methods = Maps.newHashMap();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                String signature = ReflectionUtils.getMethodSignature(method);
                if (methods.containsKey(signature)) continue;
                method.setAccessible(true);
                methods.put(signature, method);
            }
        }
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            for (Method method : interfaceClass.getDeclaredMethods()) {
                String signature = ReflectionUtils.getMethodSignature(method);
                if (methods.containsKey(signature)) continue;
                method.setAccessible(true);
                methods.put(signature, method);
            }
        }
        return methods;
    }

    public static String getMethodSignature(Method method) {
        Assert.isNotNull(method);
        return ReflectionUtils.getMethodSignature(method.getName(), method.getParameterTypes());
    }

    public static String getMethodSignature(String name, Type ... parameterTypes) {
        Assert.isNotNull(name);
        Assert.isNotNull(parameterTypes);
        StringBuilder buffer = new StringBuilder();
        buffer.append(name);
        ReflectionUtils.appendParameterTypes(buffer, parameterTypes);
        return buffer.toString();
    }

    public static Method getMethodBySignature(Class<?> clazz, String signature) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(signature);
        Map<String, Method> cache = m_getMethodBySignature.get(clazz);
        if (cache == null) {
            cache = ReflectionUtils.getMethods(clazz);
            m_getMethodBySignature.put(clazz, cache);
        }
        return cache.get(signature);
    }

    public static Object invokeMethod(Object object, String signature, Object ... arguments) throws Exception {
        Assert.isNotNull(object);
        Assert.isNotNull(arguments);
        Class<?> refClass = ReflectionUtils.getRefClass(object);
        Object refObject = ReflectionUtils.getRefObject(object);
        Method method = ReflectionUtils.getMethodBySignature(refClass, signature);
        Assert.isNotNull(method, "Can not find method " + signature + " in " + refClass);
        try {
            return method.invoke(refObject, arguments);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.propagate(e.getCause());
        }
    }

    public static Object invokeMethod2(Object object, String name, Class<?>[] parameterTypes, Object[] arguments) throws Exception {
        Assert.equals(parameterTypes.length, arguments.length);
        String signature = ReflectionUtils.getMethodSignature(name, parameterTypes);
        return ReflectionUtils.invokeMethod(object, signature, arguments);
    }

    private static Class<?> getRefClass(Object object) {
        return object instanceof Class ? (Class<?>)object : object.getClass();
    }

    private static Object getRefObject(Object object) {
        return object instanceof Class ? null : object;
    }

    public static RuntimeException propagate(Throwable throwable) {
        if (System.getProperty("wbp.ReflectionUtils.propagate().forceReturn") == null) {
            ExceptionThrower.spit(throwable);
        }
        return null;
    }

    private static class ExceptionThrower {
        private static Throwable throwable;

        private ExceptionThrower() throws Throwable {
            if (System.getProperty("wbp.ReflectionUtils.propagate().InstantiationException") != null) {
                throw new InstantiationException();
            }
            if (System.getProperty("wbp.ReflectionUtils.propagate().IllegalAccessException") != null) {
                throw new IllegalAccessException();
            }
            throw throwable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static synchronized void spit(Throwable t) {
            if (System.getProperty("wbp.ReflectionUtils.propagate().dontThrow") == null) {
                throwable = t;
                try {
                    ExceptionThrower.class.newInstance();
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                finally {
                    throwable = null;
                }
            }
        }
    }
}

