/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.execution;

import java.beans.Beans;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public class ExecutionUtils {
    private ExecutionUtils() {
    }

    public static void sleep(final int millis) {
        ExecutionUtils.runIgnore(new RunnableEx(){

            @Override
            public void run() throws Exception {
                Thread.sleep(millis);
            }
        });
    }

    public static void waitEventLoop(int millis) {
        Display display = Display.getCurrent();
        if (display != null) {
            long nanos = (long)millis * 1000000L;
            long start = System.nanoTime();
            do {
                ExecutionUtils.sleep(0);
                while (display.readAndDispatch()) {
                }
            } while (System.nanoTime() - start < nanos);
        } else {
            ExecutionUtils.sleep(millis);
        }
    }

    public static boolean runIgnore(RunnableEx runnable) {
        try {
            runnable.run();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean runLog(RunnableEx runnable) {
        try {
            runnable.run();
            return true;
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
            return false;
        }
    }

    public static void runRethrow(RunnableEx runnable) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    public static void runRethrow(RunnableEx runnable, String format, Object ... args) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            String message = String.format(format, args);
            throw new RuntimeException(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runDesignTime(RunnableEx runnable) throws Exception {
        boolean old_designTime = Beans.isDesignTime();
        try {
            Beans.setDesignTime(true);
            runnable.run();
        }
        finally {
            Beans.setDesignTime(old_designTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runDesignTime(RunnableObjectEx<T> runnable) throws Exception {
        boolean old_designTime = Beans.isDesignTime();
        try {
            Beans.setDesignTime(true);
            T t = runnable.runObject();
            return t;
        }
        finally {
            Beans.setDesignTime(old_designTime);
        }
    }

    public static boolean runLogUI(final RunnableEx runnable) {
        final boolean[] success = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                success[0] = ExecutionUtils.runLog(runnable);
            }
        });
        return success[0];
    }

    public static void runRethrowUI(final RunnableEx runnable) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ExecutionUtils.runRethrow(runnable);
            }
        });
    }

    public static void runAsync(final RunnableEx runnable) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExecutionUtils.runLog(runnable);
            }
        });
    }

    public static <T> T runObjectUI(final RunnableObjectEx<T> runnable) {
        final Object[] result = new Object[1];
        ExecutionUtils.runRethrowUI(new RunnableEx(){

            @Override
            public void run() throws Exception {
                result[0] = ExecutionUtils.runObject(runnable);
            }
        });
        return (T)result[0];
    }

    public static void runLogLater(final RunnableEx runnable) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExecutionUtils.runLog(runnable);
            }
        });
    }

    public static <T> T runObject(RunnableObjectEx<T> runnable) {
        try {
            return runnable.runObject();
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    public static <T> T runObject(RunnableObjectEx<T> runnable, String format, Object ... args) {
        try {
            return runnable.runObject();
        }
        catch (Throwable e) {
            String message = String.format(format, args);
            throw new Error(message, e);
        }
    }

    public static <T> T runObjectIgnore(RunnableObjectEx<T> runnable, T defaultValue) {
        try {
            return runnable.runObject();
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static <T> T runObjectLog(RunnableObjectEx<T> runnable, T defaultValue) {
        try {
            return runnable.runObject();
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
            return defaultValue;
        }
    }
}

